/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.constant;

import com.google.common.base.Preconditions;
import com.google.common.flogger.MetadataKey;
import com.google.devtools.mobileharness.shared.constant.closeable.NonThrowingAutoCloseable;
import com.google.devtools.mobileharness.shared.util.base.StackSet;
import com.google.devtools.mobileharness.shared.util.logging.LogDataExtractor;
import java.util.function.Predicate;
import java.util.logging.LogRecord;
import javax.annotation.Nullable;

public class LogRecordImportance {
    public static final MetadataKey<Importance> IMPORTANCE = MetadataKey.single("importance", Importance.class);

    public static Importance getLogRecordImportance(LogRecord logRecord, @Nullable LogImportanceScope importanceScope) {
        Importance scopeImportance;
        Importance recordImportance = LogDataExtractor.getSingleMetadataValue(logRecord, IMPORTANCE);
        if (recordImportance != null) {
            return recordImportance;
        }
        if (importanceScope != null && (scopeImportance = importanceScope.importanceForLogRecord(logRecord)) != null) {
            return scopeImportance;
        }
        return Importance.NORMAL;
    }

    private LogRecordImportance() {
    }

    public static enum Importance {
        DEBUG(50),
        NORMAL(100),
        TEST_INFO(150),
        IMPORTANT(200),
        TF(300);

        private final int value;

        private Importance(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static class LogImportanceScope
    implements NonThrowingAutoCloseable {
        private static final ThreadLocal<StackSet<LogImportanceScope>> SCOPES = ThreadLocal.withInitial(StackSet::new);
        private final Importance importance;
        private final Predicate<LogRecord> logRecordFilter;

        @Nullable
        public static LogImportanceScope getCurrentScope() {
            return SCOPES.get().getLast();
        }

        public LogImportanceScope(Importance importance, Predicate<LogRecord> logRecordFilter) {
            this.importance = Preconditions.checkNotNull(importance);
            this.logRecordFilter = Preconditions.checkNotNull(logRecordFilter);
            SCOPES.get().add(this);
        }

        @Override
        public void close() {
            SCOPES.get().removeUntilLast(this);
        }

        @Nullable
        public Importance importanceForLogRecord(LogRecord logRecord) {
            return this.logRecordFilter.test(logRecord) ? this.importance : null;
        }
    }
}

