/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite.subplan;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.FluentLogger;
import com.google.common.primitives.Longs;
import com.google.devtools.mobileharness.api.model.error.ExtErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.console.result.proto.ReportProto;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import com.google.devtools.mobileharness.platform.android.xts.config.ConfigurationUtil;
import com.google.devtools.mobileharness.platform.android.xts.config.proto.ConfigurationProto;
import com.google.devtools.mobileharness.platform.android.xts.suite.SuiteTestFilter;
import com.google.devtools.mobileharness.platform.android.xts.suite.retry.PreviousResultLoader;
import com.google.devtools.mobileharness.platform.android.xts.suite.subplan.AddSubPlanArgs;
import com.google.devtools.mobileharness.platform.android.xts.suite.subplan.ResultType;
import com.google.devtools.mobileharness.platform.android.xts.suite.subplan.SubPlan;
import com.google.devtools.mobileharness.platform.android.xts.suite.subplan.SubPlanHelper;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import com.google.protobuf.ProtocolStringList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class SubPlanCreator {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String XML_EXT = ".xml";
    private final PreviousResultLoader previousResultLoader;
    private final ConfigurationUtil configurationUtil;
    private final LocalFileUtil localFileUtil;

    @Inject
    SubPlanCreator(PreviousResultLoader previousResultLoader, LocalFileUtil localFileUtil, ConfigurationUtil configurationUtil) {
        this.previousResultLoader = previousResultLoader;
        this.localFileUtil = localFileUtil;
        this.configurationUtil = configurationUtil;
    }

    public Optional<File> createAndSerializeSubPlan(AddSubPlanArgs addSubPlanArgs) throws MobileHarnessException {
        String module;
        Path xtsRootDir = addSubPlanArgs.xtsRootDir();
        String xtsType = addSubPlanArgs.xtsType();
        int sessionIndex = addSubPlanArgs.sessionIndex();
        Optional<String> subPlanName = addSubPlanArgs.subPlanName();
        ImmutableSet<String> resultTypes = this.getResultTypes(addSubPlanArgs.resultTypes());
        ReportProto.Result previousResult = this.previousResultLoader.loadPreviousResult(XtsDirUtil.getXtsResultsDir(xtsRootDir, xtsType), sessionIndex, null);
        Optional<ReportProto.Attribute> startTimeAttr = previousResult.getAttributeList().stream().filter(attr -> attr.getKey().equals("start")).findFirst();
        Long startTimeMillis = startTimeAttr.isPresent() ? Longs.tryParse(startTimeAttr.get().getValue()) : null;
        File subPlanFile = this.getSubPlanFile(xtsRootDir, xtsType, subPlanName.orElse(null), sessionIndex, resultTypes, startTimeMillis == null ? 0L : startTimeMillis);
        ProtocolStringList includeFiltersFromPrevResult = previousResult.getIncludeFilterList();
        ProtocolStringList excludeFiltersFromPrevResult = previousResult.getExcludeFilterList();
        SubPlan subPlan = SubPlanHelper.createSubPlanForPreviousResult(previousResult, resultTypes, true, includeFiltersFromPrevResult.stream().map(SuiteTestFilter::create).collect(ImmutableSet.toImmutableSet()), excludeFiltersFromPrevResult.stream().map(SuiteTestFilter::create).collect(ImmutableSet.toImmutableSet()), ImmutableSet.of());
        if (!addSubPlanArgs.passedInIncludeFilters().isEmpty() || !addSubPlanArgs.passedInExcludeFilters().isEmpty()) {
            ImmutableMap<String, ConfigurationProto.Configuration> configsMap = this.configurationUtil.getConfigsV2FromDirs(ImmutableList.of(XtsDirUtil.getXtsTestCasesDir(xtsRootDir, xtsType).toFile()));
            ImmutableSet<String> allNonTfModules = configsMap.values().stream().map(config -> config.getMetadata().getXtsModule()).collect(ImmutableSet.toImmutableSet());
            SubPlanHelper.addPassedInFiltersToSubPlan(subPlan, addSubPlanArgs.passedInIncludeFilters().stream().map(SuiteTestFilter::create).collect(ImmutableSet.toImmutableSet()), addSubPlanArgs.passedInExcludeFilters().stream().map(SuiteTestFilter::create).collect(ImmutableSet.toImmutableSet()), allNonTfModules);
        }
        if (!(module = addSubPlanArgs.module().orElse("")).isEmpty()) {
            String moduleWithAbi = addSubPlanArgs.abi().isPresent() ? String.format("%s %s", addSubPlanArgs.abi().get(), module) : module;
            String test = addSubPlanArgs.test().orElse("");
            String includeEntry = moduleWithAbi + (String)(Strings.isNullOrEmpty(test) ? "" : " " + test);
            if (addSubPlanArgs.isNonTradefedModule()) {
                subPlan.addNonTfIncludeFilter(includeEntry);
            } else {
                subPlan.addIncludeFilter(includeEntry);
            }
        }
        try {
            subPlan.serialize(new BufferedOutputStream(new FileOutputStream(subPlanFile)), false, true);
            ((FluentLogger.Api)logger.atInfo()).log("Created subplan at %s", subPlanFile.getAbsolutePath());
            return Optional.of(subPlanFile);
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Failed to create subplan file %s", subPlanFile.getAbsolutePath());
            return Optional.empty();
        }
    }

    private ImmutableSet<String> getResultTypes(ImmutableSet<ResultType> resultTypes) {
        if (resultTypes.isEmpty()) {
            return Arrays.stream(ResultType.values()).map(resultType -> Ascii.toLowerCase(resultType.name())).collect(ImmutableSet.toImmutableSet());
        }
        return resultTypes.stream().map(resultType -> Ascii.toLowerCase(resultType.name())).collect(ImmutableSet.toImmutableSet());
    }

    private File getSubPlanFile(Path xtsRootDir, String xtsType, @Nullable String subPlanName, int sessionIndex, ImmutableSet<String> resultTypes, long prevSessionStartTime) throws MobileHarnessException {
        Path newSubPlanFile;
        Path subPlansDir = XtsDirUtil.getXtsSubPlansDir(xtsRootDir, xtsType);
        if (!this.localFileUtil.isDirExist(subPlansDir)) {
            this.localFileUtil.prepareDir(subPlansDir, new FileAttribute[0]);
        }
        if (this.localFileUtil.isFileExist(newSubPlanFile = subPlansDir.resolve(this.getSubPlanName(subPlanName, sessionIndex, resultTypes, prevSessionStartTime) + XML_EXT))) {
            throw new MobileHarnessException(ExtErrorId.SUBPLAN_CREATOR_SUBPLAN_FILE_ALREADY_EXISTED, String.format("Subplan file %s already existed", newSubPlanFile));
        }
        return newSubPlanFile.toFile();
    }

    private String getSubPlanName(@Nullable String subPlanName, int sessionIndex, ImmutableSet<String> resultTypes, long prevSessionStartTime) {
        return subPlanName == null ? this.createSubPlanName(sessionIndex, resultTypes, prevSessionStartTime) : subPlanName;
    }

    private String createSubPlanName(int sessionIndex, ImmutableSet<String> resultTypes, long prevSessionStartTime) {
        StringBuilder sb = new StringBuilder();
        Joiner.on("_").appendTo(sb, (Iterable<?>)resultTypes);
        sb.append("_");
        sb.append(sessionIndex);
        sb.append("_");
        sb.append(XtsDirUtil.getDirSuffix(Instant.ofEpochMilli(prevSessionStartTime)));
        return sb.toString();
    }
}

