/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.common.util;

import com.google.common.base.Ascii;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Locale;

public class XtsDirUtil {
    public static String getDirSuffix(Instant time) {
        return new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss", Locale.getDefault()).format(new Timestamp(time.toEpochMilli()));
    }

    public static Path getXtsJdkDir(Path xtsRootDir, String xtsType) {
        return xtsRootDir.resolve(String.format("android-%s/jdk", Ascii.toLowerCase(xtsType)));
    }

    public static Path getXtsJavaBinary(Path xtsRootDir, String xtsType) {
        return XtsDirUtil.getXtsJdkDir(xtsRootDir, xtsType).resolve("bin/java");
    }

    public static Path getXtsLibDir(Path xtsRootDir, String xtsType) {
        return xtsRootDir.resolve(String.format("android-%s/lib", Ascii.toLowerCase(xtsType)));
    }

    public static Path getXtsLib64Dir(Path xtsRootDir, String xtsType) {
        return xtsRootDir.resolve(String.format("android-%s/lib64", Ascii.toLowerCase(xtsType)));
    }

    public static Path getXtsLogsDir(Path xtsRootDir, String xtsType) {
        return xtsRootDir.resolve(String.format("android-%s/logs", Ascii.toLowerCase(xtsType)));
    }

    public static Path getXtsResultsDir(Path xtsRootDir, String xtsType) {
        return xtsRootDir.resolve(String.format("android-%s/results", Ascii.toLowerCase(xtsType)));
    }

    public static Path getXtsSubPlansDir(Path xtsRootDir, String xtsType) {
        return xtsRootDir.resolve(String.format("android-%s/subplans", Ascii.toLowerCase(xtsType)));
    }

    public static Path getXtsTestCasesDir(Path xtsRootDir, String xtsType) {
        return xtsRootDir.resolve(String.format("android-%s/testcases", xtsType));
    }

    public static Path getXtsToolsDir(Path xtsRootDir, String xtsType) {
        return xtsRootDir.resolve(String.format("android-%s/tools", Ascii.toLowerCase(xtsType)));
    }

    private XtsDirUtil() {
    }
}

