/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.grpc;

import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcStubUtil;
import com.google.devtools.mobileharness.api.model.error.InfraErrorId;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.ControlServiceGrpc;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.ControlServiceProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.ControlStub;
import com.google.devtools.mobileharness.shared.util.comm.stub.Stubs;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.time.Duration;

public class ControlGrpcStub
implements ControlStub {
    private final ControlServiceGrpc.ControlServiceBlockingStub controlServiceBlockingStub;
    private final ControlServiceGrpc.ControlServiceStub controlServiceStub;

    public ControlGrpcStub(Channel channel) {
        this.controlServiceBlockingStub = ControlServiceGrpc.newBlockingStub(channel);
        this.controlServiceStub = ControlServiceGrpc.newStub(channel);
    }

    @Override
    public ControlServiceProto.KillServerResponse killServer(ControlServiceProto.KillServerRequest request) throws GrpcExceptionWithErrorId {
        return GrpcStubUtil.invoke(Stubs.withDeadline(this.controlServiceBlockingStub, Duration.ofSeconds(20L))::killServer, request, InfraErrorId.OLCS_STUB_KILL_SERVER_ERROR, "Failed to kill server");
    }

    @Override
    public StreamObserver<ControlServiceProto.GetLogRequest> getLog(StreamObserver<ControlServiceProto.GetLogResponse> responseObserver) {
        return this.controlServiceStub.getLog(responseObserver);
    }

    @Override
    public void setLogLevel(ControlServiceProto.SetLogLevelRequest request) throws GrpcExceptionWithErrorId {
        GrpcStubUtil.invoke(Stubs.withDeadline(this.controlServiceBlockingStub, Duration.ofSeconds(20L))::setLogLevel, request, InfraErrorId.OLCS_STUB_SET_LOG_LEVEL_ERROR, "Failed to set log level");
    }

    @Override
    public void heartbeat(ControlServiceProto.HeartbeatRequest request) throws GrpcExceptionWithErrorId {
        GrpcStubUtil.invoke(Stubs.withDeadline(this.controlServiceBlockingStub, Duration.ofSeconds(20L))::heartbeat, request, InfraErrorId.OLCS_STUB_HEARTBEAT_ERROR, "Failed to send heartbeat");
    }
}

