/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.console;

import com.google.common.base.Preconditions;
import com.google.devtools.mobileharness.infra.ats.console.Annotations;
import com.google.devtools.mobileharness.infra.ats.console.util.command.CommandHelper;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.UserInterruptException;

@Singleton
public class InterruptibleLineReader {
    private final LineReader lineReader;
    private final ConsoleUtil consoleUtil;
    private final CommandHelper commandHelper;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private Thread runningThread;
    @GuardedBy(value="lock")
    private boolean interrupted;

    @Inject
    InterruptibleLineReader(@Annotations.ConsoleLineReader LineReader lineReader, ConsoleUtil consoleUtil, CommandHelper commandHelper) {
        this.lineReader = lineReader;
        this.consoleUtil = consoleUtil;
        this.commandHelper = commandHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> readLine() {
        Optional<String> optional = this.lock;
        synchronized (optional) {
            Preconditions.checkState(this.runningThread == null);
            if (this.interrupted) {
                this.interrupted = false;
                return Optional.empty();
            }
            this.runningThread = Thread.currentThread();
        }
        try {
            optional = Optional.of(this.lineReader.readLine(String.format("%s-console > ", this.commandHelper.getXtsType())));
            return optional;
        }
        catch (UserInterruptException e) {
            this.consoleUtil.printlnStderr("Interrupted by the user.");
            Optional<String> optional2 = Optional.empty();
            return optional2;
        }
        catch (EndOfFileException e) {
            this.consoleUtil.printlnStderr("Received EOF.");
            Optional<String> optional3 = Optional.empty();
            return optional3;
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                Thread.interrupted();
                this.runningThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        this.consoleUtil.printlnStdout("Exiting...");
        Object object = this.lock;
        synchronized (object) {
            if (this.runningThread == null) {
                this.consoleUtil.printlnStderr("Stop line reader");
                this.interrupted = true;
            } else {
                this.consoleUtil.printlnStderr("Interrupt line reader");
                this.runningThread.interrupt();
            }
        }
    }
}

