/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.common.base.Ascii;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.Annotations;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerPreparer;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.ControlServiceProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.ControlStub;
import com.google.devtools.mobileharness.shared.util.base.StrUtil;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="set", aliases={"s"}, sortOptions=false, description={"Set console configurations."}, synopsisSubcommandLabel="", subcommands={CommandLine.HelpCommand.class})
class SetCommand {
    private final ConsoleInfo consoleInfo;
    private final ConsoleUtil consoleUtil;
    private final ServerPreparer serverPreparer;
    private final ControlStub controlStub;

    @Inject
    SetCommand(ConsoleInfo consoleInfo, ConsoleUtil consoleUtil, ServerPreparer serverPreparer, @Annotations.ServerStub(value=Annotations.ServerStub.Type.CONTROL_SERVICE) ControlStub controlStub) {
        this.consoleInfo = consoleInfo;
        this.consoleUtil = consoleUtil;
        this.serverPreparer = serverPreparer;
        this.controlStub = controlStub;
    }

    @CommandLine.Command(name="log-level-display", description={"Sets the global display log level to <level>"})
    public int setLogLevelDisplay(String level) throws MobileHarnessException, GrpcExceptionWithErrorId, InterruptedException {
        this.serverPreparer.prepareOlcServer();
        this.controlStub.setLogLevel(ControlServiceProto.SetLogLevelRequest.newBuilder().setLevel(level).build());
        this.consoleUtil.printlnStdout("Log level now set to '%s'.", Ascii.toUpperCase(level));
        return 0;
    }

    @CommandLine.Command(name="python-package-index-url", description={"Sets the global base URL of python package index to <python-package-index-url>"})
    public int setPythonPackageIndexUrl(String pythonPackageIndexUrl) {
        if (!StrUtil.isEmptyOrWhitespace(pythonPackageIndexUrl)) {
            this.consoleInfo.setPythonPackageIndexUrl(pythonPackageIndexUrl.trim());
            this.consoleUtil.printlnStdout("Base URL of Python Package Index now set to '%s'.", pythonPackageIndexUrl.trim());
        }
        return 0;
    }
}

