/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerPreparer;
import com.google.devtools.mobileharness.infra.ats.console.controller.olcserver.AtsSessionStub;
import com.google.devtools.mobileharness.infra.ats.console.controller.proto.SessionPluginProto;
import com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.AtsSessionPluginConfigOutput;
import com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.PluginOutputPrinter;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.SessionServiceProto;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="invocation", aliases={"i"}, sortOptions=false, description={"Invocation information and operations."}, synopsisSubcommandLabel="", subcommands={CommandLine.HelpCommand.class})
class InvocationCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", paramLabel="<command_id>", hideParamSyntax=true, description={"Command ID."})
    private String commandId;
    private final ConsoleUtil consoleUtil;
    private final ServerPreparer serverPreparer;
    private final AtsSessionStub atsSessionStub;

    @Inject
    InvocationCommand(ConsoleUtil consoleUtil, ServerPreparer serverPreparer, AtsSessionStub atsSessionStub) {
        this.consoleUtil = consoleUtil;
        this.serverPreparer = serverPreparer;
        this.atsSessionStub = atsSessionStub;
    }

    @Override
    public Integer call() throws MobileHarnessException, InterruptedException {
        this.serverPreparer.prepareOlcServer();
        ImmutableList<AtsSessionPluginConfigOutput> sessionPluginConfigOutputs = this.atsSessionStub.getAllUnfinishedSessions("run_command", true);
        return PluginOutputPrinter.showCommandInvocations(sessionPluginConfigOutputs, this.commandId, this.consoleUtil);
    }

    @CommandLine.Command(name="stop", description={"Stop the given invocation."})
    public Integer stop() throws MobileHarnessException, InterruptedException {
        this.serverPreparer.prepareOlcServer();
        SessionServiceProto.NotifyAllSessionsResponse response = this.atsSessionStub.cancelSessionByCommandId(this.commandId, SessionPluginProto.AtsSessionPluginNotification.newBuilder().setSessionCancellation(SessionPluginProto.AtsSessionCancellation.newBuilder().setReason("Stop the session by InvocationCommand.")).build());
        if (response.getSessionIdList().isEmpty()) {
            this.consoleUtil.printlnStdout(String.format("Could not stop invocation %s, try 'list invocation' or 'invocation %s' for more information.", this.commandId, this.commandId));
        } else {
            this.consoleUtil.printlnStdout(String.format("Invocation %s has been requested to stop. It may take some times.", this.commandId));
        }
        return 0;
    }
}

