/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common.plan;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.plan.AutoValue_PlanConfigUtil_PlanConfigInfo;
import com.google.devtools.mobileharness.infra.ats.common.plan.JarFileUtil;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.error.MoreThrowables;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import com.google.devtools.mobileharness.shared.util.path.FileNameUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PlanConfigUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final ImmutableSet<String> SUPPORTED_EXTENSIONS = ImmutableSet.of("xml", "config");
    private static final String CONFIG_PREFIX = "config/";
    private final JarFileUtil jarFileUtil;
    private final LocalFileUtil localFileUtil;
    private final FileNameUtil fileNameUtil;

    @Inject
    PlanConfigUtil(JarFileUtil jarFileUtil, LocalFileUtil localFileUtil, FileNameUtil fileNameUtil) {
        this.jarFileUtil = jarFileUtil;
        this.localFileUtil = localFileUtil;
        this.fileNameUtil = fileNameUtil;
    }

    public ImmutableMap<String, PlanConfigInfo> loadAllConfigsInfo(Path dir) {
        ImmutableMap.Builder<String, PlanConfigInfo> configNameToPlanConfigInfo = ImmutableMap.builder();
        try {
            List<Path> jars = this.localFileUtil.listFilePaths(dir, false, p -> p.getFileName().toString().endsWith(".jar"));
            ImmutableMap<String, Path> configNameToJar = this.getConfigsFromJars(jars, null);
            for (Map.Entry entry : configNameToJar.entrySet()) {
                Path jarPath;
                String configName = (String)entry.getKey();
                Optional<Document> document = this.loadConfig(configName, jarPath = (Path)entry.getValue());
                if (document.isEmpty()) continue;
                configNameToPlanConfigInfo.put(configName, this.loadPlanConfigInfo(configName, jarPath, document.get()));
            }
        }
        catch (MobileHarnessException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to load plan configs from JAR files in dir %s: %s", (Object)dir, (Object)MoreThrowables.shortDebugString(e));
        }
        return configNameToPlanConfigInfo.buildOrThrow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Document> loadConfig(String configName, Path jar) {
        Optional<InputStream> configStream = this.getBundledConfigStream(jar, configName).or(() -> this.getLocalConfigStream(configName));
        if (configStream.isEmpty()) {
            return Optional.empty();
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(configStream.get());){
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(bufferedInputStream);
                return Optional.of(document);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to load the config [%s] from %s: %s", configName, jar, MoreThrowables.shortDebugString(e));
                Optional<Document> optional = Optional.empty();
                bufferedInputStream.close();
                return optional;
            }
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to load the config [%s] from %s: %s", configName, jar, MoreThrowables.shortDebugString(e));
            return Optional.empty();
        }
    }

    public Optional<InputStream> getBundledConfigStream(Path jar, String name) {
        String ext = this.fileNameUtil.getExtension(name);
        if (Strings.isNullOrEmpty(ext)) {
            for (String supportedExt : SUPPORTED_EXTENSIONS) {
                Optional<InputStream> inputStream = this.jarFileUtil.getZipEntryInputStream(jar, String.format("%s%s.%s", this.getConfigPrefix(), name, supportedExt));
                if (!inputStream.isPresent()) continue;
                return inputStream;
            }
            return Optional.empty();
        }
        return this.jarFileUtil.getZipEntryInputStream(jar, String.format("%s%s", this.getConfigPrefix(), name));
    }

    private Optional<InputStream> getLocalConfigStream(String configName) {
        Path configPath = Path.of(configName, new String[0]);
        if (this.localFileUtil.isFileExist(configPath)) {
            try {
                return Optional.of(this.localFileUtil.newInputStream(configPath));
            }
            catch (MobileHarnessException e) {
                ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Failed to get input stream for local config file %s", configPath);
                return Optional.empty();
            }
        }
        ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to find local config %s", configName);
        return Optional.empty();
    }

    private PlanConfigInfo loadPlanConfigInfo(String configName, Path jar, Document document) {
        return PlanConfigInfo.of(configName, jar, document.getDocumentElement().getAttribute("description"));
    }

    private ImmutableMap<String, Path> getConfigsFromJars(List<Path> jarFiles, @Nullable String subPath) {
        return this.jarFileUtil.getEntriesFromJars(jarFiles, new ConfigInJarFilter(subPath));
    }

    private String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @AutoValue
    public static abstract class PlanConfigInfo {
        public static PlanConfigInfo of(String configName, Path source, String description) {
            return new AutoValue_PlanConfigUtil_PlanConfigInfo(configName, source, description);
        }

        public abstract String configName();

        public abstract Path source();

        public abstract String description();
    }

    private class ConfigInJarFilter
    implements JarFileUtil.EntryFilter {
        private String prefix;

        public ConfigInJarFilter(String prefixSubPath) {
            this.prefix = PlanConfigUtil.this.getConfigPrefix();
            if (prefixSubPath != null) {
                this.prefix = this.prefix + prefixSubPath;
            }
        }

        @Override
        public boolean accept(String pathName) {
            String extension = PlanConfigUtil.this.fileNameUtil.getExtension(pathName);
            return pathName.startsWith(this.prefix) && SUPPORTED_EXTENSIONS.contains(extension);
        }

        @Override
        public String transform(String pathName) {
            int pathStartIndex = PlanConfigUtil.this.getConfigPrefix().length();
            String extension = PlanConfigUtil.this.fileNameUtil.getExtension(pathName);
            int pathEndIndex = pathName.length() - (extension.length() + 1);
            return pathName.substring(pathStartIndex, pathEndIndex);
        }
    }
}

