/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.mobileharness.infra.ats.common.SessionRequestInfo;
import com.google.devtools.mobileharness.infra.ats.common.proto.XtsCommonProto;
import com.google.devtools.mobileharness.infra.ats.server.proto.ServiceProto;
import com.google.devtools.mobileharness.platform.android.xts.config.proto.ConfigurationProto;
import com.google.devtools.mobileharness.platform.android.xts.suite.TestSuiteHelper;
import com.google.devtools.mobileharness.platform.android.xts.suite.TestSuiteInfo;
import com.google.devtools.mobileharness.platform.android.xts.suite.retry.RetryType;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

final class AutoValue_SessionRequestInfo
extends SessionRequestInfo {
    private final String testPlan;
    private final String commandLineArgs;
    private final String xtsRootDir;
    private final Optional<String> androidXtsZip;
    private final Optional<String> androidXtsZipDownloadUrl;
    private final ImmutableList<String> deviceSerials;
    private final Optional<TestSuiteHelper.DeviceInfo> deviceInfo;
    private final ImmutableList<String> excludeDeviceSerials;
    private final ImmutableList<String> productTypes;
    private final ImmutableMap<String, String> deviceProperties;
    private final ImmutableList<String> moduleNames;
    private final Optional<String> testName;
    private final Optional<Integer> shardCount;
    private final ImmutableList<String> includeFilters;
    private final ImmutableList<String> excludeFilters;
    private final ImmutableMultimap<String, String> moduleMetadataIncludeFilters;
    private final ImmutableMultimap<String, String> moduleMetadataExcludeFilters;
    private final Optional<Integer> retrySessionIndex;
    private final Optional<String> retrySessionResultDirName;
    private final Optional<String> retrySessionId;
    private final Optional<RetryType> retryType;
    private final Optional<String> retryResultDir;
    private final ImmutableList<String> moduleArgs;
    private final ImmutableList<String> extraArgs;
    private final String xtsType;
    private final Optional<String> pythonPkgIndexUrl;
    private final ImmutableSet<String> givenMatchedNonTfModules;
    private final ImmutableMap<String, ConfigurationProto.Configuration> v2ConfigsMap;
    private final ImmutableMap<String, ConfigurationProto.Configuration> expandedModules;
    private final boolean enableModuleParameter;
    private final boolean enableModuleOptionalParameter;
    private final Duration jobTimeout;
    private final Duration startTimeout;
    private final ImmutableMap<String, String> envVars;
    private final Optional<String> subPlanName;
    private final Optional<String> subPlanNameBackup;
    private final boolean htmlInZip;
    private final Optional<String> sessionClientId;
    private final Optional<String> deviceType;
    private final Optional<Integer> maxBatteryLevel;
    private final Optional<Integer> minBatteryLevel;
    private final Optional<Integer> maxBatteryTemperature;
    private final Optional<Integer> minSdkLevel;
    private final Optional<Integer> maxSdkLevel;
    private final boolean isAtsServerRequest;
    private final Optional<String> remoteRunnerFilePathPrefix;
    private final boolean reportSystemCheckers;
    private final XtsCommonProto.ShardingMode shardingMode;
    private final Optional<Boolean> skipDeviceInfo;
    private final Optional<Boolean> isXtsDynamicDownloadEnabled;
    private final ImmutableMap<String, String> xtsSuiteInfo;
    private final Optional<TestSuiteInfo> testSuiteInfo;
    private final ImmutableSet<String> excludeRunners;
    private final ImmutableList<ServiceProto.TestResource> atsServerTestResources;
    private final Optional<ServiceProto.TestEnvironment> atsServerTestEnvironment;
    private final boolean allowPartialDeviceMatch;
    private final Optional<Boolean> enableDefaultLogs;

    private AutoValue_SessionRequestInfo(String testPlan, String commandLineArgs, String xtsRootDir, Optional<String> androidXtsZip, Optional<String> androidXtsZipDownloadUrl, ImmutableList<String> deviceSerials, Optional<TestSuiteHelper.DeviceInfo> deviceInfo, ImmutableList<String> excludeDeviceSerials, ImmutableList<String> productTypes, ImmutableMap<String, String> deviceProperties, ImmutableList<String> moduleNames, Optional<String> testName, Optional<Integer> shardCount, ImmutableList<String> includeFilters, ImmutableList<String> excludeFilters, ImmutableMultimap<String, String> moduleMetadataIncludeFilters, ImmutableMultimap<String, String> moduleMetadataExcludeFilters, Optional<Integer> retrySessionIndex, Optional<String> retrySessionResultDirName, Optional<String> retrySessionId, Optional<RetryType> retryType, Optional<String> retryResultDir, ImmutableList<String> moduleArgs, ImmutableList<String> extraArgs, String xtsType, Optional<String> pythonPkgIndexUrl, ImmutableSet<String> givenMatchedNonTfModules, ImmutableMap<String, ConfigurationProto.Configuration> v2ConfigsMap, ImmutableMap<String, ConfigurationProto.Configuration> expandedModules, boolean enableModuleParameter, boolean enableModuleOptionalParameter, Duration jobTimeout, Duration startTimeout, ImmutableMap<String, String> envVars, Optional<String> subPlanName, Optional<String> subPlanNameBackup, boolean htmlInZip, Optional<String> sessionClientId, Optional<String> deviceType, Optional<Integer> maxBatteryLevel, Optional<Integer> minBatteryLevel, Optional<Integer> maxBatteryTemperature, Optional<Integer> minSdkLevel, Optional<Integer> maxSdkLevel, boolean isAtsServerRequest, Optional<String> remoteRunnerFilePathPrefix, boolean reportSystemCheckers, XtsCommonProto.ShardingMode shardingMode, Optional<Boolean> skipDeviceInfo, Optional<Boolean> isXtsDynamicDownloadEnabled, ImmutableMap<String, String> xtsSuiteInfo, Optional<TestSuiteInfo> testSuiteInfo, ImmutableSet<String> excludeRunners, ImmutableList<ServiceProto.TestResource> atsServerTestResources, Optional<ServiceProto.TestEnvironment> atsServerTestEnvironment, boolean allowPartialDeviceMatch, Optional<Boolean> enableDefaultLogs) {
        this.testPlan = testPlan;
        this.commandLineArgs = commandLineArgs;
        this.xtsRootDir = xtsRootDir;
        this.androidXtsZip = androidXtsZip;
        this.androidXtsZipDownloadUrl = androidXtsZipDownloadUrl;
        this.deviceSerials = deviceSerials;
        this.deviceInfo = deviceInfo;
        this.excludeDeviceSerials = excludeDeviceSerials;
        this.productTypes = productTypes;
        this.deviceProperties = deviceProperties;
        this.moduleNames = moduleNames;
        this.testName = testName;
        this.shardCount = shardCount;
        this.includeFilters = includeFilters;
        this.excludeFilters = excludeFilters;
        this.moduleMetadataIncludeFilters = moduleMetadataIncludeFilters;
        this.moduleMetadataExcludeFilters = moduleMetadataExcludeFilters;
        this.retrySessionIndex = retrySessionIndex;
        this.retrySessionResultDirName = retrySessionResultDirName;
        this.retrySessionId = retrySessionId;
        this.retryType = retryType;
        this.retryResultDir = retryResultDir;
        this.moduleArgs = moduleArgs;
        this.extraArgs = extraArgs;
        this.xtsType = xtsType;
        this.pythonPkgIndexUrl = pythonPkgIndexUrl;
        this.givenMatchedNonTfModules = givenMatchedNonTfModules;
        this.v2ConfigsMap = v2ConfigsMap;
        this.expandedModules = expandedModules;
        this.enableModuleParameter = enableModuleParameter;
        this.enableModuleOptionalParameter = enableModuleOptionalParameter;
        this.jobTimeout = jobTimeout;
        this.startTimeout = startTimeout;
        this.envVars = envVars;
        this.subPlanName = subPlanName;
        this.subPlanNameBackup = subPlanNameBackup;
        this.htmlInZip = htmlInZip;
        this.sessionClientId = sessionClientId;
        this.deviceType = deviceType;
        this.maxBatteryLevel = maxBatteryLevel;
        this.minBatteryLevel = minBatteryLevel;
        this.maxBatteryTemperature = maxBatteryTemperature;
        this.minSdkLevel = minSdkLevel;
        this.maxSdkLevel = maxSdkLevel;
        this.isAtsServerRequest = isAtsServerRequest;
        this.remoteRunnerFilePathPrefix = remoteRunnerFilePathPrefix;
        this.reportSystemCheckers = reportSystemCheckers;
        this.shardingMode = shardingMode;
        this.skipDeviceInfo = skipDeviceInfo;
        this.isXtsDynamicDownloadEnabled = isXtsDynamicDownloadEnabled;
        this.xtsSuiteInfo = xtsSuiteInfo;
        this.testSuiteInfo = testSuiteInfo;
        this.excludeRunners = excludeRunners;
        this.atsServerTestResources = atsServerTestResources;
        this.atsServerTestEnvironment = atsServerTestEnvironment;
        this.allowPartialDeviceMatch = allowPartialDeviceMatch;
        this.enableDefaultLogs = enableDefaultLogs;
    }

    @Override
    public String testPlan() {
        return this.testPlan;
    }

    @Override
    public String commandLineArgs() {
        return this.commandLineArgs;
    }

    @Override
    public String xtsRootDir() {
        return this.xtsRootDir;
    }

    @Override
    public Optional<String> androidXtsZip() {
        return this.androidXtsZip;
    }

    @Override
    public Optional<String> androidXtsZipDownloadUrl() {
        return this.androidXtsZipDownloadUrl;
    }

    @Override
    public ImmutableList<String> deviceSerials() {
        return this.deviceSerials;
    }

    @Override
    public Optional<TestSuiteHelper.DeviceInfo> deviceInfo() {
        return this.deviceInfo;
    }

    @Override
    public ImmutableList<String> excludeDeviceSerials() {
        return this.excludeDeviceSerials;
    }

    @Override
    public ImmutableList<String> productTypes() {
        return this.productTypes;
    }

    @Override
    public ImmutableMap<String, String> deviceProperties() {
        return this.deviceProperties;
    }

    @Override
    public ImmutableList<String> moduleNames() {
        return this.moduleNames;
    }

    @Override
    public Optional<String> testName() {
        return this.testName;
    }

    @Override
    public Optional<Integer> shardCount() {
        return this.shardCount;
    }

    @Override
    public ImmutableList<String> includeFilters() {
        return this.includeFilters;
    }

    @Override
    public ImmutableList<String> excludeFilters() {
        return this.excludeFilters;
    }

    @Override
    public ImmutableMultimap<String, String> moduleMetadataIncludeFilters() {
        return this.moduleMetadataIncludeFilters;
    }

    @Override
    public ImmutableMultimap<String, String> moduleMetadataExcludeFilters() {
        return this.moduleMetadataExcludeFilters;
    }

    @Override
    public Optional<Integer> retrySessionIndex() {
        return this.retrySessionIndex;
    }

    @Override
    public Optional<String> retrySessionResultDirName() {
        return this.retrySessionResultDirName;
    }

    @Override
    public Optional<String> retrySessionId() {
        return this.retrySessionId;
    }

    @Override
    public Optional<RetryType> retryType() {
        return this.retryType;
    }

    @Override
    public Optional<String> retryResultDir() {
        return this.retryResultDir;
    }

    @Override
    public ImmutableList<String> moduleArgs() {
        return this.moduleArgs;
    }

    @Override
    public ImmutableList<String> extraArgs() {
        return this.extraArgs;
    }

    @Override
    public String xtsType() {
        return this.xtsType;
    }

    @Override
    public Optional<String> pythonPkgIndexUrl() {
        return this.pythonPkgIndexUrl;
    }

    @Override
    public ImmutableSet<String> givenMatchedNonTfModules() {
        return this.givenMatchedNonTfModules;
    }

    @Override
    public ImmutableMap<String, ConfigurationProto.Configuration> v2ConfigsMap() {
        return this.v2ConfigsMap;
    }

    @Override
    public ImmutableMap<String, ConfigurationProto.Configuration> expandedModules() {
        return this.expandedModules;
    }

    @Override
    public boolean enableModuleParameter() {
        return this.enableModuleParameter;
    }

    @Override
    public boolean enableModuleOptionalParameter() {
        return this.enableModuleOptionalParameter;
    }

    @Override
    public Duration jobTimeout() {
        return this.jobTimeout;
    }

    @Override
    public Duration startTimeout() {
        return this.startTimeout;
    }

    @Override
    public ImmutableMap<String, String> envVars() {
        return this.envVars;
    }

    @Override
    public Optional<String> subPlanName() {
        return this.subPlanName;
    }

    @Override
    public Optional<String> subPlanNameBackup() {
        return this.subPlanNameBackup;
    }

    @Override
    public boolean htmlInZip() {
        return this.htmlInZip;
    }

    @Override
    public Optional<String> sessionClientId() {
        return this.sessionClientId;
    }

    @Override
    public Optional<String> deviceType() {
        return this.deviceType;
    }

    @Override
    public Optional<Integer> maxBatteryLevel() {
        return this.maxBatteryLevel;
    }

    @Override
    public Optional<Integer> minBatteryLevel() {
        return this.minBatteryLevel;
    }

    @Override
    public Optional<Integer> maxBatteryTemperature() {
        return this.maxBatteryTemperature;
    }

    @Override
    public Optional<Integer> minSdkLevel() {
        return this.minSdkLevel;
    }

    @Override
    public Optional<Integer> maxSdkLevel() {
        return this.maxSdkLevel;
    }

    @Override
    public boolean isAtsServerRequest() {
        return this.isAtsServerRequest;
    }

    @Override
    public Optional<String> remoteRunnerFilePathPrefix() {
        return this.remoteRunnerFilePathPrefix;
    }

    @Override
    public boolean reportSystemCheckers() {
        return this.reportSystemCheckers;
    }

    @Override
    public XtsCommonProto.ShardingMode shardingMode() {
        return this.shardingMode;
    }

    @Override
    public Optional<Boolean> skipDeviceInfo() {
        return this.skipDeviceInfo;
    }

    @Override
    public Optional<Boolean> isXtsDynamicDownloadEnabled() {
        return this.isXtsDynamicDownloadEnabled;
    }

    @Override
    public ImmutableMap<String, String> xtsSuiteInfo() {
        return this.xtsSuiteInfo;
    }

    @Override
    public Optional<TestSuiteInfo> testSuiteInfo() {
        return this.testSuiteInfo;
    }

    @Override
    public ImmutableSet<String> excludeRunners() {
        return this.excludeRunners;
    }

    @Override
    public ImmutableList<ServiceProto.TestResource> atsServerTestResources() {
        return this.atsServerTestResources;
    }

    @Override
    public Optional<ServiceProto.TestEnvironment> atsServerTestEnvironment() {
        return this.atsServerTestEnvironment;
    }

    @Override
    public boolean allowPartialDeviceMatch() {
        return this.allowPartialDeviceMatch;
    }

    @Override
    public Optional<Boolean> enableDefaultLogs() {
        return this.enableDefaultLogs;
    }

    public String toString() {
        return "SessionRequestInfo{testPlan=" + this.testPlan + ", commandLineArgs=" + this.commandLineArgs + ", xtsRootDir=" + this.xtsRootDir + ", androidXtsZip=" + String.valueOf(this.androidXtsZip) + ", androidXtsZipDownloadUrl=" + String.valueOf(this.androidXtsZipDownloadUrl) + ", deviceSerials=" + String.valueOf(this.deviceSerials) + ", deviceInfo=" + String.valueOf(this.deviceInfo) + ", excludeDeviceSerials=" + String.valueOf(this.excludeDeviceSerials) + ", productTypes=" + String.valueOf(this.productTypes) + ", deviceProperties=" + String.valueOf(this.deviceProperties) + ", moduleNames=" + String.valueOf(this.moduleNames) + ", testName=" + String.valueOf(this.testName) + ", shardCount=" + String.valueOf(this.shardCount) + ", includeFilters=" + String.valueOf(this.includeFilters) + ", excludeFilters=" + String.valueOf(this.excludeFilters) + ", moduleMetadataIncludeFilters=" + String.valueOf(this.moduleMetadataIncludeFilters) + ", moduleMetadataExcludeFilters=" + String.valueOf(this.moduleMetadataExcludeFilters) + ", retrySessionIndex=" + String.valueOf(this.retrySessionIndex) + ", retrySessionResultDirName=" + String.valueOf(this.retrySessionResultDirName) + ", retrySessionId=" + String.valueOf(this.retrySessionId) + ", retryType=" + String.valueOf(this.retryType) + ", retryResultDir=" + String.valueOf(this.retryResultDir) + ", moduleArgs=" + String.valueOf(this.moduleArgs) + ", extraArgs=" + String.valueOf(this.extraArgs) + ", xtsType=" + this.xtsType + ", pythonPkgIndexUrl=" + String.valueOf(this.pythonPkgIndexUrl) + ", givenMatchedNonTfModules=" + String.valueOf(this.givenMatchedNonTfModules) + ", v2ConfigsMap=" + String.valueOf(this.v2ConfigsMap) + ", expandedModules=" + String.valueOf(this.expandedModules) + ", enableModuleParameter=" + this.enableModuleParameter + ", enableModuleOptionalParameter=" + this.enableModuleOptionalParameter + ", jobTimeout=" + String.valueOf(this.jobTimeout) + ", startTimeout=" + String.valueOf(this.startTimeout) + ", envVars=" + String.valueOf(this.envVars) + ", subPlanName=" + String.valueOf(this.subPlanName) + ", subPlanNameBackup=" + String.valueOf(this.subPlanNameBackup) + ", htmlInZip=" + this.htmlInZip + ", sessionClientId=" + String.valueOf(this.sessionClientId) + ", deviceType=" + String.valueOf(this.deviceType) + ", maxBatteryLevel=" + String.valueOf(this.maxBatteryLevel) + ", minBatteryLevel=" + String.valueOf(this.minBatteryLevel) + ", maxBatteryTemperature=" + String.valueOf(this.maxBatteryTemperature) + ", minSdkLevel=" + String.valueOf(this.minSdkLevel) + ", maxSdkLevel=" + String.valueOf(this.maxSdkLevel) + ", isAtsServerRequest=" + this.isAtsServerRequest + ", remoteRunnerFilePathPrefix=" + String.valueOf(this.remoteRunnerFilePathPrefix) + ", reportSystemCheckers=" + this.reportSystemCheckers + ", shardingMode=" + String.valueOf(this.shardingMode) + ", skipDeviceInfo=" + String.valueOf(this.skipDeviceInfo) + ", isXtsDynamicDownloadEnabled=" + String.valueOf(this.isXtsDynamicDownloadEnabled) + ", xtsSuiteInfo=" + String.valueOf(this.xtsSuiteInfo) + ", testSuiteInfo=" + String.valueOf(this.testSuiteInfo) + ", excludeRunners=" + String.valueOf(this.excludeRunners) + ", atsServerTestResources=" + String.valueOf(this.atsServerTestResources) + ", atsServerTestEnvironment=" + String.valueOf(this.atsServerTestEnvironment) + ", allowPartialDeviceMatch=" + this.allowPartialDeviceMatch + ", enableDefaultLogs=" + String.valueOf(this.enableDefaultLogs) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SessionRequestInfo) {
            SessionRequestInfo that = (SessionRequestInfo)o;
            return this.testPlan.equals(that.testPlan()) && this.commandLineArgs.equals(that.commandLineArgs()) && this.xtsRootDir.equals(that.xtsRootDir()) && this.androidXtsZip.equals(that.androidXtsZip()) && this.androidXtsZipDownloadUrl.equals(that.androidXtsZipDownloadUrl()) && this.deviceSerials.equals(that.deviceSerials()) && this.deviceInfo.equals(that.deviceInfo()) && this.excludeDeviceSerials.equals(that.excludeDeviceSerials()) && this.productTypes.equals(that.productTypes()) && this.deviceProperties.equals(that.deviceProperties()) && this.moduleNames.equals(that.moduleNames()) && this.testName.equals(that.testName()) && this.shardCount.equals(that.shardCount()) && this.includeFilters.equals(that.includeFilters()) && this.excludeFilters.equals(that.excludeFilters()) && this.moduleMetadataIncludeFilters.equals(that.moduleMetadataIncludeFilters()) && this.moduleMetadataExcludeFilters.equals(that.moduleMetadataExcludeFilters()) && this.retrySessionIndex.equals(that.retrySessionIndex()) && this.retrySessionResultDirName.equals(that.retrySessionResultDirName()) && this.retrySessionId.equals(that.retrySessionId()) && this.retryType.equals(that.retryType()) && this.retryResultDir.equals(that.retryResultDir()) && this.moduleArgs.equals(that.moduleArgs()) && this.extraArgs.equals(that.extraArgs()) && this.xtsType.equals(that.xtsType()) && this.pythonPkgIndexUrl.equals(that.pythonPkgIndexUrl()) && this.givenMatchedNonTfModules.equals(that.givenMatchedNonTfModules()) && this.v2ConfigsMap.equals(that.v2ConfigsMap()) && this.expandedModules.equals(that.expandedModules()) && this.enableModuleParameter == that.enableModuleParameter() && this.enableModuleOptionalParameter == that.enableModuleOptionalParameter() && this.jobTimeout.equals(that.jobTimeout()) && this.startTimeout.equals(that.startTimeout()) && this.envVars.equals(that.envVars()) && this.subPlanName.equals(that.subPlanName()) && this.subPlanNameBackup.equals(that.subPlanNameBackup()) && this.htmlInZip == that.htmlInZip() && this.sessionClientId.equals(that.sessionClientId()) && this.deviceType.equals(that.deviceType()) && this.maxBatteryLevel.equals(that.maxBatteryLevel()) && this.minBatteryLevel.equals(that.minBatteryLevel()) && this.maxBatteryTemperature.equals(that.maxBatteryTemperature()) && this.minSdkLevel.equals(that.minSdkLevel()) && this.maxSdkLevel.equals(that.maxSdkLevel()) && this.isAtsServerRequest == that.isAtsServerRequest() && this.remoteRunnerFilePathPrefix.equals(that.remoteRunnerFilePathPrefix()) && this.reportSystemCheckers == that.reportSystemCheckers() && this.shardingMode.equals(that.shardingMode()) && this.skipDeviceInfo.equals(that.skipDeviceInfo()) && this.isXtsDynamicDownloadEnabled.equals(that.isXtsDynamicDownloadEnabled()) && this.xtsSuiteInfo.equals(that.xtsSuiteInfo()) && this.testSuiteInfo.equals(that.testSuiteInfo()) && this.excludeRunners.equals(that.excludeRunners()) && this.atsServerTestResources.equals(that.atsServerTestResources()) && this.atsServerTestEnvironment.equals(that.atsServerTestEnvironment()) && this.allowPartialDeviceMatch == that.allowPartialDeviceMatch() && this.enableDefaultLogs.equals(that.enableDefaultLogs());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.testPlan.hashCode();
        h$ *= 1000003;
        h$ ^= this.commandLineArgs.hashCode();
        h$ *= 1000003;
        h$ ^= this.xtsRootDir.hashCode();
        h$ *= 1000003;
        h$ ^= this.androidXtsZip.hashCode();
        h$ *= 1000003;
        h$ ^= this.androidXtsZipDownloadUrl.hashCode();
        h$ *= 1000003;
        h$ ^= this.deviceSerials.hashCode();
        h$ *= 1000003;
        h$ ^= this.deviceInfo.hashCode();
        h$ *= 1000003;
        h$ ^= this.excludeDeviceSerials.hashCode();
        h$ *= 1000003;
        h$ ^= this.productTypes.hashCode();
        h$ *= 1000003;
        h$ ^= this.deviceProperties.hashCode();
        h$ *= 1000003;
        h$ ^= this.moduleNames.hashCode();
        h$ *= 1000003;
        h$ ^= this.testName.hashCode();
        h$ *= 1000003;
        h$ ^= this.shardCount.hashCode();
        h$ *= 1000003;
        h$ ^= this.includeFilters.hashCode();
        h$ *= 1000003;
        h$ ^= this.excludeFilters.hashCode();
        h$ *= 1000003;
        h$ ^= this.moduleMetadataIncludeFilters.hashCode();
        h$ *= 1000003;
        h$ ^= this.moduleMetadataExcludeFilters.hashCode();
        h$ *= 1000003;
        h$ ^= this.retrySessionIndex.hashCode();
        h$ *= 1000003;
        h$ ^= this.retrySessionResultDirName.hashCode();
        h$ *= 1000003;
        h$ ^= this.retrySessionId.hashCode();
        h$ *= 1000003;
        h$ ^= this.retryType.hashCode();
        h$ *= 1000003;
        h$ ^= this.retryResultDir.hashCode();
        h$ *= 1000003;
        h$ ^= this.moduleArgs.hashCode();
        h$ *= 1000003;
        h$ ^= this.extraArgs.hashCode();
        h$ *= 1000003;
        h$ ^= this.xtsType.hashCode();
        h$ *= 1000003;
        h$ ^= this.pythonPkgIndexUrl.hashCode();
        h$ *= 1000003;
        h$ ^= this.givenMatchedNonTfModules.hashCode();
        h$ *= 1000003;
        h$ ^= this.v2ConfigsMap.hashCode();
        h$ *= 1000003;
        h$ ^= this.expandedModules.hashCode();
        h$ *= 1000003;
        h$ ^= this.enableModuleParameter ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.enableModuleOptionalParameter ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.jobTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.startTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.envVars.hashCode();
        h$ *= 1000003;
        h$ ^= this.subPlanName.hashCode();
        h$ *= 1000003;
        h$ ^= this.subPlanNameBackup.hashCode();
        h$ *= 1000003;
        h$ ^= this.htmlInZip ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.sessionClientId.hashCode();
        h$ *= 1000003;
        h$ ^= this.deviceType.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxBatteryLevel.hashCode();
        h$ *= 1000003;
        h$ ^= this.minBatteryLevel.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxBatteryTemperature.hashCode();
        h$ *= 1000003;
        h$ ^= this.minSdkLevel.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxSdkLevel.hashCode();
        h$ *= 1000003;
        h$ ^= this.isAtsServerRequest ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.remoteRunnerFilePathPrefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.reportSystemCheckers ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.shardingMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.skipDeviceInfo.hashCode();
        h$ *= 1000003;
        h$ ^= this.isXtsDynamicDownloadEnabled.hashCode();
        h$ *= 1000003;
        h$ ^= this.xtsSuiteInfo.hashCode();
        h$ *= 1000003;
        h$ ^= this.testSuiteInfo.hashCode();
        h$ *= 1000003;
        h$ ^= this.excludeRunners.hashCode();
        h$ *= 1000003;
        h$ ^= this.atsServerTestResources.hashCode();
        h$ *= 1000003;
        h$ ^= this.atsServerTestEnvironment.hashCode();
        h$ *= 1000003;
        h$ ^= this.allowPartialDeviceMatch ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.enableDefaultLogs.hashCode();
    }

    @Override
    public SessionRequestInfo.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SessionRequestInfo.Builder {
        private String testPlan;
        private String commandLineArgs;
        private String xtsRootDir;
        private Optional<String> androidXtsZip = Optional.empty();
        private Optional<String> androidXtsZipDownloadUrl = Optional.empty();
        private ImmutableList<String> deviceSerials;
        private Optional<TestSuiteHelper.DeviceInfo> deviceInfo = Optional.empty();
        private ImmutableList<String> excludeDeviceSerials;
        private ImmutableList<String> productTypes;
        private ImmutableMap<String, String> deviceProperties;
        private ImmutableList<String> moduleNames;
        private Optional<String> testName = Optional.empty();
        private Optional<Integer> shardCount = Optional.empty();
        private ImmutableList<String> includeFilters;
        private ImmutableList<String> excludeFilters;
        private ImmutableMultimap<String, String> moduleMetadataIncludeFilters;
        private ImmutableMultimap<String, String> moduleMetadataExcludeFilters;
        private Optional<Integer> retrySessionIndex = Optional.empty();
        private Optional<String> retrySessionResultDirName = Optional.empty();
        private Optional<String> retrySessionId = Optional.empty();
        private Optional<RetryType> retryType = Optional.empty();
        private Optional<String> retryResultDir = Optional.empty();
        private ImmutableList<String> moduleArgs;
        private ImmutableList<String> extraArgs;
        private String xtsType;
        private Optional<String> pythonPkgIndexUrl = Optional.empty();
        private ImmutableSet<String> givenMatchedNonTfModules;
        private ImmutableMap<String, ConfigurationProto.Configuration> v2ConfigsMap;
        private ImmutableMap<String, ConfigurationProto.Configuration> expandedModules;
        private boolean enableModuleParameter;
        private boolean enableModuleOptionalParameter;
        private Duration jobTimeout;
        private Duration startTimeout;
        private ImmutableMap<String, String> envVars;
        private Optional<String> subPlanName = Optional.empty();
        private Optional<String> subPlanNameBackup = Optional.empty();
        private boolean htmlInZip;
        private Optional<String> sessionClientId = Optional.empty();
        private Optional<String> deviceType = Optional.empty();
        private Optional<Integer> maxBatteryLevel = Optional.empty();
        private Optional<Integer> minBatteryLevel = Optional.empty();
        private Optional<Integer> maxBatteryTemperature = Optional.empty();
        private Optional<Integer> minSdkLevel = Optional.empty();
        private Optional<Integer> maxSdkLevel = Optional.empty();
        private boolean isAtsServerRequest;
        private Optional<String> remoteRunnerFilePathPrefix = Optional.empty();
        private boolean reportSystemCheckers;
        private XtsCommonProto.ShardingMode shardingMode;
        private Optional<Boolean> skipDeviceInfo = Optional.empty();
        private Optional<Boolean> isXtsDynamicDownloadEnabled = Optional.empty();
        private ImmutableMap<String, String> xtsSuiteInfo;
        private Optional<TestSuiteInfo> testSuiteInfo = Optional.empty();
        private ImmutableSet<String> excludeRunners;
        private ImmutableList<ServiceProto.TestResource> atsServerTestResources;
        private Optional<ServiceProto.TestEnvironment> atsServerTestEnvironment = Optional.empty();
        private boolean allowPartialDeviceMatch;
        private Optional<Boolean> enableDefaultLogs = Optional.empty();
        private byte set$0;

        Builder() {
        }

        Builder(SessionRequestInfo source) {
            this.testPlan = source.testPlan();
            this.commandLineArgs = source.commandLineArgs();
            this.xtsRootDir = source.xtsRootDir();
            this.androidXtsZip = source.androidXtsZip();
            this.androidXtsZipDownloadUrl = source.androidXtsZipDownloadUrl();
            this.deviceSerials = source.deviceSerials();
            this.deviceInfo = source.deviceInfo();
            this.excludeDeviceSerials = source.excludeDeviceSerials();
            this.productTypes = source.productTypes();
            this.deviceProperties = source.deviceProperties();
            this.moduleNames = source.moduleNames();
            this.testName = source.testName();
            this.shardCount = source.shardCount();
            this.includeFilters = source.includeFilters();
            this.excludeFilters = source.excludeFilters();
            this.moduleMetadataIncludeFilters = source.moduleMetadataIncludeFilters();
            this.moduleMetadataExcludeFilters = source.moduleMetadataExcludeFilters();
            this.retrySessionIndex = source.retrySessionIndex();
            this.retrySessionResultDirName = source.retrySessionResultDirName();
            this.retrySessionId = source.retrySessionId();
            this.retryType = source.retryType();
            this.retryResultDir = source.retryResultDir();
            this.moduleArgs = source.moduleArgs();
            this.extraArgs = source.extraArgs();
            this.xtsType = source.xtsType();
            this.pythonPkgIndexUrl = source.pythonPkgIndexUrl();
            this.givenMatchedNonTfModules = source.givenMatchedNonTfModules();
            this.v2ConfigsMap = source.v2ConfigsMap();
            this.expandedModules = source.expandedModules();
            this.enableModuleParameter = source.enableModuleParameter();
            this.enableModuleOptionalParameter = source.enableModuleOptionalParameter();
            this.jobTimeout = source.jobTimeout();
            this.startTimeout = source.startTimeout();
            this.envVars = source.envVars();
            this.subPlanName = source.subPlanName();
            this.subPlanNameBackup = source.subPlanNameBackup();
            this.htmlInZip = source.htmlInZip();
            this.sessionClientId = source.sessionClientId();
            this.deviceType = source.deviceType();
            this.maxBatteryLevel = source.maxBatteryLevel();
            this.minBatteryLevel = source.minBatteryLevel();
            this.maxBatteryTemperature = source.maxBatteryTemperature();
            this.minSdkLevel = source.minSdkLevel();
            this.maxSdkLevel = source.maxSdkLevel();
            this.isAtsServerRequest = source.isAtsServerRequest();
            this.remoteRunnerFilePathPrefix = source.remoteRunnerFilePathPrefix();
            this.reportSystemCheckers = source.reportSystemCheckers();
            this.shardingMode = source.shardingMode();
            this.skipDeviceInfo = source.skipDeviceInfo();
            this.isXtsDynamicDownloadEnabled = source.isXtsDynamicDownloadEnabled();
            this.xtsSuiteInfo = source.xtsSuiteInfo();
            this.testSuiteInfo = source.testSuiteInfo();
            this.excludeRunners = source.excludeRunners();
            this.atsServerTestResources = source.atsServerTestResources();
            this.atsServerTestEnvironment = source.atsServerTestEnvironment();
            this.allowPartialDeviceMatch = source.allowPartialDeviceMatch();
            this.enableDefaultLogs = source.enableDefaultLogs();
            this.set$0 = (byte)63;
        }

        @Override
        public SessionRequestInfo.Builder setTestPlan(String testPlan) {
            if (testPlan == null) {
                throw new NullPointerException("Null testPlan");
            }
            this.testPlan = testPlan;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setCommandLineArgs(String commandLineArgs) {
            if (commandLineArgs == null) {
                throw new NullPointerException("Null commandLineArgs");
            }
            this.commandLineArgs = commandLineArgs;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setXtsRootDir(String xtsRootDir) {
            if (xtsRootDir == null) {
                throw new NullPointerException("Null xtsRootDir");
            }
            this.xtsRootDir = xtsRootDir;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setAndroidXtsZip(String androidXtsZip) {
            this.androidXtsZip = Optional.of(androidXtsZip);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setAndroidXtsZipDownloadUrl(String androidXtsZipDownloadUrl) {
            this.androidXtsZipDownloadUrl = Optional.of(androidXtsZipDownloadUrl);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setDeviceSerials(List<String> deviceSerials) {
            this.deviceSerials = ImmutableList.copyOf(deviceSerials);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setDeviceInfo(Optional<TestSuiteHelper.DeviceInfo> deviceInfo) {
            if (deviceInfo == null) {
                throw new NullPointerException("Null deviceInfo");
            }
            this.deviceInfo = deviceInfo;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setExcludeDeviceSerials(List<String> excludeDeviceSerials) {
            this.excludeDeviceSerials = ImmutableList.copyOf(excludeDeviceSerials);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setProductTypes(List<String> productTypes) {
            this.productTypes = ImmutableList.copyOf(productTypes);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setDeviceProperties(ImmutableMap<String, String> deviceProperties) {
            if (deviceProperties == null) {
                throw new NullPointerException("Null deviceProperties");
            }
            this.deviceProperties = deviceProperties;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setModuleNames(List<String> moduleNames) {
            this.moduleNames = ImmutableList.copyOf(moduleNames);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setTestName(String testName) {
            this.testName = Optional.of(testName);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setShardCount(int shardCount) {
            this.shardCount = Optional.of(shardCount);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setIncludeFilters(List<String> includeFilters) {
            this.includeFilters = ImmutableList.copyOf(includeFilters);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setExcludeFilters(List<String> excludeFilters) {
            this.excludeFilters = ImmutableList.copyOf(excludeFilters);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setModuleMetadataIncludeFilters(ImmutableMultimap<String, String> moduleMetadataIncludeFilters) {
            if (moduleMetadataIncludeFilters == null) {
                throw new NullPointerException("Null moduleMetadataIncludeFilters");
            }
            this.moduleMetadataIncludeFilters = moduleMetadataIncludeFilters;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setModuleMetadataExcludeFilters(ImmutableMultimap<String, String> moduleMetadataExcludeFilters) {
            if (moduleMetadataExcludeFilters == null) {
                throw new NullPointerException("Null moduleMetadataExcludeFilters");
            }
            this.moduleMetadataExcludeFilters = moduleMetadataExcludeFilters;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setRetrySessionIndex(Integer retrySessionIndex) {
            this.retrySessionIndex = Optional.of(retrySessionIndex);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setRetrySessionResultDirName(String retrySessionResultDirName) {
            this.retrySessionResultDirName = Optional.of(retrySessionResultDirName);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setRetrySessionId(String retrySessionId) {
            this.retrySessionId = Optional.of(retrySessionId);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setRetryType(RetryType retryType) {
            this.retryType = Optional.of(retryType);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setRetryResultDir(String retryResultDir) {
            this.retryResultDir = Optional.of(retryResultDir);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setModuleArgs(List<String> moduleArgs) {
            this.moduleArgs = ImmutableList.copyOf(moduleArgs);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setExtraArgs(List<String> extraArgs) {
            this.extraArgs = ImmutableList.copyOf(extraArgs);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setXtsType(String xtsType) {
            if (xtsType == null) {
                throw new NullPointerException("Null xtsType");
            }
            this.xtsType = xtsType;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setPythonPkgIndexUrl(String pythonPkgIndexUrl) {
            this.pythonPkgIndexUrl = Optional.of(pythonPkgIndexUrl);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setGivenMatchedNonTfModules(ImmutableSet<String> givenMatchedNonTfModules) {
            if (givenMatchedNonTfModules == null) {
                throw new NullPointerException("Null givenMatchedNonTfModules");
            }
            this.givenMatchedNonTfModules = givenMatchedNonTfModules;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setV2ConfigsMap(ImmutableMap<String, ConfigurationProto.Configuration> v2ConfigsMap) {
            if (v2ConfigsMap == null) {
                throw new NullPointerException("Null v2ConfigsMap");
            }
            this.v2ConfigsMap = v2ConfigsMap;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setExpandedModules(ImmutableMap<String, ConfigurationProto.Configuration> expandedModules) {
            if (expandedModules == null) {
                throw new NullPointerException("Null expandedModules");
            }
            this.expandedModules = expandedModules;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setEnableModuleParameter(boolean enableModuleParameter) {
            this.enableModuleParameter = enableModuleParameter;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setEnableModuleOptionalParameter(boolean enableModuleOptionalParameter) {
            this.enableModuleOptionalParameter = enableModuleOptionalParameter;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setJobTimeout(Duration jobTimeout) {
            if (jobTimeout == null) {
                throw new NullPointerException("Null jobTimeout");
            }
            this.jobTimeout = jobTimeout;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setStartTimeout(Duration startTimeout) {
            if (startTimeout == null) {
                throw new NullPointerException("Null startTimeout");
            }
            this.startTimeout = startTimeout;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setEnvVars(ImmutableMap<String, String> envVars) {
            if (envVars == null) {
                throw new NullPointerException("Null envVars");
            }
            this.envVars = envVars;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setSubPlanName(String subPlanName) {
            this.subPlanName = Optional.of(subPlanName);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setSubPlanNameBackup(String subPlanNameBackup) {
            this.subPlanNameBackup = Optional.of(subPlanNameBackup);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setHtmlInZip(boolean htmlInZip) {
            this.htmlInZip = htmlInZip;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setSessionClientId(String sessionClientId) {
            this.sessionClientId = Optional.of(sessionClientId);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setDeviceType(String deviceType) {
            this.deviceType = Optional.of(deviceType);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setMaxBatteryLevel(int maxBatteryLevel) {
            this.maxBatteryLevel = Optional.of(maxBatteryLevel);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setMinBatteryLevel(int minBatteryLevel) {
            this.minBatteryLevel = Optional.of(minBatteryLevel);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setMaxBatteryTemperature(int maxBatteryTemperature) {
            this.maxBatteryTemperature = Optional.of(maxBatteryTemperature);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setMinSdkLevel(int minSdkLevel) {
            this.minSdkLevel = Optional.of(minSdkLevel);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setMaxSdkLevel(int maxSdkLevel) {
            this.maxSdkLevel = Optional.of(maxSdkLevel);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setIsAtsServerRequest(boolean isAtsServerRequest) {
            this.isAtsServerRequest = isAtsServerRequest;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setRemoteRunnerFilePathPrefix(String remoteRunnerFilePathPrefix) {
            this.remoteRunnerFilePathPrefix = Optional.of(remoteRunnerFilePathPrefix);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setReportSystemCheckers(boolean reportSystemCheckers) {
            this.reportSystemCheckers = reportSystemCheckers;
            this.set$0 = (byte)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setShardingMode(XtsCommonProto.ShardingMode shardingMode) {
            if (shardingMode == null) {
                throw new NullPointerException("Null shardingMode");
            }
            this.shardingMode = shardingMode;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setSkipDeviceInfo(boolean skipDeviceInfo) {
            this.skipDeviceInfo = Optional.of(skipDeviceInfo);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setIsXtsDynamicDownloadEnabled(boolean isXtsDynamicDownloadEnabled) {
            this.isXtsDynamicDownloadEnabled = Optional.of(isXtsDynamicDownloadEnabled);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setXtsSuiteInfo(ImmutableMap<String, String> xtsSuiteInfo) {
            if (xtsSuiteInfo == null) {
                throw new NullPointerException("Null xtsSuiteInfo");
            }
            this.xtsSuiteInfo = xtsSuiteInfo;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setTestSuiteInfo(TestSuiteInfo testSuiteInfo) {
            this.testSuiteInfo = Optional.of(testSuiteInfo);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setExcludeRunners(ImmutableSet<String> excludeRunners) {
            if (excludeRunners == null) {
                throw new NullPointerException("Null excludeRunners");
            }
            this.excludeRunners = excludeRunners;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setAtsServerTestResources(ImmutableList<ServiceProto.TestResource> atsServerTestResources) {
            if (atsServerTestResources == null) {
                throw new NullPointerException("Null atsServerTestResources");
            }
            this.atsServerTestResources = atsServerTestResources;
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setAtsServerTestEnvironment(ServiceProto.TestEnvironment atsServerTestEnvironment) {
            this.atsServerTestEnvironment = Optional.of(atsServerTestEnvironment);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setAllowPartialDeviceMatch(boolean allowPartialDeviceMatch) {
            this.allowPartialDeviceMatch = allowPartialDeviceMatch;
            this.set$0 = (byte)(this.set$0 | 0x20);
            return this;
        }

        @Override
        public SessionRequestInfo.Builder setEnableDefaultLogs(boolean enableDefaultLogs) {
            this.enableDefaultLogs = Optional.of(enableDefaultLogs);
            return this;
        }

        @Override
        protected SessionRequestInfo autoBuild() {
            if (this.set$0 != 63 || this.testPlan == null || this.commandLineArgs == null || this.xtsRootDir == null || this.deviceSerials == null || this.excludeDeviceSerials == null || this.productTypes == null || this.deviceProperties == null || this.moduleNames == null || this.includeFilters == null || this.excludeFilters == null || this.moduleMetadataIncludeFilters == null || this.moduleMetadataExcludeFilters == null || this.moduleArgs == null || this.extraArgs == null || this.xtsType == null || this.givenMatchedNonTfModules == null || this.v2ConfigsMap == null || this.expandedModules == null || this.jobTimeout == null || this.startTimeout == null || this.envVars == null || this.shardingMode == null || this.xtsSuiteInfo == null || this.excludeRunners == null || this.atsServerTestResources == null) {
                StringBuilder missing = new StringBuilder();
                if (this.testPlan == null) {
                    missing.append(" testPlan");
                }
                if (this.commandLineArgs == null) {
                    missing.append(" commandLineArgs");
                }
                if (this.xtsRootDir == null) {
                    missing.append(" xtsRootDir");
                }
                if (this.deviceSerials == null) {
                    missing.append(" deviceSerials");
                }
                if (this.excludeDeviceSerials == null) {
                    missing.append(" excludeDeviceSerials");
                }
                if (this.productTypes == null) {
                    missing.append(" productTypes");
                }
                if (this.deviceProperties == null) {
                    missing.append(" deviceProperties");
                }
                if (this.moduleNames == null) {
                    missing.append(" moduleNames");
                }
                if (this.includeFilters == null) {
                    missing.append(" includeFilters");
                }
                if (this.excludeFilters == null) {
                    missing.append(" excludeFilters");
                }
                if (this.moduleMetadataIncludeFilters == null) {
                    missing.append(" moduleMetadataIncludeFilters");
                }
                if (this.moduleMetadataExcludeFilters == null) {
                    missing.append(" moduleMetadataExcludeFilters");
                }
                if (this.moduleArgs == null) {
                    missing.append(" moduleArgs");
                }
                if (this.extraArgs == null) {
                    missing.append(" extraArgs");
                }
                if (this.xtsType == null) {
                    missing.append(" xtsType");
                }
                if (this.givenMatchedNonTfModules == null) {
                    missing.append(" givenMatchedNonTfModules");
                }
                if (this.v2ConfigsMap == null) {
                    missing.append(" v2ConfigsMap");
                }
                if (this.expandedModules == null) {
                    missing.append(" expandedModules");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" enableModuleParameter");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" enableModuleOptionalParameter");
                }
                if (this.jobTimeout == null) {
                    missing.append(" jobTimeout");
                }
                if (this.startTimeout == null) {
                    missing.append(" startTimeout");
                }
                if (this.envVars == null) {
                    missing.append(" envVars");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" htmlInZip");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" isAtsServerRequest");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" reportSystemCheckers");
                }
                if (this.shardingMode == null) {
                    missing.append(" shardingMode");
                }
                if (this.xtsSuiteInfo == null) {
                    missing.append(" xtsSuiteInfo");
                }
                if (this.excludeRunners == null) {
                    missing.append(" excludeRunners");
                }
                if (this.atsServerTestResources == null) {
                    missing.append(" atsServerTestResources");
                }
                if ((this.set$0 & 0x20) == 0) {
                    missing.append(" allowPartialDeviceMatch");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_SessionRequestInfo(this.testPlan, this.commandLineArgs, this.xtsRootDir, this.androidXtsZip, this.androidXtsZipDownloadUrl, this.deviceSerials, this.deviceInfo, this.excludeDeviceSerials, this.productTypes, this.deviceProperties, this.moduleNames, this.testName, this.shardCount, this.includeFilters, this.excludeFilters, this.moduleMetadataIncludeFilters, this.moduleMetadataExcludeFilters, this.retrySessionIndex, this.retrySessionResultDirName, this.retrySessionId, this.retryType, this.retryResultDir, this.moduleArgs, this.extraArgs, this.xtsType, this.pythonPkgIndexUrl, this.givenMatchedNonTfModules, this.v2ConfigsMap, this.expandedModules, this.enableModuleParameter, this.enableModuleOptionalParameter, this.jobTimeout, this.startTimeout, this.envVars, this.subPlanName, this.subPlanNameBackup, this.htmlInZip, this.sessionClientId, this.deviceType, this.maxBatteryLevel, this.minBatteryLevel, this.maxBatteryTemperature, this.minSdkLevel, this.maxSdkLevel, this.isAtsServerRequest, this.remoteRunnerFilePathPrefix, this.reportSystemCheckers, this.shardingMode, this.skipDeviceInfo, this.isXtsDynamicDownloadEnabled, this.xtsSuiteInfo, this.testSuiteInfo, this.excludeRunners, this.atsServerTestResources, this.atsServerTestEnvironment, this.allowPartialDeviceMatch, this.enableDefaultLogs);
        }
    }
}

