/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.metrics.stability.rpc.grpc;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.devtools.common.metrics.stability.model.ErrorId;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionUtil;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.StatusRuntimeException;

public final class GrpcStubUtil {
    private GrpcStubUtil() {
    }

    @CanIgnoreReturnValue
    public static <ReqT, RespT> RespT invoke(GrpcMethod<ReqT, RespT> grpcMethod, ReqT request, ErrorId errorId, String errorMessage) throws GrpcExceptionWithErrorId {
        try {
            return grpcMethod.execute(request);
        }
        catch (StatusRuntimeException e) {
            throw GrpcExceptionUtil.toGrpcExceptionWithErrorId(errorId, errorMessage, e);
        }
    }

    public static <ReqT, RespT> ListenableFuture<RespT> invokeAsync(AsyncGrpcMethod<ReqT, RespT> grpcMethod, ReqT request, ErrorId errorId, String errorMessage) {
        return Futures.catchingAsync(grpcMethod.execute(request), StatusRuntimeException.class, e -> Futures.immediateFailedFuture(GrpcExceptionUtil.toGrpcExceptionWithErrorId(errorId, errorMessage, e)), MoreExecutors.directExecutor());
    }

    @FunctionalInterface
    public static interface GrpcMethod<ReqT, RespT> {
        public RespT execute(ReqT var1);
    }

    @FunctionalInterface
    public static interface AsyncGrpcMethod<ReqT, RespT> {
        public ListenableFuture<RespT> execute(ReqT var1);
    }
}

