/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.metrics.stability.rpc;

import com.google.common.base.Preconditions;
import com.google.devtools.common.metrics.stability.converter.DeserializedException;
import com.google.devtools.common.metrics.stability.model.ErrorId;
import com.google.devtools.common.metrics.stability.model.ErrorIdProvider;
import java.util.Optional;
import javax.annotation.Nullable;

public class RpcExceptionWithErrorId
extends Exception
implements ErrorIdProvider<ErrorId> {
    private final ErrorId errorId;
    private final int rpcCanonicalCode;

    protected RpcExceptionWithErrorId(ErrorId errorId, String message, int rpcCanonicalCode, @Nullable DeserializedException applicationError, Throwable underlyingRpcException) {
        super(RpcExceptionWithErrorId.formatMessage(message, rpcCanonicalCode), applicationError);
        this.errorId = Preconditions.checkNotNull(errorId);
        this.rpcCanonicalCode = rpcCanonicalCode;
        this.addSuppressed(Preconditions.checkNotNull(underlyingRpcException));
    }

    public int getRpcCanonicalCode() {
        return this.rpcCanonicalCode;
    }

    public Throwable getUnderlyingRpcException() {
        return this.getSuppressed()[0];
    }

    public Optional<DeserializedException> getApplicationError() {
        return Optional.ofNullable(this.getCause());
    }

    @Override
    @Nullable
    public DeserializedException getCause() {
        return (DeserializedException)super.getCause();
    }

    @Override
    public ErrorId getErrorId() {
        return this.errorId;
    }

    private static String formatMessage(String message, int rpcCanonicalCode) {
        return String.format("%s [rpc_code=%s]", message, rpcCanonicalCode);
    }
}

