/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.metrics.stability.rpc;

import com.google.common.flogger.FluentLogger;
import com.google.devtools.common.metrics.stability.model.proto.ExceptionProto;
import com.google.devtools.common.metrics.stability.rpc.proto.RpcErrorProto;
import com.google.devtools.mobileharness.shared.util.base.ProtoExtensionRegistry;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;

public class RpcErrorUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final RpcErrorProto.CompressedExceptionDetail.CompressionFormat COMPRESSION_FORMAT = RpcErrorProto.CompressedExceptionDetail.CompressionFormat.DEFLATE;

    public static Optional<ExceptionProto.ExceptionDetail> toExceptionDetail(RpcErrorProto.RpcError rpcError) throws IOException {
        if (rpcError.hasCompressedExceptionDetail()) {
            RpcErrorProto.CompressedExceptionDetail compressedExceptionDetail = rpcError.getCompressedExceptionDetail();
            if (compressedExceptionDetail.getCompressionFormat() == COMPRESSION_FORMAT) {
                ByteString compressedData = compressedExceptionDetail.getCompressedData();
                try (InflaterInputStream inputStream = new InflaterInputStream(compressedData.newInput());){
                    Optional<ExceptionProto.ExceptionDetail> optional = Optional.of(ExceptionProto.ExceptionDetail.parseFrom(inputStream, (ExtensionRegistryLite)ProtoExtensionRegistry.getGeneratedRegistry()));
                    return optional;
                }
            }
            throw new IOException(String.format("Failed to uncompress CompressedExceptionDetail in RpcError: format [%s] is expected but format [%s] is found", COMPRESSION_FORMAT, compressedExceptionDetail.getCompressionFormat()));
        }
        return Optional.empty();
    }

    public static RpcErrorProto.RpcError toRpcError(ExceptionProto.ExceptionDetail exceptionDetail, @Nullable Integer compressSizeLimitBytes) {
        RpcErrorProto.RpcError.Builder result = RpcErrorProto.RpcError.newBuilder().setCompressedExceptionDetail(RpcErrorProto.CompressedExceptionDetail.newBuilder().setCompressionFormat(COMPRESSION_FORMAT));
        Optional<ByteString.Output> compressedExceptionDetail = RpcErrorUtil.compressExceptionDetail(exceptionDetail);
        if (compressedExceptionDetail.isPresent() && (compressSizeLimitBytes == null || compressedExceptionDetail.get().size() <= compressSizeLimitBytes)) {
            result.getCompressedExceptionDetailBuilder().setCompressedData(compressedExceptionDetail.get().toByteString());
            return result.build();
        }
        ExceptionProto.ExceptionDetail exceptionDetailWithoutStackTrace = RpcErrorUtil.clearStackTrace(exceptionDetail.toBuilder()).build();
        compressedExceptionDetail = RpcErrorUtil.compressExceptionDetail(exceptionDetailWithoutStackTrace);
        if (compressedExceptionDetail.isPresent() && (compressSizeLimitBytes == null || compressedExceptionDetail.get().size() <= compressSizeLimitBytes)) {
            ((FluentLogger.Api)logger.atInfo()).log("Stack trace of an ExceptionDetail is omitted because of RpcError size limit, exception_detail=[%s]", exceptionDetail);
            result.getCompressedExceptionDetailBuilder().setCompressedData(compressedExceptionDetail.get().toByteString());
            return result.build();
        }
        ((FluentLogger.Api)logger.atWarning()).log("An ExceptionDetail is omitted because of RpcError size limit, exception_detail=[%s]", exceptionDetail);
        return RpcErrorProto.RpcError.getDefaultInstance();
    }

    private static Optional<ByteString.Output> compressExceptionDetail(ExceptionProto.ExceptionDetail exceptionDetail) {
        ByteString.Output result = ByteString.newOutput();
        try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)result, new Deflater(9));){
            exceptionDetail.writeTo(deflaterOutputStream);
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Failed to compress ExceptionDetail: %s", exceptionDetail);
            return Optional.empty();
        }
        return Optional.of(result);
    }

    @CanIgnoreReturnValue
    private static ExceptionProto.ExceptionDetail.Builder clearStackTrace(ExceptionProto.ExceptionDetail.Builder exceptionDetail) {
        exceptionDetail.getSummaryBuilder().clearStackTrace();
        if (exceptionDetail.hasCause()) {
            RpcErrorUtil.clearStackTrace(exceptionDetail.getCauseBuilder());
        }
        for (ExceptionProto.ExceptionDetail.Builder suppressed : exceptionDetail.getSuppressedBuilderList()) {
            RpcErrorUtil.clearStackTrace(suppressed);
        }
        return exceptionDetail;
    }

    private RpcErrorUtil() {
    }
}

