/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.metrics.stability.converter;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.devtools.common.metrics.stability.converter.DeserializedErrorId;
import com.google.devtools.common.metrics.stability.converter.DeserializedException;
import com.google.devtools.common.metrics.stability.converter.UnknownErrorId;
import com.google.devtools.common.metrics.stability.model.ErrorId;
import com.google.devtools.common.metrics.stability.model.ErrorIdProvider;
import com.google.devtools.common.metrics.stability.model.proto.ErrorIdProto;
import com.google.devtools.common.metrics.stability.model.proto.ErrorTypeProto;
import com.google.devtools.common.metrics.stability.model.proto.ExceptionProto;
import com.google.devtools.common.metrics.stability.model.proto.NamespaceProto;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

public class ErrorModelConverter {
    public static ExceptionProto.ExceptionDetail toExceptionDetail(Throwable throwable) {
        return ErrorModelConverter.toExceptionDetail(throwable, true);
    }

    public static ExceptionProto.ExceptionDetail toExceptionDetail(Throwable throwable, boolean addStackTrace) {
        ExceptionProto.ExceptionDetail.Builder result = ExceptionProto.ExceptionDetail.newBuilder();
        result.setSummary(ErrorModelConverter.getExceptionSummary(throwable, addStackTrace));
        if (throwable.getCause() != null) {
            result.setCause(ErrorModelConverter.toExceptionDetail(throwable.getCause()));
        }
        for (Throwable suppressed : throwable.getSuppressed()) {
            result.addSuppressed(ErrorModelConverter.toExceptionDetail(suppressed));
        }
        return result.build();
    }

    public static DeserializedException toDeserializedException(ExceptionProto.ExceptionDetail exceptionDetail) {
        DeserializedException result = ErrorModelConverter.toSingleDeserializedException(exceptionDetail.getSummary());
        if (exceptionDetail.hasCause()) {
            result.initCause(ErrorModelConverter.toDeserializedException(exceptionDetail.getCause()));
        } else {
            result.initCause(null);
        }
        for (ExceptionProto.ExceptionDetail suppressed : exceptionDetail.getSuppressedList()) {
            result.addSuppressed(ErrorModelConverter.toDeserializedException(suppressed));
        }
        return result;
    }

    public static ErrorIdProto.ErrorId toErrorIdProto(ErrorId errorId) {
        return ErrorIdProto.ErrorId.newBuilder().setCode(errorId.code()).setName(errorId.name()).setType(errorId.type()).setNamespace(errorId.namespace()).build();
    }

    private static ExceptionProto.ExceptionSummary getExceptionSummary(Throwable throwable, boolean addStackTrace) {
        ExceptionProto.ExceptionSummary.Builder result = ExceptionProto.ExceptionSummary.newBuilder();
        result.setErrorId(ErrorModelConverter.toErrorIdProto(ErrorModelConverter.finalizeErrorId(throwable)));
        result.setMessage(Strings.nullToEmpty(throwable.getMessage()));
        result.setClassType(ErrorModelConverter.getExceptionClassType(throwable));
        if (addStackTrace) {
            result.setStackTrace(ErrorModelConverter.getStackTrace(throwable));
        }
        return result.build();
    }

    private static ErrorId finalizeErrorId(Throwable throwable) {
        if (throwable instanceof ErrorIdProvider) {
            return ((ErrorIdProvider)((Object)throwable)).getErrorId();
        }
        return UnknownErrorId.NOT_DEFINED;
    }

    private static ExceptionProto.ExceptionClassType.Builder getExceptionClassType(Throwable throwable) {
        return ExceptionProto.ExceptionClassType.newBuilder().setClassName(throwable.getClass().getName());
    }

    private static ExceptionProto.StackTrace getStackTrace(Throwable throwable) {
        return ErrorModelConverter.toStackTraceProto(Arrays.stream(throwable.getStackTrace()));
    }

    public static ExceptionProto.StackTrace toStackTraceProto(Stream<StackTraceElement> stackTraceElements) {
        ExceptionProto.StackTrace.Builder result = ExceptionProto.StackTrace.newBuilder();
        stackTraceElements.map(element -> ExceptionProto.StackTraceElement.newBuilder().setClassName(element.getClassName()).setMethodName(element.getMethodName()).setFileName(Strings.nullToEmpty(element.getFileName())).setLineNumber(element.getLineNumber())).forEach(result::addElement);
        return result.build();
    }

    private static DeserializedException toSingleDeserializedException(ExceptionProto.ExceptionSummary exceptionSummary) {
        DeserializedException result = new DeserializedException(DeserializedErrorId.of(exceptionSummary.getErrorId()), exceptionSummary.getMessage(), exceptionSummary.getClassType().getClassName());
        ErrorModelConverter.setStackTrace(result, exceptionSummary.getStackTrace());
        return result;
    }

    private static void setStackTrace(Throwable throwable, ExceptionProto.StackTrace stackTrace) {
        StackTraceElement[] result = new StackTraceElement[stackTrace.getElementCount()];
        for (int i = 0; i < stackTrace.getElementCount(); ++i) {
            ExceptionProto.StackTraceElement element = stackTrace.getElement(i);
            result[i] = new StackTraceElement(element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber());
        }
        throwable.setStackTrace(result);
    }

    public static ExceptionProto.FlattenedExceptionDetail toFlattenedExceptionDetail(ExceptionProto.ExceptionDetail exceptionDetail) {
        ErrorIdProto.ErrorId criticalErrorId = ErrorModelConverter.getCriticalErrorId(exceptionDetail);
        ErrorIdProto.ErrorId userFacingCriticalErrorId = ErrorModelConverter.getUserFacingCriticalError(exceptionDetail).getSummary().getErrorId();
        ErrorIdProto.ErrorId errorId = exceptionDetail.getSummary().getErrorId();
        ExceptionProto.FlattenedExceptionDetail.Builder flattenedExceptionDetail = ExceptionProto.FlattenedExceptionDetail.newBuilder().setSummary(exceptionDetail.getSummary()).setCompleteStackTrace(ErrorModelConverter.getCompleteStackTrace(exceptionDetail)).setCriticalErrorId(criticalErrorId).setUserFacingCriticalErrorId(userFacingCriticalErrorId);
        StringBuilder errorNameStackTrace = new StringBuilder(errorId.getName());
        StringBuilder errorCodeStackTrace = new StringBuilder(String.valueOf(errorId.getCode()));
        ExceptionProto.ExceptionDetail cause = exceptionDetail;
        while (cause.hasCause()) {
            cause = cause.getCause();
            flattenedExceptionDetail.addCause(cause.getSummary().toBuilder().clearStackTrace());
            errorNameStackTrace.append("|").append(cause.getSummary().getErrorId().getName());
            errorCodeStackTrace.append("|").append(cause.getSummary().getErrorId().getCode());
        }
        return flattenedExceptionDetail.setErrorNameStackTrace(errorNameStackTrace.toString()).setErrorCodeStackTrace(errorCodeStackTrace.toString()).build();
    }

    public static ExceptionProto.FlattenedExceptionDetail toFlattenedExceptionDetail(Throwable throwable) {
        return ErrorModelConverter.toFlattenedExceptionDetail(ErrorModelConverter.toExceptionDetail(throwable));
    }

    public static String getCompleteStackTrace(ExceptionProto.ExceptionDetail detail) {
        return Throwables.getStackTraceAsString(ErrorModelConverter.toDeserializedException(detail));
    }

    public static ErrorIdProto.ErrorId getCriticalErrorId(ExceptionProto.ExceptionDetail detail) {
        return ErrorModelConverter.getCriticalError(detail).getSummary().getErrorId();
    }

    public static ExceptionProto.ExceptionDetail getCriticalError(ExceptionProto.ExceptionDetail detail) {
        Optional<ErrorTypeProto.ErrorType> aggregatedErrorType;
        ExceptionProto.ExceptionDetail current = detail;
        while (!(aggregatedErrorType = ErrorModelConverter.getDeterminedErrorType(current.getSummary().getErrorId().getType())).isPresent() && current.hasCause()) {
            current = current.getCause();
        }
        if (aggregatedErrorType.isEmpty()) {
            current = detail;
        }
        return current;
    }

    public static ErrorIdProto.ErrorId getUserFacingCriticalErrorId(ExceptionProto.ExceptionDetail detail) {
        return ErrorModelConverter.getUserFacingCriticalError(detail).getSummary().getErrorId();
    }

    public static ExceptionProto.ExceptionDetail getUserFacingCriticalError(ExceptionProto.ExceptionDetail detail) {
        ExceptionProto.ExceptionDetail current = detail;
        ExceptionProto.ExceptionDetail prevDetermined = detail;
        ErrorTypeProto.ErrorType currentType;
        while ((currentType = current.getSummary().getErrorId().getType()) != ErrorTypeProto.ErrorType.INFRA_ISSUE && currentType != ErrorTypeProto.ErrorType.CUSTOMER_ISSUE) {
            if (!current.hasCause()) {
                return ErrorModelConverter.isDeterminedErrorType(currentType) ? current : prevDetermined;
            }
            if (ErrorModelConverter.isDeterminedErrorType(currentType)) {
                prevDetermined = current;
            }
            current = current.getCause();
        }
        return current;
    }

    private static Optional<ErrorTypeProto.ErrorType> getDeterminedErrorType(ErrorTypeProto.ErrorType errorType) {
        return ErrorModelConverter.isDeterminedErrorType(errorType) ? Optional.of(errorType) : Optional.empty();
    }

    private static boolean isDeterminedErrorType(ErrorTypeProto.ErrorType errorType) {
        return errorType != ErrorTypeProto.ErrorType.UNCLASSIFIED && errorType != ErrorTypeProto.ErrorType.UNDETERMINED;
    }

    public static boolean hasMhInfraIssue(ExceptionProto.ExceptionDetail detail) {
        return detail.getSummary().getErrorId().getType() == ErrorTypeProto.ErrorType.INFRA_ISSUE && detail.getSummary().getErrorId().getNamespace() == NamespaceProto.Namespace.MH || Stream.concat(detail.hasCause() ? Stream.of(detail.getCause()) : Stream.empty(), detail.getSuppressedList().stream()).anyMatch(ErrorModelConverter::hasMhInfraIssue);
    }

    private ErrorModelConverter() {
    }
}

