/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger;

import com.google.common.flogger.LogContext;
import com.google.common.flogger.LogSiteKey;
import com.google.common.flogger.LogSiteMap;
import com.google.common.flogger.RateLimitStatus;
import com.google.common.flogger.backend.Metadata;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class SamplingRateLimiter
extends RateLimitStatus {
    private static final LogSiteMap<SamplingRateLimiter> map = new LogSiteMap<SamplingRateLimiter>(){

        @Override
        protected SamplingRateLimiter initialValue() {
            return new SamplingRateLimiter();
        }
    };
    private static final ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    final AtomicInteger pendingCount = new AtomicInteger();

    @NullableDecl
    static RateLimitStatus check(Metadata metadata, LogSiteKey logSiteKey) {
        Integer rateLimitCount = metadata.findValue(LogContext.Key.LOG_SAMPLE_EVERY_N);
        if (rateLimitCount == null || rateLimitCount <= 0) {
            return null;
        }
        return map.get(logSiteKey, metadata).sampleOneIn(rateLimitCount);
    }

    SamplingRateLimiter() {
    }

    RateLimitStatus sampleOneIn(int rateLimitCount) {
        int pending = random.get().nextInt(rateLimitCount) == 0 ? this.pendingCount.incrementAndGet() : this.pendingCount.get();
        return pending > 0 ? this : DISALLOW;
    }

    @Override
    public void reset() {
        this.pendingCount.decrementAndGet();
    }
}

