/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.result.suite.SuiteResultHolder;
import com.android.tradefed.result.suite.XmlSuiteResultFormatter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class CertificationResultXml
extends XmlSuiteResultFormatter {
    public static final String SUITE_PLAN_ATTR = "suite_plan";
    private static final String LOG_URL_ATTR = "log_url";
    private static final String REPORT_VERSION_ATTR = "report_version";
    private static final String REFERENCE_URL_ATTR = "reference_url";
    private static final String RESULT_FILE_VERSION = "5.0";
    private static final String SUITE_NAME_ATTR = "suite_name";
    private static final String SUITE_VERSION_ATTR = "suite_version";
    private static final String SUITE_BUILD_ATTR = "suite_build_number";
    private static final String SUITE_VARIANT_ATTR = "suite_variant";
    private String mSuiteName;
    private String mSuiteVersion;
    private String mSuiteVariant;
    private String mSuitePlan;
    private String mSuiteBuild;
    private String mReferenceUrl;
    private String mLogUrl;
    private Map<String, String> mResultAttributes = new HashMap<String, String>();

    public CertificationResultXml() {
    }

    public CertificationResultXml(String suiteName, String suiteVersion, String suiteVariant, String suitePlan, String suiteBuild, String referenceUrl, String logUrl, Map<String, String> resultAttributes) {
        this.mSuiteName = suiteName;
        this.mSuiteVersion = suiteVersion;
        this.mSuiteVariant = suiteVariant;
        this.mSuitePlan = suitePlan;
        this.mSuiteBuild = suiteBuild;
        this.mReferenceUrl = referenceUrl;
        this.mLogUrl = logUrl;
        this.mResultAttributes = resultAttributes;
    }

    public void addSuiteAttributes(XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.attribute(NS, SUITE_NAME_ATTR, this.mSuiteName);
        if (this.mSuiteVariant != null) {
            serializer.attribute(NS, SUITE_VARIANT_ATTR, this.mSuiteVariant);
        } else {
            serializer.attribute(NS, SUITE_VARIANT_ATTR, this.mSuiteName);
        }
        serializer.attribute(NS, SUITE_VERSION_ATTR, this.mSuiteVersion);
        serializer.attribute(NS, SUITE_PLAN_ATTR, this.mSuitePlan);
        serializer.attribute(NS, SUITE_BUILD_ATTR, this.mSuiteBuild);
        serializer.attribute(NS, REPORT_VERSION_ATTR, RESULT_FILE_VERSION);
        if (this.mReferenceUrl != null) {
            serializer.attribute(NS, REFERENCE_URL_ATTR, this.mReferenceUrl);
        }
        if (this.mLogUrl != null) {
            serializer.attribute(NS, LOG_URL_ATTR, this.mLogUrl);
        }
        if (this.mResultAttributes != null) {
            for (Map.Entry<String, String> entry : this.mResultAttributes.entrySet()) {
                serializer.attribute(NS, entry.getKey(), entry.getValue());
            }
        }
    }

    public void parseSuiteAttributes(XmlPullParser parser, IInvocationContext context) throws XmlPullParserException {
        this.mSuiteName = parser.getAttributeValue(NS, SUITE_NAME_ATTR);
        context.addInvocationAttribute(SUITE_NAME_ATTR, this.mSuiteName);
        this.mSuiteVersion = parser.getAttributeValue(NS, SUITE_VERSION_ATTR);
        context.addInvocationAttribute(SUITE_VERSION_ATTR, this.mSuiteVersion);
        this.mSuitePlan = parser.getAttributeValue(NS, SUITE_PLAN_ATTR);
        context.addInvocationAttribute(SUITE_PLAN_ATTR, this.mSuitePlan);
        this.mSuiteBuild = parser.getAttributeValue(NS, SUITE_BUILD_ATTR);
        context.addInvocationAttribute(SUITE_BUILD_ATTR, this.mSuiteBuild);
        this.mReferenceUrl = parser.getAttributeValue(NS, REFERENCE_URL_ATTR);
        if (this.mReferenceUrl != null) {
            context.addInvocationAttribute(REFERENCE_URL_ATTR, this.mReferenceUrl);
        }
        this.mLogUrl = parser.getAttributeValue(NS, LOG_URL_ATTR);
        if (this.mLogUrl != null) {
            context.addInvocationAttribute(LOG_URL_ATTR, this.mLogUrl);
        }
    }

    public void addBuildInfoAttributes(XmlSerializer serializer, SuiteResultHolder holder) throws IllegalArgumentException, IllegalStateException, IOException {
        HashMap<String, String> processedKeys = new HashMap<String, String>();
        for (IBuildInfo build : holder.context.getBuildInfos()) {
            for (String key : build.getBuildAttributes().keySet()) {
                String newKey;
                if (!key.startsWith(this.getAttributesPrefix()) || processedKeys.containsKey(newKey = key.split(this.getAttributesPrefix())[1])) continue;
                processedKeys.put(newKey, key);
                serializer.attribute(NS, newKey, (String)build.getBuildAttributes().get(key));
            }
        }
    }

    public void parseBuildInfoAttributes(XmlPullParser parser, IInvocationContext context) throws XmlPullParserException {
        for (int index = 0; index < parser.getAttributeCount(); ++index) {
            String key = parser.getAttributeName(index);
            String value = parser.getAttributeValue(NS, key);
            context.addInvocationAttribute(key, value);
        }
    }

    public String getAttributesPrefix() {
        return "cts:";
    }
}

