/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.testtype.ISubPlan;
import com.android.compatibility.common.tradefed.testtype.SubPlan;
import com.android.compatibility.common.tradefed.util.OptionHelper;
import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.ResultHandler;
import com.android.compatibility.common.util.TestFilter;
import com.android.compatibility.common.util.TestStatus;
import com.android.ddmlib.Log;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.xml.AbstractXmlParser;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SubPlanHelper {
    private static final String XML_EXT = ".xml";
    private static final String PARAM_START = "[";
    public static final String PASSED = "passed";
    public static final String FAILED = "failed";
    public static final String NOT_EXECUTED = "not_executed";
    private static final Map<String, TestStatus> STATUS_MAP;
    @Option(name="name", shortName=110, description="the name of the subplan to create", importance=Option.Importance.IF_UNSET)
    private String mSubPlanName = null;
    @Option(name="session", description="the session id to derive from", importance=Option.Importance.IF_UNSET)
    private Integer mSessionId = null;
    @Option(name="result-type", description="the result type to include. One of passed, failed, not_executed. Option may be repeated", importance=Option.Importance.IF_UNSET)
    private Set<String> mResultTypes = new HashSet<String>();
    @Option(name="include-filter", description="the include module filters to apply.", importance=Option.Importance.NEVER)
    private Set<String> mIncludeFilters = new HashSet<String>();
    @Option(name="exclude-filter", description="the exclude module filters to apply.", importance=Option.Importance.NEVER)
    private Set<String> mExcludeFilters = new HashSet<String>();
    @Option(name="module", shortName=109, description="the test module to run.", importance=Option.Importance.NEVER)
    private String mModuleName = null;
    @Option(name="test", shortName=116, description="the test to run.", importance=Option.Importance.NEVER)
    private String mTestName = null;
    @Option(name="abi", shortName=97, description="the abi to test.", importance=Option.Importance.NEVER)
    private String mAbiName = null;
    @Option(name="subplan", description="the subplan used in the previous session", importance=Option.Importance.NEVER)
    private String mLastSubPlan;
    File mSubPlanFile = null;
    IInvocationResult mResult = null;

    public SubPlanHelper() {
    }

    public SubPlanHelper(String name, int session, Collection<String> resultTypes) {
        this.mSubPlanName = name;
        this.mSessionId = session;
        this.mResultTypes.addAll(resultTypes);
    }

    public static ISubPlan getSubPlanByName(CompatibilityBuildHelper buildHelper, String name) {
        SubPlan subPlan;
        if (!name.endsWith(XML_EXT)) {
            name = name + XML_EXT;
        }
        FileInputStream subPlanInputStream = null;
        try {
            File subPlanFile = new File(buildHelper.getSubPlansDir(), name);
            if (!subPlanFile.exists()) {
                throw new IllegalArgumentException(String.format("Could not retrieve subplan \"%s\"", name));
            }
            subPlanInputStream = new FileInputStream(subPlanFile);
            SubPlan subPlan2 = new SubPlan();
            subPlan2.parse(subPlanInputStream);
            subPlan = subPlan2;
        }
        catch (AbstractXmlParser.ParseException | FileNotFoundException e) {
            try {
                throw new RuntimeException(String.format("Unable to find or parse subplan %s", name), e);
            }
            catch (Throwable throwable) {
                StreamUtil.close(subPlanInputStream);
                throw throwable;
            }
        }
        StreamUtil.close((Closeable)subPlanInputStream);
        return subPlan;
    }

    public void setResult(IInvocationResult result) {
        this.mResult = result;
    }

    public void addResultType(String resultType) {
        this.mResultTypes.add(resultType);
    }

    public File createAndSerializeSubPlan(CompatibilityBuildHelper buildHelper) throws ConfigurationException {
        ISubPlan subPlan = this.createSubPlan(buildHelper);
        if (subPlan != null) {
            try {
                subPlan.serialize(new BufferedOutputStream(new FileOutputStream(this.mSubPlanFile)));
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Created subplan \"%s\" at %s", (Object[])new Object[]{this.mSubPlanName, this.mSubPlanFile.getAbsolutePath()});
                return this.mSubPlanFile;
            }
            catch (IOException e) {
                LogUtil.CLog.e((String)"Failed to create plan file %s", (Object[])new Object[]{this.mSubPlanFile.getAbsolutePath()});
                LogUtil.CLog.e((Throwable)e);
            }
        }
        return null;
    }

    public ISubPlan createSubPlan(CompatibilityBuildHelper buildHelper) throws ConfigurationException {
        this.setupFields(buildHelper);
        SubPlan subPlan = new SubPlan();
        subPlan.addAllIncludeFilters(this.mIncludeFilters);
        subPlan.addAllExcludeFilters(this.mExcludeFilters);
        if (this.mLastSubPlan != null) {
            ISubPlan lastSubPlan = SubPlanHelper.getSubPlanByName(buildHelper, this.mLastSubPlan);
            subPlan.addAllIncludeFilters(lastSubPlan.getIncludeFilters());
            subPlan.addAllExcludeFilters(lastSubPlan.getExcludeFilters());
        }
        if (this.mModuleName != null) {
            SubPlanHelper.addIncludeToSubPlan(subPlan, new TestFilter(this.mAbiName, this.mModuleName, this.mTestName));
        }
        Set<TestStatus> statusesToRun = this.getStatusesToRun();
        for (IModuleResult module : this.mResult.getModules()) {
            if (this.shouldRunModule(module)) {
                TestFilter moduleInclude = new TestFilter(module.getAbi(), module.getName(), null);
                if (this.shouldRunEntireModule(module)) {
                    SubPlanHelper.addIncludeToSubPlan(subPlan, moduleInclude);
                    continue;
                }
                if (this.mResultTypes.contains(NOT_EXECUTED) && !module.isDone()) {
                    SubPlanHelper.addIncludeToSubPlan(subPlan, moduleInclude);
                    for (ICaseResult caseResult : module.getResults()) {
                        for (ITestResult testResult : caseResult.getResults()) {
                            if (statusesToRun.contains(testResult.getResultStatus())) continue;
                            TestFilter testExclude = new TestFilter(module.getAbi(), module.getName(), testResult.getFullName());
                            SubPlanHelper.addExcludeToSubPlan(subPlan, testExclude);
                        }
                    }
                    continue;
                }
                for (ICaseResult caseResult : module.getResults()) {
                    for (ITestResult testResult : caseResult.getResults()) {
                        if (!statusesToRun.contains(testResult.getResultStatus())) continue;
                        TestFilter testInclude = new TestFilter(module.getAbi(), module.getName(), testResult.getFullName());
                        SubPlanHelper.addIncludeToSubPlan(subPlan, testInclude);
                    }
                }
                continue;
            }
            TestFilter moduleExclude = new TestFilter(module.getAbi(), module.getName(), null);
            SubPlanHelper.addExcludeToSubPlan(subPlan, moduleExclude);
        }
        return subPlan;
    }

    @VisibleForTesting
    static void addIncludeToSubPlan(ISubPlan subPlan, TestFilter include) {
        String test = include.getTest();
        String str = include.toString();
        if (test == null || !test.contains(PARAM_START)) {
            subPlan.addIncludeFilter(str);
        } else if (test.contains(PARAM_START)) {
            subPlan.addIncludeFilter(str.substring(0, str.lastIndexOf(PARAM_START)));
        }
    }

    @VisibleForTesting
    static void addExcludeToSubPlan(ISubPlan subPlan, TestFilter exclude) {
        String test = exclude.getTest();
        String str = exclude.toString();
        if (test == null || !test.contains(PARAM_START)) {
            subPlan.addExcludeFilter(str);
        }
    }

    private boolean shouldRunModule(IModuleResult module) {
        if (this.mResultTypes.contains(NOT_EXECUTED) && !module.isDone()) {
            return true;
        }
        for (TestStatus status : this.getStatusesToRun()) {
            if (module.countResults(status) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean shouldRunEntireModule(IModuleResult module) {
        if (!this.mResultTypes.contains(NOT_EXECUTED) && !module.isDone()) {
            return false;
        }
        Set<TestStatus> statusesToRun = this.getStatusesToRun();
        for (TestStatus status : TestStatus.values()) {
            if (statusesToRun.contains(status) || module.countResults(status) <= 0) continue;
            return false;
        }
        return true;
    }

    private Set<TestStatus> getStatusesToRun() {
        HashSet<TestStatus> statusesToRun = new HashSet<TestStatus>();
        for (String resultType : this.mResultTypes) {
            if (NOT_EXECUTED.equals(resultType)) continue;
            statusesToRun.add(STATUS_MAP.get(resultType));
        }
        return statusesToRun;
    }

    private void setupFields(CompatibilityBuildHelper buildHelper) throws ConfigurationException {
        String retryCommandLineArgs;
        if (this.mResult == null) {
            if (this.mSessionId == null) {
                throw new ConfigurationException("Missing --session argument");
            }
            try {
                this.mResult = ResultHandler.findResult((File)buildHelper.getResultsDir(), (Integer)this.mSessionId);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (this.mResult == null) {
                throw new IllegalArgumentException(String.format("Could not find session with id %d", this.mSessionId));
            }
        }
        if ((retryCommandLineArgs = this.mResult.getCommandLineArgs()) != null) {
            try {
                ArgsOptionParser parser = new ArgsOptionParser(new Object[]{this});
                parser.parse(OptionHelper.getValidCliArgs(retryCommandLineArgs, this));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.mResultTypes.isEmpty()) {
            this.mResultTypes.addAll(new HashSet<String>(Arrays.asList(PASSED, FAILED, NOT_EXECUTED)));
        }
        for (String type : this.mResultTypes) {
            if (type.equals(PASSED) || type.equals(FAILED) || type.equals(NOT_EXECUTED)) continue;
            throw new ConfigurationException(String.format("result type %s invalid", type));
        }
        if (this.mSubPlanName == null) {
            this.mSubPlanName = this.createPlanName();
        }
        try {
            this.mSubPlanFile = new File(buildHelper.getSubPlansDir(), this.mSubPlanName + XML_EXT);
            if (this.mSubPlanFile.exists()) {
                throw new ConfigurationException(String.format("Subplan %s already exists", this.mSubPlanName));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find subplans directory");
        }
    }

    private String createPlanName() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.join((CharSequence)"_", this.mResultTypes));
        sb.append("_");
        if (this.mSessionId != null) {
            sb.append(Integer.toString(this.mSessionId));
            sb.append("_");
        }
        sb.append(CompatibilityBuildHelper.getDirSuffix(this.mResult.getStartTime()));
        return sb.toString();
    }

    static {
        HashMap<String, TestStatus> statusMap = new HashMap<String, TestStatus>();
        statusMap.put(PASSED, TestStatus.PASS);
        statusMap.put(FAILED, TestStatus.FAIL);
        STATUS_MAP = Collections.unmodifiableMap(statusMap);
    }
}

