/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.util;

import java.util.concurrent.TimeUnit;

public class NumberFormattingUtil {
    private NumberFormattingUtil() {
    }

    public static long getMs(long days, long hours, long mins, long secs, long msecs) {
        return (((24L * days + hours) * 60L + mins) * 60L + secs) * 1000L + msecs;
    }

    public static long getMs(long hours, long mins, long secs, long msecs) {
        return NumberFormattingUtil.getMs(0L, hours, mins, secs, msecs);
    }

    public static long parseLongOrZero(String s) throws NumberFormatException {
        if (s == null) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static int parseIntOrZero(String s) throws NumberFormatException {
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public static String getDuration(long ms) {
        if (ms <= 0L) {
            return "Not a valid time";
        }
        long days = TimeUnit.MILLISECONDS.toDays(ms);
        long hrs = TimeUnit.MILLISECONDS.toHours(ms - TimeUnit.DAYS.toMillis(days));
        long mins = TimeUnit.MILLISECONDS.toMinutes(ms - TimeUnit.DAYS.toMillis(days) - TimeUnit.HOURS.toMillis(hrs));
        long secs = TimeUnit.MILLISECONDS.toSeconds(ms - TimeUnit.DAYS.toMillis(days) - TimeUnit.HOURS.toMillis(hrs) - TimeUnit.MINUTES.toMillis(mins));
        return String.format("%dd %dh %dm %ds", days, hrs, mins, secs);
    }
}

