/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogPatternUtil {
    private Set<PatternInfo> mPatterns = new HashSet<PatternInfo>();

    public void addPattern(Pattern pattern, String category) {
        this.addPattern(pattern, null, category);
    }

    public void addPattern(Pattern pattern, Object extras, String category) {
        this.mPatterns.add(new PatternInfo(pattern, extras, category));
    }

    public String checkMessage(String message) {
        return this.checkMessage(message, null);
    }

    public String checkMessage(String message, Object extras) {
        for (PatternInfo patternInfo : this.mPatterns) {
            Matcher m = patternInfo.mPattern.matcher(message);
            if (!m.matches() || patternInfo.mExtras != null && !patternInfo.mExtras.equals(extras)) continue;
            return patternInfo.mCategory;
        }
        return null;
    }

    private class PatternInfo {
        public Pattern mPattern;
        public Object mExtras;
        public String mCategory;

        public PatternInfo(Pattern pattern, Object extras, String category) {
            this.mPattern = pattern;
            this.mExtras = extras;
            this.mCategory = category;
        }
    }
}

