/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.AppVersionItem;
import com.android.loganalysis.item.DumpsysPackageStatsItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DumpsysPackageStatsParser
implements IParser {
    private static final Pattern PACKAGE_NAME = Pattern.compile("^\\s*Package \\[(.*)\\].*");
    private static final Pattern VERSION_CODE = Pattern.compile("^\\s*versionCode=(\\d+).*");
    private static final Pattern VERSION_NAME = Pattern.compile("^\\s*versionName=(.*)$");

    @Override
    public DumpsysPackageStatsItem parse(List<String> lines) {
        DumpsysPackageStatsItem item = new DumpsysPackageStatsItem();
        String packageName = null;
        String versionCode = null;
        String versionName = null;
        for (String line : lines) {
            Matcher m = PACKAGE_NAME.matcher(line);
            if (m.matches()) {
                packageName = m.group(1);
                versionCode = null;
                versionName = null;
                continue;
            }
            m = VERSION_CODE.matcher(line);
            if (m.matches()) {
                versionCode = m.group(1);
                continue;
            }
            m = VERSION_NAME.matcher(line);
            if (!m.matches()) continue;
            versionName = m.group(1).trim();
            if (packageName != null && versionCode != null) {
                item.put(packageName, new AppVersionItem(Integer.parseInt(versionCode), versionName));
            }
            packageName = null;
        }
        return item;
    }
}

