/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.CpuInfoItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CpuInfoParser
implements IParser {
    private static final Pattern USAGE_PREFIX = Pattern.compile("^ *\\+?(\\d+\\.?\\d*)\\% (\\d+)/([^ ]+): ");

    @Override
    public CpuInfoItem parse(List<String> lines) {
        CpuInfoItem item = new CpuInfoItem();
        for (String line : lines) {
            Matcher m = USAGE_PREFIX.matcher(line);
            if (!m.lookingAt() || m.groupCount() != 3) continue;
            int pid = Integer.parseInt(m.group(2));
            double percent = Double.parseDouble(m.group(1));
            String name = m.group(3);
            item.addRow(pid, percent, name);
        }
        return item;
    }
}

