/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.AnrItem;
import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.GenericItem;
import com.android.loganalysis.item.IItem;
import com.android.loganalysis.item.JavaCrashItem;
import com.android.loganalysis.item.MiscLogcatItem;
import com.android.loganalysis.item.NativeCrashItem;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogcatItem
extends GenericItem {
    public static final String START_TIME = "START_TIME";
    public static final String STOP_TIME = "STOP_TIME";
    public static final String EVENTS = "EVENTS";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("START_TIME", "STOP_TIME", "EVENTS"));

    public LogcatItem() {
        super(ATTRIBUTES);
        this.setAttribute(EVENTS, new ItemList());
    }

    public Date getStartTime() {
        return (Date)this.getAttribute(START_TIME);
    }

    public void setStartTime(Date time) {
        this.setAttribute(START_TIME, time);
    }

    public Date getStopTime() {
        return (Date)this.getAttribute(STOP_TIME);
    }

    public void setStopTime(Date time) {
        this.setAttribute(STOP_TIME, time);
    }

    public List<MiscLogcatItem> getEvents() {
        return (ItemList)this.getAttribute(EVENTS);
    }

    public void addEvent(MiscLogcatItem event) {
        ((ItemList)this.getAttribute(EVENTS)).add(event);
    }

    public List<AnrItem> getAnrs() {
        LinkedList<AnrItem> anrs = new LinkedList<AnrItem>();
        for (IItem iItem : this.getEvents()) {
            if (!(iItem instanceof AnrItem)) continue;
            anrs.add((AnrItem)iItem);
        }
        return anrs;
    }

    public List<JavaCrashItem> getJavaCrashes() {
        LinkedList<JavaCrashItem> jcs = new LinkedList<JavaCrashItem>();
        for (IItem iItem : this.getEvents()) {
            if (!(iItem instanceof JavaCrashItem)) continue;
            jcs.add((JavaCrashItem)iItem);
        }
        return jcs;
    }

    public List<NativeCrashItem> getNativeCrashes() {
        LinkedList<NativeCrashItem> ncs = new LinkedList<NativeCrashItem>();
        for (IItem iItem : this.getEvents()) {
            if (!(iItem instanceof NativeCrashItem)) continue;
            ncs.add((NativeCrashItem)iItem);
        }
        return ncs;
    }

    public List<MiscLogcatItem> getMiscEvents(String category) {
        LinkedList<MiscLogcatItem> items = new LinkedList<MiscLogcatItem>();
        for (MiscLogcatItem item : this.getEvents()) {
            if (!item.getCategory().equals(category)) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public LogcatItem merge(IItem other) throws ConflictingItemException {
        Date eventTime;
        if (this == other) {
            return this;
        }
        if (other == null || !(other instanceof LogcatItem)) {
            throw new ConflictingItemException("Conflicting class types");
        }
        LogcatItem logcat = (LogcatItem)other;
        Date start = logcat.getStartTime().before(this.getStartTime()) ? logcat.getStartTime() : this.getStartTime();
        Date stop = logcat.getStopTime().after(this.getStopTime()) ? logcat.getStopTime() : this.getStopTime();
        Date overlapStart = logcat.getStartTime().after(this.getStartTime()) ? logcat.getStartTime() : this.getStartTime();
        Date overlapStop = logcat.getStopTime().before(this.getStopTime()) ? logcat.getStopTime() : this.getStopTime();
        ItemList mergedEvents = new ItemList();
        for (MiscLogcatItem event : this.getEvents()) {
            eventTime = event.getEventTime();
            if (eventTime.after(overlapStart) && eventTime.before(overlapStop) && !logcat.getEvents().contains(event)) {
                throw new ConflictingItemException("Event in first logcat not contained in overlapping portion of other logcat.");
            }
            mergedEvents.add(event);
        }
        for (MiscLogcatItem event : logcat.getEvents()) {
            eventTime = event.getEventTime();
            if (eventTime.after(overlapStart) && eventTime.before(overlapStop)) {
                if (this.getEvents().contains(event)) continue;
                throw new ConflictingItemException("Event in first logcat not contained in overlapping portion of other logcat.");
            }
            mergedEvents.add(event);
        }
        LogcatItem mergedLogcat = new LogcatItem();
        mergedLogcat.setStartTime(start);
        mergedLogcat.setStopTime(stop);
        mergedLogcat.setAttribute(EVENTS, mergedEvents);
        return mergedLogcat;
    }

    @Override
    public JSONObject toJson() {
        JSONObject output = super.toJson();
        JSONArray events = new JSONArray();
        for (MiscLogcatItem event : this.getEvents()) {
            events.put((Object)event.toJson());
        }
        try {
            output.put(EVENTS, (Object)events);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return output;
    }

    private class ItemList
    extends LinkedList<MiscLogcatItem> {
        private ItemList() {
        }
    }
}

