/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.tradefed.util.AbiUtils;

public class TestFilter {
    private final String mAbi;
    private final String mName;
    private final String mTest;

    public static TestFilter createFrom(String filter) {
        if (filter.isEmpty()) {
            throw new IllegalArgumentException("Filter was empty");
        }
        String[] parts = filter.split(" ");
        String abi = null;
        String name = null;
        String test = null;
        if (parts.length == 1) {
            name = parts[0];
        } else {
            int index = 0;
            if (AbiUtils.isAbiSupportedByCompatibility((String)parts[0])) {
                abi = parts[0];
                ++index;
            }
            name = parts[index];
            if ((parts = filter.split(" ", ++index + 1)).length > index) {
                test = parts[index];
            }
        }
        return new TestFilter(abi, name, test);
    }

    public TestFilter(String abi, String name, String test) {
        this.mAbi = abi;
        this.mName = name;
        this.mTest = test;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mAbi != null) {
            sb.append(this.mAbi.trim());
            sb.append(" ");
        }
        if (this.mName != null) {
            sb.append(this.mName.trim());
        }
        if (this.mTest != null) {
            sb.append(" ");
            sb.append(this.mTest.trim());
        }
        return sb.toString();
    }

    public String getAbi() {
        return this.mAbi;
    }

    public String getName() {
        return this.mName;
    }

    public String getTest() {
        return this.mTest;
    }
}

