/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;

public class RootProcessScanner {
    private Set<String> mPidDirs;
    private ITestDevice mDevice;
    private static final Pattern ROOT_PROCESS_WHITELIST_PATTERN = RootProcessScanner.getRootProcessWhitelistPattern("debuggerd", "debuggerd64", "healthd", "init", "installd", "lmkd", "netd", "servicemanager", "ueventd", "vold", "watchdogd", "zygote");

    public RootProcessScanner(ITestDevice device) throws DeviceNotAvailableException {
        String[] lines;
        this.mDevice = device;
        this.mPidDirs = new HashSet<String>();
        String lsOutput = device.executeShellCommand("ls -F /proc | grep /$");
        for (String line : lines = lsOutput.split("/?\r?\n")) {
            if (!Pattern.matches("\\d+", line)) continue;
            this.mPidDirs.add(String.format("/proc/%s", line));
        }
    }

    private static Pattern getRootProcessWhitelistPattern(String ... patterns) {
        StringBuilder rootProcessPattern = new StringBuilder();
        for (int i = 0; i < patterns.length; ++i) {
            rootProcessPattern.append(patterns[i]);
            if (i + 1 >= patterns.length) continue;
            rootProcessPattern.append('|');
        }
        return Pattern.compile(rootProcessPattern.toString());
    }

    public Set<String> getRootProcesses(boolean approved) throws DeviceNotAvailableException, MalformedStatMException {
        Set<String> rootProcessDirs = this.getRootProcessDirs(approved);
        HashSet<String> rootProcessNames = new HashSet<String>();
        for (String dir : rootProcessDirs) {
            rootProcessNames.add(this.getProcessName(dir));
        }
        return rootProcessNames;
    }

    private Set<String> getRootProcessDirs(boolean approved) throws DeviceNotAvailableException, MalformedStatMException {
        HashSet<String> rootProcesses = new HashSet<String>();
        if (this.mPidDirs != null && this.mPidDirs.size() > 0) {
            for (String processDir : this.mPidDirs) {
                if (!this.isRootProcessDir(processDir, approved)) continue;
                rootProcesses.add(processDir);
            }
        } else {
            LogUtil.CLog.e((String)"RootProcessScanner Failed to collect PID directories.");
        }
        return rootProcesses;
    }

    private boolean isRootProcessDir(String pathname, boolean approved) throws DeviceNotAvailableException, MalformedStatMException {
        try {
            return !this.isKernelProcess(pathname) && this.isRootProcess(pathname) && this.isApproved(pathname) == approved;
        }
        catch (InputMismatchException e) {
            LogUtil.CLog.d((String)"Path %s determined not to be a root process directory", (Object[])new Object[]{pathname});
            return false;
        }
    }

    private boolean isKernelProcess(String processDir) throws DeviceNotAvailableException, MalformedStatMException {
        String statm = this.getProcessStatM(processDir);
        try (Scanner scanner = new Scanner(statm);){
            boolean allZero = true;
            for (int i = 0; i < 7; ++i) {
                if (scanner.nextInt() == 0) continue;
                allZero = false;
            }
            if (scanner.hasNext()) {
                throw new MalformedStatMException(processDir + " statm expected to have 7 integers (man 5 proc)");
            }
            boolean bl = allZero;
            return bl;
        }
    }

    private String getProcessStatM(String processDir) throws DeviceNotAvailableException {
        return this.mDevice.executeShellCommand(String.format("cat %s/statm", processDir));
    }

    private boolean isRootProcess(String processDir) throws DeviceNotAvailableException {
        String status = this.getProcessStatus(processDir);
        try (Scanner scanner = new Scanner(status);){
            RootProcessScanner.findToken(scanner, "Uid:");
            boolean rootUid = RootProcessScanner.hasRootId(scanner);
            RootProcessScanner.findToken(scanner, "Gid:");
            boolean rootGid = RootProcessScanner.hasRootId(scanner);
            boolean bl = rootUid || rootGid;
            return bl;
        }
    }

    private boolean isApproved(String processDir) throws DeviceNotAvailableException {
        String status = this.getProcessStatus(processDir);
        try (Scanner scanner = new Scanner(status);){
            RootProcessScanner.findToken(scanner, "Name:");
            String name = scanner.next();
            boolean bl = ROOT_PROCESS_WHITELIST_PATTERN.matcher(name).matches();
            return bl;
        }
    }

    private String getProcessStatus(String processDir) throws DeviceNotAvailableException {
        return this.mDevice.executeShellCommand(String.format("cat %s/status", processDir));
    }

    private static void findToken(Scanner scanner, String token) {
        String next;
        while (!(next = scanner.next()).equals(token)) {
        }
    }

    private static boolean hasRootId(Scanner scanner) {
        int realUid = scanner.nextInt();
        int effectiveUid = scanner.nextInt();
        int savedSetUid = scanner.nextInt();
        int fileSystemUid = scanner.nextInt();
        return realUid == 0 || effectiveUid == 0 || savedSetUid == 0 || fileSystemUid == 0;
    }

    private String getProcessName(String processDir) throws DeviceNotAvailableException {
        String status = this.getProcessStatus(processDir);
        try (Scanner scanner = new Scanner(status);){
            RootProcessScanner.findToken(scanner, "Name:");
            String string = scanner.next();
            return string;
        }
    }

    public static class MalformedStatMException
    extends Exception {
        MalformedStatMException(String detailMessage) {
            super(detailMessage);
        }
    }
}

