/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.qa.mobileharness.shared.model.job;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;

public class JobLocator {
    private final String id;
    private final String name;

    public JobLocator(String id, String name) {
        this.id = Preconditions.checkNotNull(id);
        this.name = Preconditions.checkNotNull(name);
    }

    public JobLocator(String name) {
        this(UUID.randomUUID().toString(), name);
    }

    public JobLocator(com.google.devtools.mobileharness.api.model.job.JobLocator newJobLocator) {
        this(newJobLocator.id(), newJobLocator.name());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobLocator)) {
            return false;
        }
        JobLocator that = (JobLocator)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public com.google.devtools.mobileharness.api.model.job.JobLocator toNewJobLocator() {
        return com.google.devtools.mobileharness.api.model.job.JobLocator.of(this.id, this.name);
    }

    public static JobLocator parseString(String str) {
        return new JobLocator(str, "");
    }
}

