/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.shell;

import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class ShellUtils {
    private static final String SAFE_PUNCTUATION = "@%-_+:,./";

    private ShellUtils() {
    }

    public static String shellEscape(String word) {
        int len = word.length();
        if (len == 0) {
            return "''";
        }
        for (int ii = 0; ii < len; ++ii) {
            char c = word.charAt(ii);
            if (Character.isLetterOrDigit(c) || SAFE_PUNCTUATION.indexOf(c) != -1) continue;
            return "'" + word.replace("'", "'\\''") + "'";
        }
        return word;
    }

    public static String prettyPrintArgv(List<String> argv) {
        StringBuilder buf = new StringBuilder();
        for (String arg : argv) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(ShellUtils.shellEscape(arg));
        }
        return buf.toString();
    }

    public static ImmutableList<String> tokenize(String optionString) throws TokenizationException {
        ImmutableList.Builder result = ImmutableList.builder();
        StringBuilder token = new StringBuilder();
        boolean forceToken = false;
        char quotation = '\u0000';
        int len = optionString.length();
        for (int ii = 0; ii < len; ++ii) {
            char c = optionString.charAt(ii);
            if (quotation != '\u0000') {
                if (c == quotation) {
                    quotation = '\u0000';
                    continue;
                }
                if (c == '\\' && quotation == '\"') {
                    if (++ii == len) {
                        throw new TokenizationException("backslash at end of string");
                    }
                    c = optionString.charAt(ii);
                    if (c != '\\' && c != '\"') {
                        token.append('\\');
                    }
                    token.append(c);
                    continue;
                }
                token.append(c);
                continue;
            }
            if (c == '\'' || c == '\"') {
                quotation = c;
                forceToken = true;
                continue;
            }
            if (c == ' ' || c == '\t') {
                if (!forceToken && token.length() <= 0) continue;
                result.add(token.toString());
                token = new StringBuilder();
                forceToken = false;
                continue;
            }
            if (c == '\\') {
                if (++ii == len) {
                    throw new TokenizationException("backslash at end of string");
                }
                token.append(optionString.charAt(ii));
                continue;
            }
            token.append(c);
        }
        if (quotation != '\u0000') {
            throw new TokenizationException("unterminated quotation");
        }
        if (forceToken || token.length() > 0) {
            result.add(token.toString());
        }
        return result.build();
    }

    public static class TokenizationException
    extends Exception {
        TokenizationException(String message) {
            super(message);
        }
    }
}

