/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.logging.flogger;

import com.google.devtools.mobileharness.shared.util.logging.flogger.FloggerFormatterConstants;
import com.google.devtools.mobileharness.shared.util.logging.flogger.backend.MobileHarnessBackendFactory;

public class FloggerFormatter {
    private static final String OSS_BACKEND_FACTORY_KEY = "flogger.backend_factory";
    private static final String OSS_BACKEND_FACTORY = MobileHarnessBackendFactory.class.getName();
    private static final String CUSTOM_FORMATTER_TEMPLATE_KEY = "google.debug_logs.format_template";
    private static final String CUSTOM_FORMATTER_TEMPLATE_WITHOUT_CONTEXT = "${message}";
    private static final String CUSTOM_FORMATTER_TEMPLATE_WITH_CONTEXT = String.format("%s${!metadata/%s/%s}", "${message}", "[CONTEXT ", " ]");

    public static void initialize() {
        System.setProperty(OSS_BACKEND_FACTORY_KEY, OSS_BACKEND_FACTORY);
        boolean withContext = FloggerFormatterConstants.withContext();
        if (System.getProperty(CUSTOM_FORMATTER_TEMPLATE_KEY) == null) {
            System.setProperty(CUSTOM_FORMATTER_TEMPLATE_KEY, FloggerFormatter.getSimpleCustomFormatterTemplate(withContext));
        }
    }

    private static String getSimpleCustomFormatterTemplate(boolean withContext) {
        return withContext ? CUSTOM_FORMATTER_TEMPLATE_WITH_CONTEXT : CUSTOM_FORMATTER_TEMPLATE_WITHOUT_CONTEXT;
    }

    private FloggerFormatter() {
    }
}

