/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.backend;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.FluentLogger;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.devtools.mobileharness.shared.util.command.backend.NativeProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;

final class AsyncCopier {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    @VisibleForTesting
    static final CopyStrategy REAL_COPY_STRATEGY = ByteStreams::copy;
    private final InputStream source;
    private final OutputStream sink;
    private final Consumer<IOException> ioExceptionHandler;
    private final CopyStrategy copyStrategy;
    private final Future<?> copyFuture;
    private final CountDownLatch copyStarted = new CountDownLatch(1);
    private final CountDownLatch copyTerminated = new CountDownLatch(1);

    static AsyncCopier start(InputStream from, OutputStream to, Consumer<IOException> ioExceptionHandler) {
        return new AsyncCopier(from, to, ioExceptionHandler, REAL_COPY_STRATEGY, NativeProcess.EXECUTOR_SERVICE);
    }

    @VisibleForTesting
    AsyncCopier(InputStream source, OutputStream sink, Consumer<IOException> ioExceptionHandler, CopyStrategy copyStrategy, ExecutorService executorService) {
        this.source = source;
        this.sink = sink;
        this.ioExceptionHandler = ioExceptionHandler;
        this.copyStrategy = copyStrategy;
        this.copyFuture = executorService.submit(this::copy);
        Uninterruptibles.awaitUninterruptibly(this.copyStarted);
    }

    private void copy() {
        this.copyStarted.countDown();
        try {
            try {
                this.copyStrategy.copy(this.source, this.sink);
            }
            catch (IOException e) {
                this.ioExceptionHandler.accept(e);
            }
            finally {
                this.closeStreams();
            }
        }
        catch (RuntimeException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause(e)).log();
        }
        finally {
            this.copyTerminated.countDown();
        }
    }

    void await() throws InterruptedException {
        this.copyTerminated.await();
    }

    void stop() throws InterruptedException {
        this.copyFuture.cancel(true);
        this.closeStreams();
        this.await();
    }

    private void closeStreams() {
        try {
            try {
                this.source.close();
            }
            finally {
                this.sink.close();
            }
        }
        catch (IOException e) {
            this.ioExceptionHandler.accept(e);
        }
    }

    @VisibleForTesting
    static interface CopyStrategy {
        public void copy(InputStream var1, OutputStream var2) throws IOException;
    }
}

