/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite.subplan;

import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.infra.ats.console.result.proto.ReportProto;
import com.google.devtools.mobileharness.platform.android.xts.suite.SuiteTestFilter;
import com.google.devtools.mobileharness.platform.android.xts.suite.retry.RetryResultHelper;
import com.google.devtools.mobileharness.platform.android.xts.suite.subplan.SubPlan;
import java.util.Optional;
import java.util.Set;

public class SubPlanHelper {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    public static SubPlan createSubPlanForPreviousResult(ReportProto.Result previousResult, Set<String> types, boolean addSubPlanCmd, ImmutableSet<SuiteTestFilter> prevResultIncludeFilters, ImmutableSet<SuiteTestFilter> prevResultExcludeFilters, ImmutableSet<String> passedInModules) {
        SubPlan subPlan = new SubPlan();
        for (ReportProto.Module module : previousResult.getModuleInfoList()) {
            boolean isNonTfModule = module.getIsNonTfModule();
            SubPlanHelper.addIncludeFilter(subPlan, String.format("%s %s", module.getAbi(), module.getName()), isNonTfModule);
            if (!previousResult.getTestFilter().isEmpty()) {
                SubPlanHelper.addIncludeFilter(subPlan, String.format("%s %s %s", module.getAbi(), module.getName(), previousResult.getTestFilter()), isNonTfModule);
            }
            if (RetryResultHelper.shouldRunModule(module, types, addSubPlanCmd, passedInModules)) {
                if (types.contains("not_executed") && !module.getDone()) {
                    ((FluentLogger.Api)logger.atInfo()).log("Module [%s %s] was not done in previous run", (Object)module.getAbi(), (Object)module.getName());
                    if (!prevResultIncludeFilters.isEmpty()) {
                        prevResultIncludeFilters.stream().filter(filter -> filter.matchModule(module.getName(), module.getAbi(), null)).forEach(prevResultIncludeFilter -> SubPlanHelper.addIncludeFilter(subPlan, prevResultIncludeFilter.filterString(), isNonTfModule));
                    }
                    if (!prevResultExcludeFilters.isEmpty()) {
                        prevResultExcludeFilters.stream().filter(filter -> filter.matchModule(module.getName(), module.getAbi(), null)).forEach(prevResultExcludeFilter -> SubPlanHelper.addExcludeFilter(subPlan, prevResultExcludeFilter.filterString(), isNonTfModule));
                    }
                    for (ReportProto.TestCase testCase : module.getTestCaseList()) {
                        for (ReportProto.Test test : testCase.getTestList()) {
                            if (RetryResultHelper.shouldRunTest(test, types, addSubPlanCmd)) continue;
                            SubPlanHelper.addExcludeFilter(subPlan, String.format("%s %s %s#%s", module.getAbi(), module.getName(), testCase.getName(), test.getName()), isNonTfModule);
                        }
                    }
                    continue;
                }
                if (RetryResultHelper.shouldRunEntireModule(module, types, addSubPlanCmd, prevResultIncludeFilters, prevResultExcludeFilters)) continue;
                for (ReportProto.TestCase testCase : module.getTestCaseList()) {
                    for (ReportProto.Test test : testCase.getTestList()) {
                        if (!RetryResultHelper.shouldRunTest(test, types, addSubPlanCmd)) continue;
                        SubPlanHelper.addIncludeFilter(subPlan, String.format("%s %s %s#%s", module.getAbi(), module.getName(), testCase.getName(), test.getName()), isNonTfModule);
                    }
                }
                continue;
            }
            SubPlanHelper.addExcludeFilter(subPlan, String.format("%s %s", module.getAbi(), module.getName()), isNonTfModule);
        }
        Optional<ReportProto.Attribute> commandLineArgs = previousResult.getAttributeList().stream().filter(attribute -> attribute.getKey().equals("command_line_args")).findFirst();
        commandLineArgs.ifPresent(args -> subPlan.setPreviousSessionXtsTestPlan(Splitter.on(' ').trimResults().omitEmptyStrings().splitToStream(args.getValue()).findFirst().orElse("")));
        if (previousResult.hasBuild()) {
            subPlan.setPreviousSessionDeviceBuildFingerprint(previousResult.getBuild().getBuildFingerprint());
            if (!previousResult.getBuild().getBuildFingerprintUnaltered().isEmpty()) {
                subPlan.setPreviousSessionDeviceBuildFingerprintUnaltered(previousResult.getBuild().getBuildFingerprintUnaltered());
            }
            subPlan.setPreviousSessionDeviceVendorBuildFingerprint(previousResult.getBuild().getBuildVendorFingerprint());
        }
        return subPlan;
    }

    private static void addIncludeFilter(SubPlan subPlan, String filter, boolean isNonTfModule) {
        if (isNonTfModule) {
            subPlan.addNonTfIncludeFilter(filter);
        } else {
            subPlan.addIncludeFilter(filter);
        }
    }

    private static void addExcludeFilter(SubPlan subPlan, String filter, boolean isNonTfModule) {
        if (isNonTfModule) {
            subPlan.addNonTfExcludeFilter(filter);
        } else {
            subPlan.addExcludeFilter(filter);
        }
    }

    public static void addPassedInFiltersToSubPlan(SubPlan subPlan, ImmutableSet<SuiteTestFilter> passedInIncludeFilters, ImmutableSet<SuiteTestFilter> passedInExcludeFilters, ImmutableSet<String> allNonTfModules) {
        for (SuiteTestFilter filter : passedInIncludeFilters) {
            if (allNonTfModules.stream().map(Ascii::toLowerCase).anyMatch(Ascii.toLowerCase(filter.moduleName())::contains)) {
                subPlan.addNonTfIncludeFilter(filter.filterString());
                continue;
            }
            subPlan.addIncludeFilter(filter.filterString());
        }
        for (SuiteTestFilter filter : passedInExcludeFilters) {
            if (allNonTfModules.stream().map(Ascii::toLowerCase).anyMatch(Ascii.toLowerCase(filter.moduleName())::contains)) {
                subPlan.addNonTfExcludeFilter(filter.filterString());
                continue;
            }
            subPlan.addExcludeFilter(filter.filterString());
        }
    }

    private SubPlanHelper() {
    }
}

