/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite.params;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.FoldableExpandingHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.IModuleParameterHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.InstantAppHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.ModuleParameters;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.NegativeHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.NotMultiAbiHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.RunOnSdkSandboxHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.SecondaryUserHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.SecondaryUserOnDefaultDisplayHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.SecondaryUserOnSecondaryDisplayHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.multiuser.RunOnCloneProfileParameterHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.multiuser.RunOnPrivateProfileParameterHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.multiuser.RunOnSecondaryUserParameterHandler;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.multiuser.RunOnWorkProfileParameterHandler;
import java.util.LinkedHashMap;
import java.util.Set;

public final class ModuleParametersHelper {
    private static final ImmutableMap<ModuleParameters, IModuleParameterHandler> HANDLER_MAP = ImmutableMap.of(ModuleParameters.INSTANT_APP, new InstantAppHandler(), ModuleParameters.NOT_INSTANT_APP, new NegativeHandler(), ModuleParameters.MULTI_ABI, new NegativeHandler(), ModuleParameters.NOT_MULTI_ABI, new NotMultiAbiHandler(), ModuleParameters.RUN_ON_WORK_PROFILE, new RunOnWorkProfileParameterHandler(), ModuleParameters.RUN_ON_SECONDARY_USER, new RunOnSecondaryUserParameterHandler(), ModuleParameters.NO_FOLDABLE_STATES, new NegativeHandler(), ModuleParameters.ALL_FOLDABLE_STATES, new FoldableExpandingHandler(), ModuleParameters.RUN_ON_CLONE_PROFILE, new RunOnCloneProfileParameterHandler(), ModuleParameters.RUN_ON_PRIVATE_PROFILE, new RunOnPrivateProfileParameterHandler());
    private static final ImmutableMap<ModuleParameters, ImmutableSet<ModuleParameters>> GROUP_MAP = ImmutableMap.of(ModuleParameters.MULTIUSER, ImmutableSet.of(ModuleParameters.RUN_ON_CLONE_PROFILE, ModuleParameters.RUN_ON_SECONDARY_USER, ModuleParameters.RUN_ON_WORK_PROFILE, ModuleParameters.RUN_ON_PRIVATE_PROFILE));
    private static final ImmutableMap<ModuleParameters, IModuleParameterHandler> OPTIONAL_HANDLER_MAP = ImmutableMap.of(ModuleParameters.SECONDARY_USER, new SecondaryUserHandler(), ModuleParameters.NOT_SECONDARY_USER, new NegativeHandler(), ModuleParameters.SECONDARY_USER_ON_SECONDARY_DISPLAY, new SecondaryUserOnSecondaryDisplayHandler(), ModuleParameters.NOT_SECONDARY_USER_ON_SECONDARY_DISPLAY, new NegativeHandler(), ModuleParameters.SECONDARY_USER_ON_DEFAULT_DISPLAY, new SecondaryUserOnDefaultDisplayHandler(), ModuleParameters.NOT_SECONDARY_USER_ON_DEFAULT_DISPLAY, new NegativeHandler(), ModuleParameters.RUN_ON_SDK_SANDBOX, new RunOnSdkSandboxHandler(), ModuleParameters.NOT_RUN_ON_SDK_SANDBOX, new NegativeHandler());
    private static final ImmutableMap<ModuleParameters, Set<ModuleParameters>> OPTIONAL_GROUP_MAP = ImmutableMap.of();

    public static ImmutableMap<ModuleParameters, IModuleParameterHandler> resolveParam(ModuleParameters param, boolean withOptional) {
        Set<ModuleParameters> mappedParams = (Set<ModuleParameters>)GROUP_MAP.get((Object)param);
        if (mappedParams == null && withOptional) {
            mappedParams = OPTIONAL_GROUP_MAP.get((Object)param);
        }
        if (mappedParams == null) {
            IModuleParameterHandler handler = ModuleParametersHelper.getParameterHandler(param, withOptional);
            if (handler == null) {
                return ImmutableMap.of();
            }
            return ImmutableMap.of(param, ModuleParametersHelper.getParameterHandler(param, withOptional));
        }
        LinkedHashMap<ModuleParameters, IModuleParameterHandler> resolvedParams = new LinkedHashMap<ModuleParameters, IModuleParameterHandler>();
        for (ModuleParameters moduleParameters : mappedParams) {
            resolvedParams.put(moduleParameters, HANDLER_MAP.get((Object)moduleParameters));
        }
        return ImmutableMap.copyOf(resolvedParams);
    }

    private static IModuleParameterHandler getParameterHandler(ModuleParameters param, boolean withOptional) {
        IModuleParameterHandler value = HANDLER_MAP.get((Object)param);
        if (value == null && withOptional) {
            return OPTIONAL_HANDLER_MAP.get((Object)param);
        }
        return value;
    }

    private ModuleParametersHelper() {
    }
}

