/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.ExtErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessExceptionFactory;
import com.google.devtools.mobileharness.platform.android.xts.common.util.AbiFormatter;
import com.google.devtools.mobileharness.platform.android.xts.common.util.AbiUtil;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import com.google.devtools.mobileharness.platform.android.xts.config.proto.ConfigurationProto;
import com.google.devtools.mobileharness.platform.android.xts.suite.Abi;
import com.google.devtools.mobileharness.platform.android.xts.suite.AutoValue_TestSuiteHelper_DeviceInfo;
import com.google.devtools.mobileharness.platform.android.xts.suite.SuiteModuleLoader;
import com.google.devtools.mobileharness.platform.android.xts.suite.TestSuiteInfoProvider;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.ModuleParameters;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class TestSuiteHelper {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final ImmutableList<String> CONFIG_FILE_EXTENSIONS = ImmutableList.of(".config", ".configv2");
    private final Set<Abi> abisSet = new LinkedHashSet<Abi>();
    private ModuleParameters forcedModuleParameter = null;
    private boolean allowParameterizedModules = false;
    private boolean allowOptionalParameterizedModules = false;
    private final String xtsRootDir;
    private final String xtsType;
    private final LocalFileUtil localFileUtil;

    public TestSuiteHelper(String xtsRootDir, String xtsType) {
        this(xtsRootDir, xtsType, new LocalFileUtil());
    }

    @VisibleForTesting
    TestSuiteHelper(String xtsRootDir, String xtsType, LocalFileUtil localFileUtil) {
        this.xtsRootDir = xtsRootDir;
        this.xtsType = xtsType;
        this.localFileUtil = localFileUtil;
    }

    public void setAbis(Set<Abi> abis) {
        this.abisSet.addAll(abis);
    }

    public void setModuleParameter(ModuleParameters param) {
        this.forcedModuleParameter = param;
    }

    public void setParameterizedModules(boolean allowed) {
        this.allowParameterizedModules = allowed;
    }

    public void setOptionalParameterizedModules(boolean allowed) {
        this.allowOptionalParameterizedModules = allowed;
    }

    public Map<String, ConfigurationProto.Configuration> loadTests(@Nullable DeviceInfo deviceInfo) throws MobileHarnessException, InterruptedException {
        File testsDir = this.getTestsDir();
        Set<Abi> abis = this.getAbis(deviceInfo);
        ((FluentLogger.Api)logger.atInfo()).log("The set of abis running against: %s", abis);
        SuiteModuleLoader suiteModuleLoader = this.createModuleLoader();
        suiteModuleLoader.setParameterizedModules(this.allowParameterizedModules);
        suiteModuleLoader.setOptionalParameterizedModules(this.allowOptionalParameterizedModules);
        suiteModuleLoader.setModuleParameter(this.forcedModuleParameter);
        return this.loadingStrategy(suiteModuleLoader, abis, ImmutableList.of(testsDir));
    }

    public Map<String, ConfigurationProto.Configuration> loadTestsUsingAbisForArchFromSuite() throws MobileHarnessException, InterruptedException {
        this.setAbis(this.getAbisForBuildTargetArchFromSuite().stream().filter(AbiUtil::isAbiSupportedByCompatibility).map(abi -> Abi.of(abi, AbiUtil.getBitness(abi))).collect(ImmutableSet.toImmutableSet()));
        return this.loadTests(null);
    }

    @VisibleForTesting
    Set<Abi> getAbis(@Nullable DeviceInfo deviceInfo) throws MobileHarnessException, InterruptedException {
        if (!this.abisSet.isEmpty()) {
            ((FluentLogger.Api)logger.atInfo()).log("Using the provided abis: %s", this.abisSet);
            return this.abisSet;
        }
        Set<String> archAbis = this.getAbisForBuildTargetArchFromSuite();
        LinkedHashSet<Abi> abis = new LinkedHashSet<Abi>();
        ImmutableSet<String> deviceAbis = this.getDeviceAbis(deviceInfo);
        if (deviceAbis.isEmpty()) {
            throw new MobileHarnessException(ExtErrorId.TEST_SUITE_DEVICE_ABIS_MISSING, String.format("Couldn't determinate the abi of the device '%s'.", deviceInfo == null ? "UNKNOWN" : deviceInfo.deviceId()));
        }
        for (String abi : deviceAbis) {
            if (archAbis.contains(abi) && AbiUtil.isAbiSupportedByCompatibility(abi)) {
                abis.add(Abi.of(abi, AbiUtil.getBitness(abi)));
                continue;
            }
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("abi '%s' is supported by device but not by this suite build (%s), tests will not run against it.", (Object)abi, archAbis);
        }
        if (abis.isEmpty()) {
            throw MobileHarnessExceptionFactory.createUserFacingException(ExtErrorId.TEST_SUITE_NO_ABIS_SUPPORTED, String.format("None of the abi supported by this tests suite build ('%s') are supported by the device ('%s').", archAbis, deviceAbis), null);
        }
        return abis;
    }

    private ImmutableSet<String> getDeviceAbis(@Nullable DeviceInfo deviceInfo) throws MobileHarnessException, InterruptedException {
        if (deviceInfo == null) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("No device info provided, using host abis.");
            return ImmutableSet.copyOf(this.getHostAbis());
        }
        return ImmutableSet.copyOf(AbiFormatter.getSupportedAbis(deviceInfo.supportedAbiList().orElse(null), deviceInfo.supportedAbi().orElse(null)));
    }

    @VisibleForTesting
    Set<String> getHostAbis() throws MobileHarnessException, InterruptedException {
        return AbiUtil.getHostAbi();
    }

    private Map<String, ConfigurationProto.Configuration> loadingStrategy(SuiteModuleLoader suiteModuleLoader, Set<Abi> abis, List<File> testsDirs) throws MobileHarnessException {
        LinkedHashMap<String, ConfigurationProto.Configuration> loadedConfigs = new LinkedHashMap<String, ConfigurationProto.Configuration>();
        loadedConfigs.putAll(suiteModuleLoader.loadConfigsFromDirectory(testsDirs, abis, CONFIG_FILE_EXTENSIONS));
        return loadedConfigs;
    }

    private File getTestsDir() throws MobileHarnessException {
        if (!this.localFileUtil.isDirExist(this.xtsRootDir)) {
            throw new MobileHarnessException(ExtErrorId.TEST_SUITE_ROOT_DIR_NOT_EXIST, "Test suite root dir does not exist.");
        }
        return XtsDirUtil.getXtsTestCasesDir(Path.of(this.xtsRootDir, new String[0]), this.xtsType).toFile();
    }

    public Set<String> getAbisForBuildTargetArchFromSuite() {
        LinkedHashSet<String> abis = new LinkedHashSet<String>();
        for (String arch : TestSuiteInfoProvider.getTestSuiteInfo(this.xtsRootDir, this.xtsType).getTargetArchs()) {
            abis.addAll(AbiUtil.getAbisForArch(arch));
        }
        return abis;
    }

    private SuiteModuleLoader createModuleLoader() {
        return new SuiteModuleLoader();
    }

    @AutoValue
    public static abstract class DeviceInfo {
        public abstract String deviceId();

        public abstract Optional<String> supportedAbiList();

        public abstract Optional<String> supportedAbi();

        public static Builder builder() {
            return new AutoValue_TestSuiteHelper_DeviceInfo.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setDeviceId(String var1);

            public abstract Builder setSupportedAbiList(String var1);

            public abstract Builder setSupportedAbi(String var1);

            public abstract DeviceInfo build();
        }
    }
}

