/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.io.Files;
import com.google.devtools.mobileharness.api.model.error.InfraErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.platform.android.xts.config.ConfigCommon;
import com.google.devtools.mobileharness.platform.android.xts.config.proto.ConfigurationProto;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ConfigurationXmlParser {
    private static final String DESCRIPTION = "description";
    private static final String OPTION = "option";
    private static final String NAME = "name";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String DEVICE = "device";
    private static final String TEST = "test";
    private static final String CLASS = "class";
    private static final String TARGET_PREPARER = "target_preparer";
    private static final String CONFIG_DESCRIPTOR_METADATA_OPTION_NAME = "config-descriptor:metadata";

    public static ConfigurationProto.Configuration parse(File xmlFile) throws MobileHarnessException {
        Document document;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(xmlFile);
        }
        catch (IOException e2) {
            throw new MobileHarnessException(InfraErrorId.XTS_CONFIG_XML_PARSE_ERROR, String.format("Failed to open configuration xml file: %s", xmlFile), e2);
        }
        ConfigurationProto.Configuration.Builder configuration = ConfigurationProto.Configuration.newBuilder();
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(fileInputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e3) {
            throw new MobileHarnessException(InfraErrorId.XTS_CONFIG_XML_PARSE_ERROR, "Failed to parse configuration xml file", e3);
        }
        Element root = document.getDocumentElement();
        String fileName = xmlFile.getName();
        String fileNameWithoutExtension = Files.getNameWithoutExtension(fileName);
        configuration.setMetadata(ConfigurationProto.ConfigurationMetadata.newBuilder().setXtsModule(fileNameWithoutExtension).setIsConfigV2(ConfigCommon.CONFIG_V2_FILE_EXTENSIONS.stream().anyMatch(fileName::endsWith)));
        configuration.setDescription(root.getAttribute(DESCRIPTION));
        LinkedListMultimap<String, String> configDescriptorMetadata = LinkedListMultimap.create();
        block14: for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            switch (node.getNodeName()) {
                case "option": {
                    ConfigurationProto.Option option = ConfigurationXmlParser.parseOption(node);
                    if (option.getName().equals(CONFIG_DESCRIPTOR_METADATA_OPTION_NAME)) {
                        configDescriptorMetadata.put(option.getKey(), option.getValue());
                        continue block14;
                    }
                    configuration.addOptions(option);
                    continue block14;
                }
                case "device": {
                    configuration.addDevices(ConfigurationXmlParser.parseDevice(node));
                    continue block14;
                }
                case "test": {
                    configuration.setTest(ConfigurationXmlParser.parseTest(node));
                    continue block14;
                }
            }
        }
        configuration.setConfigDescriptor(ConfigurationProto.ConfigurationDescriptor.newBuilder().putAllMetadata((Map<String, ConfigurationProto.ConfigurationDescriptorMetadata>)configDescriptorMetadata.asMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ConfigurationProto.ConfigurationDescriptorMetadata.newBuilder().setKey((String)e.getKey()).addAllValue((Iterable)e.getValue()).build()))));
        return configuration.build();
    }

    private static ConfigurationProto.Option parseOption(Node root) {
        ConfigurationProto.Option.Builder option = ConfigurationProto.Option.newBuilder();
        block10: for (int i = 0; i < root.getAttributes().getLength(); ++i) {
            Node attribute = root.getAttributes().item(i);
            switch (attribute.getNodeName()) {
                case "name": {
                    option.setName(attribute.getNodeValue());
                    continue block10;
                }
                case "key": {
                    option.setKey(attribute.getNodeValue());
                    continue block10;
                }
                case "value": {
                    option.setValue(attribute.getNodeValue());
                    continue block10;
                }
            }
        }
        return option.build();
    }

    private static ConfigurationProto.Test parseTest(Node root) {
        ConfigurationProto.Test.Builder test = ConfigurationProto.Test.newBuilder();
        test.setClazz(((Element)root).getAttribute(CLASS));
        block6: for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            switch (node.getNodeName()) {
                case "option": {
                    test.addOptions(ConfigurationXmlParser.parseOption(node));
                    continue block6;
                }
            }
        }
        return test.build();
    }

    private static ConfigurationProto.TargetPreparer parseTargetPreparer(Node root) {
        ConfigurationProto.TargetPreparer.Builder targetPreparer = ConfigurationProto.TargetPreparer.newBuilder();
        targetPreparer.setClazz(((Element)root).getAttribute(CLASS));
        block6: for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            switch (node.getNodeName()) {
                case "option": {
                    targetPreparer.addOptions(ConfigurationXmlParser.parseOption(node));
                    continue block6;
                }
            }
        }
        return targetPreparer.build();
    }

    private static ConfigurationProto.Device parseDevice(Node root) {
        ConfigurationProto.Device.Builder device = ConfigurationProto.Device.newBuilder();
        device.setName(((Element)root).getAttribute(NAME));
        block8: for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            switch (node.getNodeName()) {
                case "target_preparer": {
                    device.addTargetPreparers(ConfigurationXmlParser.parseTargetPreparer(node));
                    continue block8;
                }
                case "option": {
                    device.addOptions(ConfigurationXmlParser.parseOption(node));
                    continue block8;
                }
            }
        }
        return device.build();
    }
}

