/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.command;

import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.console.command.RunCommand;
import com.google.devtools.mobileharness.infra.ats.console.controller.olcserver.AtsSessionStub;
import com.google.devtools.mobileharness.infra.ats.console.controller.proto.SessionPluginProto;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.console.InterruptibleLineReader;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.concurrent.Callables;
import com.google.devtools.mobileharness.shared.util.concurrent.MoreFutures;
import com.google.devtools.mobileharness.shared.util.error.MoreThrowables;
import com.google.devtools.mobileharness.shared.util.time.Sleeper;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class ExitUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final Duration SHORT_SLEEP_INTERVAL = Duration.ofSeconds(3L);
    private static final Duration LONG_SLEEP_INTERVAL = Duration.ofSeconds(30L);
    private final AtsSessionStub atsSessionStub;
    private final ConsoleUtil consoleUtil;
    private final Sleeper sleeper;
    private final ListeningExecutorService threadPool;
    private final InterruptibleLineReader interruptibleLineReader;

    @Inject
    ExitUtil(AtsSessionStub atsSessionStub, ConsoleUtil consoleUtil, Sleeper sleeper, ListeningExecutorService threadPool, InterruptibleLineReader interruptibleLineReader) {
        this.atsSessionStub = atsSessionStub;
        this.consoleUtil = consoleUtil;
        this.sleeper = sleeper;
        this.threadPool = threadPool;
        this.interruptibleLineReader = interruptibleLineReader;
    }

    public void cancelUnfinishedSessions(String reason, boolean aggressive) {
        try {
            this.atsSessionStub.cancelUnfinishedNotAbortedSessions(true, SessionPluginProto.AtsSessionPluginNotification.newBuilder().setSessionCancellation(SessionPluginProto.AtsSessionCancellation.newBuilder().setReason(reason).setAggressive(aggressive)).build());
        }
        catch (MobileHarnessException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to cancel unfinished sessions with error. Error=[%s]", MoreThrowables.shortDebugString(e));
        }
    }

    public ListenableFuture<?> waitUntilNoRunningSessionsAndInterruptLineReader() {
        return MoreFutures.logFailure(this.threadPool.submit(Callables.threadRenaming(() -> {
            this.consoleUtil.printlnStdout("Will exit the console after all commands have executed.");
            try {
                int runningRunCommandCount;
                int sleepCount = 0;
                do {
                    if ((runningRunCommandCount = RunCommand.getRunningRunCommandCount()) <= 0) continue;
                    ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).atMostEvery(1, TimeUnit.MINUTES)).log("Still need to wait as %s RunCommands are still running.", runningRunCommandCount);
                    this.sleeper.sleep(sleepCount < 10 ? SHORT_SLEEP_INTERVAL : LONG_SLEEP_INTERVAL);
                    ++sleepCount;
                } while (runningRunCommandCount > 0);
                this.consoleUtil.printlnStdout("No running sessions. Exit the console now.");
            }
            catch (InterruptedException e) {
                this.consoleUtil.printlnStderr("Interrupted while waiting until no running sessions. Going to exit the console directly.");
                Thread.currentThread().interrupt();
            }
            finally {
                this.interruptibleLineReader.interrupt();
            }
        }, () -> "wait-until-no-running-session")), Level.WARNING, "Error when waiting until no running sessions", new Object[0]);
    }
}

