/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command.preprocessor;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.console.command.alias.AliasManager;
import com.google.devtools.mobileharness.infra.ats.console.command.preprocessor.AutoValue_CommandPreprocessor_PreprocessingResult;
import com.google.devtools.mobileharness.infra.ats.console.command.preprocessor.CommandFileParser;
import com.google.devtools.mobileharness.shared.util.error.MoreThrowables;
import com.google.devtools.mobileharness.shared.util.shell.ShellUtils;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class CommandPreprocessor {
    private static final ImmutableList<String> EXIT_COMMAND = ImmutableList.of("exit", "-c", "-s");
    private final CommandFileParser commandFileParser;
    private final AliasManager aliasManager;

    @Inject
    CommandPreprocessor(CommandFileParser commandFileParser, AliasManager aliasManager) {
        this.commandFileParser = commandFileParser;
        this.aliasManager = aliasManager;
    }

    public PreprocessingResult preprocess(ImmutableList<String> tokens) {
        if (tokens.size() < 2) {
            return PreprocessingResult.of(null, null, false);
        }
        if (!Ascii.equalsIgnoreCase((CharSequence)tokens.get(0), "run")) {
            return PreprocessingResult.of(null, null, false);
        }
        PreprocessingResult aliasResolutionResult = this.resolveAlias(tokens);
        if (aliasResolutionResult.errorMessage().isPresent()) {
            return aliasResolutionResult;
        }
        Optional<ImmutableList<ImmutableList<String>>> modifiedCommands = aliasResolutionResult.modifiedCommands();
        if (modifiedCommands.isPresent()) {
            tokens = (ImmutableList)modifiedCommands.get().get(0);
        }
        return switch ((String)tokens.get(1)) {
            case "command" -> CommandPreprocessor.preprocessRunCommandCommand(tokens, false);
            case "cmdfile" -> this.preprocessRunCmdfileCommand(tokens, false);
            case "commandAndExit" -> CommandPreprocessor.preprocessRunCommandCommand(tokens, true);
            case "cmdfileAndExit" -> this.preprocessRunCmdfileCommand(tokens, true);
            default -> aliasResolutionResult;
        };
    }

    private PreprocessingResult resolveAlias(ImmutableList<String> tokens) {
        boolean aliasFound = false;
        ImmutableList.Builder newTokens = ImmutableList.builder();
        for (String token : tokens) {
            ImmutableList<String> aliasTokens;
            Optional<String> alias = this.aliasManager.getAlias(token);
            if (alias.isEmpty()) {
                newTokens.add(token);
                continue;
            }
            aliasFound = true;
            try {
                aliasTokens = ShellUtils.tokenize(alias.get());
            }
            catch (ShellUtils.TokenizationException e) {
                return PreprocessingResult.of(null, String.format("Failed to tokenize alias '%s': %s.", alias.get(), e.getMessage()), false);
            }
            newTokens.addAll(aliasTokens);
        }
        return aliasFound ? PreprocessingResult.of(ImmutableList.of(newTokens.build()), null, false) : PreprocessingResult.of(null, null, false);
    }

    private static PreprocessingResult preprocessRunCommandCommand(ImmutableList<String> tokens, boolean exitAfterRun) {
        ImmutableCollection.Builder modifiedTokens = ((ImmutableList.Builder)ImmutableList.builder().add((String)tokens.get(0))).addAll((Iterable)tokens.subList(2, tokens.size()));
        ImmutableList.Builder commandsBuilder = ImmutableList.builder();
        commandsBuilder.add(((ImmutableList.Builder)modifiedTokens).build());
        if (exitAfterRun) {
            commandsBuilder.add(EXIT_COMMAND);
        }
        return PreprocessingResult.of((ImmutableList<ImmutableList<String>>)commandsBuilder.build(), null, false);
    }

    private PreprocessingResult preprocessRunCmdfileCommand(ImmutableList<String> tokens, boolean exitAfterRun) {
        List<CommandFileParser.CommandLine> commandsFromFile;
        if (tokens.size() < 3) {
            return PreprocessingResult.of(null, "Cmdfile path is not specified", true);
        }
        ImmutableList.Builder commandsBuilder = ImmutableList.builder();
        try {
            commandsFromFile = this.commandFileParser.parseFile(new File((String)tokens.get(2)));
        }
        catch (MobileHarnessException e) {
            return PreprocessingResult.of(null, String.format("Failed to read cmdfile: %s", MoreThrowables.shortDebugString(e)), true);
        }
        String firstToken = (String)tokens.get(0);
        List extraArgs = tokens.subList(3, tokens.size());
        commandsBuilder.addAll((Iterable)commandsFromFile.stream().map(arg_0 -> CommandPreprocessor.lambda$preprocessRunCmdfileCommand$0(firstToken, (ImmutableList)extraArgs, arg_0)).collect(ImmutableList.toImmutableList()));
        if (exitAfterRun) {
            commandsBuilder.add(EXIT_COMMAND);
        }
        return PreprocessingResult.of((ImmutableList<ImmutableList<String>>)commandsBuilder.build(), null, true);
    }

    private static /* synthetic */ ImmutableList lambda$preprocessRunCmdfileCommand$0(String firstToken, ImmutableList extraArgs, CommandFileParser.CommandLine command) {
        ImmutableCollection.Builder modifiedTokens = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(firstToken)).addAll((Iterable)command)).addAll((Iterable)extraArgs);
        return ((ImmutableList.Builder)modifiedTokens).build();
    }

    @AutoValue
    public static abstract class PreprocessingResult {
        public abstract Optional<ImmutableList<ImmutableList<String>>> modifiedCommands();

        public abstract Optional<String> errorMessage();

        public abstract boolean isFromCommandFile();

        public static PreprocessingResult of(@Nullable ImmutableList<ImmutableList<String>> modifiedCommands, @Nullable String errorMessage, boolean isFromCommandFile) {
            return new AutoValue_CommandPreprocessor_PreprocessingResult(Optional.ofNullable(modifiedCommands), Optional.ofNullable(errorMessage), isFromCommandFile);
        }
    }
}

