/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.SessionRequestInfo;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerPreparer;
import com.google.devtools.mobileharness.infra.ats.console.Annotations;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.command.picocli.parameterpreprocessor.MapPreprocessor;
import com.google.devtools.mobileharness.infra.ats.console.command.picocli.parameterpreprocessor.MultimapPreprocessor;
import com.google.devtools.mobileharness.infra.ats.console.controller.olcserver.AtsSessionStub;
import com.google.devtools.mobileharness.infra.ats.console.controller.olcserver.ServerLogPrinter;
import com.google.devtools.mobileharness.infra.ats.console.controller.proto.SessionPluginProto;
import com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.PluginOutputPrinter;
import com.google.devtools.mobileharness.infra.ats.console.result.report.CertificationSuiteInfoFactory;
import com.google.devtools.mobileharness.infra.ats.console.util.command.CommandHelper;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.result.ResultListerHelper;
import com.google.devtools.mobileharness.infra.ats.console.util.subplan.SubPlanLister;
import com.google.devtools.mobileharness.platform.android.shared.constant.Splitters;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsCommandUtil;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import com.google.devtools.mobileharness.platform.android.xts.suite.ModuleArg;
import com.google.devtools.mobileharness.platform.android.xts.suite.retry.RetryType;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.command.Command;
import com.google.devtools.mobileharness.shared.util.command.CommandException;
import com.google.devtools.mobileharness.shared.util.command.CommandExecutor;
import com.google.devtools.mobileharness.shared.util.command.Timeout;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import com.google.devtools.mobileharness.shared.util.time.TimeUtils;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="run", aliases={"r"}, sortOptions=false, description={"Run xTS tests."}, footer={"%nAlternatively you can enter @|fg(yellow) <config>|@ right after \"run\" command which will achieve same result.%n"}, synopsisSubcommandLabel="", subcommands={CommandLine.HelpCommand.class})
public final class RunCommand
implements Callable<Integer> {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    @CommandLine.Parameters(index="0", arity="0..1", paramLabel="<config>", hideParamSyntax=true, description={"xTS test config/plan."})
    private String config;
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..*")
    private List<ModuleTestOptionsGroup> moduleTestOptionsGroups;
    @CommandLine.Option(names={"-s", "--serial"}, paramLabel="<device_id>", description={"Run test on the specific device."})
    private List<String> serialOpt;
    @CommandLine.Option(names={"--exclude-serial"}, paramLabel="<exclude_device_id>", description={"Run test on any device except those with this serial number(s)."})
    private List<String> excludeSerialOpt;
    @CommandLine.Option(names={"--product-type"}, paramLabel="<device_product_type>", description={"Run test on device with this product type(s). May also filter by variant using product:variant."})
    private List<String> productTypes;
    @CommandLine.Option(names={"--property"}, paramLabel="<device_property>", preprocessor=MapPreprocessor.class, description={"Run test on device with this property value. Expected format --property <propertyname> <propertyvalue>."})
    private Map<String, String> devicePropertiesMap;
    @CommandLine.Option(names={"--min-battery"}, paramLabel="<min_battery_level>", description={"only run this test on a device whose battery level is at least the given amount. Scale: 0-100"})
    private Integer minBattery = null;
    @CommandLine.Option(names={"--max-battery"}, paramLabel="<max_battery_level>", description={"only run this test on a device whose battery level is strictly less than the given amount. Scale: 0-100"})
    private Integer maxBattery = null;
    @CommandLine.Option(names={"--require-battery-check"}, arity="1", paramLabel="<require_battery_check>", description={"If --min-battery and/or --max-battery is specified, enforce the check. If require-battery-check=false, then no battery check will occur. This is TRUE by default."})
    private boolean requireBatteryCheck = true;
    @CommandLine.Option(names={"--max-battery-temperature"}, paramLabel="<max_battery_temperature>", description={"only run this test on a device whose battery temperature is strictly less than the given amount. Scale: Degrees celsius"})
    private Integer maxBatteryTemperature = null;
    @CommandLine.Option(names={"--require-battery-temp-check"}, arity="1", paramLabel="<require_battery_temp_check>", description={"If --max-battery-temperature is specified, enforce the battery checking. If require-battery-temp-check=false, then no temperature check will occur. This is TRUE by default."})
    private boolean requireBatteryTemperatureCheck = true;
    @CommandLine.Option(names={"--min-sdk-level"}, paramLabel="<min_sdk_level>", description={"Only run this test on devices that support this Android SDK/API level"})
    private Integer minSdk = null;
    @CommandLine.Option(names={"--max-sdk-level"}, paramLabel="<max_sdk_level>", description={"Only run this test on devices that support this Android SDK/API level"})
    private Integer maxSdk = null;
    @CommandLine.Option(names={"--shard-count"}, paramLabel="<number_of_shards>", description={"Shard a run into given number of independent chunks, to run on multiple devices in parallel."})
    private int shardCount;
    @CommandLine.Option(names={"--include-filter", "--compatibility:include-filter"}, paramLabel="\"[abi] <module_name> <test_name>\"", description={"Run with the specified modules, or test packages, classes, and cases. For example, run cts --include-filter \"CtsCalendarcommon2TestCases android.calendarcommon2.cts.Calendarcommon2Test#testStaticLinking\" includes the specified module."})
    private List<String> includeFilters;
    @CommandLine.Option(names={"--exclude-filter", "--compatibility:exclude-filter"}, paramLabel="\"[abi] <module_name> <test_name>\"", description={"Exclude the specified modules, or test packages, classes, and cases, from the run. For example, run cts --exclude-filter \"CtsCalendarcommon2Test android.calendarcommon2.cts.Calendarcommon2Test#testStaticLinking\" excludes the specified module."})
    private List<String> excludeFilters;
    @CommandLine.Option(names={"--module-metadata-include-filter", "--compatibility:module-metadata-include-filter"}, paramLabel="<key> <value>", preprocessor=MultimapPreprocessor.class, description={"Run modules with specific metadata in key-value pairs. For example, run cts --module-metadata-include-filter component gts-root includes modules with metadata key=component value=gts-root."})
    private Multimap<String, String> moduleMetadataIncludeFilters;
    @CommandLine.Option(names={"--module-metadata-exclude-filter", "--compatibility:module-metadata-exclude-filter"}, arity="2", paramLabel="<key> <value>", preprocessor=MultimapPreprocessor.class, description={"Exclude modules with specific metadata in key-value pairs. For example, run cts --module-metadata-exclude-filter component gts-root excludes modules with metadata key=component value=gts-root."})
    private Multimap<String, String> moduleMetadataExcludeFilters;
    @CommandLine.Option(names={"--html-in-zip"}, arity="0..1", paramLabel="<html_in_zip>", description={"Whether to include html reports in the result zip file. Default is false."})
    private boolean htmlInZip;
    @CommandLine.Option(names={"--report-system-checkers"}, arity="0..1", paramLabel="<report_system_checkers>", description={"Whether reporting system checkers as test or not. Default is false."})
    private boolean reportSystemCheckers = false;
    @CommandLine.Option(names={"-d", "--skip-device-info"}, arity="0..1", paramLabel="<skip_device_info>", description={"Whether device info collection should be skipped. Default is false."})
    private Boolean skipDeviceInfo = null;
    @CommandLine.Option(names={"--subplan"}, paramLabel="<subplan_name>", description={"Run the specified subplan."})
    private String subPlanName;
    @CommandLine.Option(names={"--help"}, paramLabel="<help>", description={"Show the help message."})
    private boolean showHelp;
    @CommandLine.Option(names={"--help-all"}, paramLabel="<help_all>", description={"Show the help all message."})
    private boolean showHelpAll;
    @CommandLine.Option(names={"--module-arg", "--compatibility:module-arg"}, paramLabel="\"<module_name>:<arg_name>:[<arg_key>:=]<arg_value>\"", description={"Arguments to pass to a module."})
    private List<String> moduleCmdArgs;
    @CommandLine.Parameters(index="1..*", hidden=true)
    private List<String> extraRunCmdArgs;
    @CommandLine.Option(names={"--retry"}, paramLabel="<retry_session_id>", description={"Index for the retry session. Use @|bold list results|@ to get the session index. Either this or <retry_session_result_dir_name> must be set when calling 'run retry' command"})
    private Integer retrySessionIndex;
    @CommandLine.Option(names={"--retry-result-dir"}, paramLabel="<retry_session_result_dir_name>", description={"Result directory name for the retry session. Use @|bold list results|@ to get the result directory name. Either this or <retry_session_id> must be set when calling 'run retry' command. Use this option instead of <retry_session_id> to retry specific sessions parallelly if needed"})
    private String retrySessionResultDirName;
    @CommandLine.Option(names={"--retry-type"}, description={"Test retry type for 'run retry' command. Supported values: ${COMPLETION-CANDIDATES}"})
    private RetryType retryType;
    @CommandLine.Option(names={"--exclude-runner"}, description={"Exclude tests by test runners."})
    private List<String> excludeRunnerOpt;
    @CommandLine.Option(names={"--enable-default-logs"}, arity="0..1", paramLabel="<enable_default_logs>", description={"Whether to enable default logs. Default is false."})
    private Boolean enableDefaultLogs = null;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
    private DeviceTypeOptionsGroup deviceTypeOptionsGroup;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    static final String RUN_COMMAND_SESSION_NAME = "run_command";
    private static final Pattern LINE_DATETIME_START_PATTERN = Pattern.compile("^\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d");
    private static final Duration CMDFILE_JOBS_START_TIMEOUT = Duration.ofDays(36500L);
    private static final AtomicInteger RUNNING_COMMAND_COUNT = new AtomicInteger(0);
    private final ConsoleInfo consoleInfo;
    private final ConsoleUtil consoleUtil;
    private final CommandHelper commandHelper;
    private final SubPlanLister subPlanLister;
    private final ResultListerHelper resultListerHelper;
    private final ServerPreparer serverPreparer;
    private final ServerLogPrinter serverLogPrinter;
    private final ListeningExecutorService executorService;
    private final AtsSessionStub atsSessionStub;
    private final Consumer<ListenableFuture<SessionRequestInfo.Builder>> resultFuture;
    private final boolean parseCommandOnly;
    private final CommandExecutor commandExecutor;

    @Inject
    RunCommand(ConsoleInfo consoleInfo, ConsoleUtil consoleUtil, CommandHelper commandHelper, SubPlanLister subPlanLister, ResultListerHelper resultListerHelper, ServerPreparer serverPreparer, ServerLogPrinter serverLogPrinter, ListeningExecutorService executorService, AtsSessionStub atsSessionStub, CommandExecutor commandExecutor, @Annotations.RunCommandParsingResultFuture Consumer<ListenableFuture<SessionRequestInfo.Builder>> resultFuture, @Annotations.ParseCommandOnly boolean parseCommandOnly) {
        this.consoleInfo = consoleInfo;
        this.consoleUtil = consoleUtil;
        this.commandHelper = commandHelper;
        this.subPlanLister = subPlanLister;
        this.resultListerHelper = resultListerHelper;
        this.serverPreparer = serverPreparer;
        this.serverLogPrinter = serverLogPrinter;
        this.executorService = executorService;
        this.atsSessionStub = atsSessionStub;
        this.commandExecutor = commandExecutor;
        this.resultFuture = resultFuture;
        this.parseCommandOnly = parseCommandOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Integer call() throws MobileHarnessException, InterruptedException {
        ImmutableList<String> command = this.consoleInfo.getLastCommand();
        try {
            if (this.parseCommandOnly) {
                try {
                    this.resultFuture.accept(Futures.immediateFuture(this.createParseResult()));
                    Integer n = 0;
                    return n;
                }
                catch (Error | RuntimeException e) {
                    this.resultFuture.accept(Futures.immediateFailedFuture(e));
                    Integer n = 1;
                    this.moduleTestOptionsGroups = null;
                    return n;
                }
            }
            Preconditions.checkState(Flags.instance().enableAtsConsoleOlcServer.getNonNull());
            if (this.showHelp || this.showHelpAll) {
                Integer n = this.showHelpMessage(this.commandHelper.getXtsType(), this.consoleInfo.getXtsRootDirectoryNonEmpty());
                return n;
            }
            this.validateCommandParameters();
            Integer n = this.runWithOlcServerPrepared(command);
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.moduleTestOptionsGroups = null;
        }
    }

    public static int getRunningRunCommandCount() {
        return RUNNING_COMMAND_COUNT.get();
    }

    private SessionRequestInfo.Builder createParseResult() throws MobileHarnessException {
        ImmutableSet<String> excludeRunners;
        SessionRequestInfo.Builder sessionRequestBuilder = SessionRequestInfo.builder();
        this.validateCommandParameters();
        sessionRequestBuilder.setTestPlan(this.config).setModuleNames(this.getModules()).setIncludeFilters(this.includeFilters == null ? ImmutableList.of() : ImmutableList.copyOf(this.includeFilters)).setExcludeFilters(this.excludeFilters == null ? ImmutableList.of() : ImmutableList.copyOf(this.excludeFilters)).setModuleMetadataIncludeFilters(this.moduleMetadataIncludeFilters == null ? ImmutableMultimap.of() : ImmutableMultimap.copyOf(this.moduleMetadataIncludeFilters)).setModuleMetadataExcludeFilters(this.moduleMetadataExcludeFilters == null ? ImmutableMultimap.of() : ImmutableMultimap.copyOf(this.moduleMetadataExcludeFilters)).setHtmlInZip(this.htmlInZip);
        if (this.shardCount > 0) {
            sessionRequestBuilder.setShardCount(this.shardCount);
        }
        if (!this.getTest().isEmpty()) {
            sessionRequestBuilder.setTestName(this.getTest());
        }
        ImmutableList<String> moduleArgs = this.moduleCmdArgs != null ? ImmutableList.copyOf(this.moduleCmdArgs) : ImmutableList.of();
        ImmutableList<String> extraArgs = this.extraRunCmdArgs != null ? ImmutableList.copyOf(this.extraRunCmdArgs) : ImmutableList.of();
        ImmutableSet<String> immutableSet = excludeRunners = this.excludeRunnerOpt != null ? ImmutableSet.copyOf(this.excludeRunnerOpt) : ImmutableSet.of();
        if (this.retryType != null) {
            sessionRequestBuilder.setRetryType(RetryType.valueOf(Ascii.toUpperCase(this.retryType.name())));
        }
        if (this.isSkipDeviceInfo().isPresent()) {
            sessionRequestBuilder.setSkipDeviceInfo(this.isSkipDeviceInfo().get());
        }
        if (this.enableDefaultLogs != null) {
            sessionRequestBuilder.setEnableDefaultLogs(this.enableDefaultLogs);
        }
        return sessionRequestBuilder.setModuleArgs(moduleArgs).setExtraArgs(extraArgs).setExcludeRunners(excludeRunners);
    }

    @VisibleForTesting
    void validateCommandParameters() throws MobileHarnessException {
        if (Strings.isNullOrEmpty(this.config)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string("Param @|fg(yellow) <config>|@ right after 'run' command is required.\n"));
        }
        if (this.moduleTestOptionsGroups != null && !this.moduleTestOptionsGroups.isEmpty()) {
            ImmutableList tests = this.moduleTestOptionsGroups.stream().map(group -> group.test).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
            if (tests.size() > 1) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string("Only at most one test case could be specified.\n"));
            }
            if (tests.size() == 1 && this.moduleTestOptionsGroups.size() > 1) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string("Multiple modules are unsupported if a test case is specified.\n"));
            }
        }
        if (this.includeFilters != null && !this.includeFilters.isEmpty() && this.moduleTestOptionsGroups != null && !this.moduleTestOptionsGroups.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string("Don't use '--include-filter' and '--module/-m' options at the same time.\n"));
        }
        if (this.config.equals("retry")) {
            this.validateRunRetryCommandParameters();
        }
        if (!Strings.isNullOrEmpty(this.subPlanName) && !this.isSubPlanExist(this.subPlanName)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string(String.format("Subplan [%s] doesn't exist.\n", this.subPlanName)));
        }
        if (this.moduleCmdArgs != null && !this.moduleCmdArgs.isEmpty()) {
            for (String moduleArg : this.moduleCmdArgs) {
                if (ModuleArg.isValid(moduleArg)) continue;
                throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string(String.format("Invalid module arguments provided. Unprocessed arguments: %s\nExpected format: <module_name>:<arg_name>:[<arg_key>:=]<arg_value>.\n", moduleArg)));
            }
        }
        this.validateRunCommandExtraArgs();
    }

    private void validateRunRetryCommandParameters() {
        if (this.retrySessionIndex == null && Strings.isNullOrEmpty(this.retrySessionResultDirName)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string("Must provide option '--retry <retry_session_id>' or '--retry-result-dir <retry_session_result_dir_name>' for retry command.\n"));
        }
        if (this.retrySessionIndex != null && !Strings.isNullOrEmpty(this.retrySessionResultDirName)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string("Option '--retry <retry_session_id>' and '--retry-result-dir <retry_session_result_dir_name>' are mutually exclusive.\n"));
        }
        if (!Strings.isNullOrEmpty(this.subPlanName)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string("Option '--subplan <subplan_name>' is not supported in retry command.\n"));
        }
        if (this.includeFilters != null && !this.includeFilters.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string("Option '--include-filter' is not supported in retry command.\n"));
        }
    }

    private void validateRunCommandExtraArgs() {
        if (this.extraRunCmdArgs != null && !this.extraRunCmdArgs.isEmpty() && !this.extraRunCmdArgs.get(0).startsWith("-")) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), CommandLine.Help.Ansi.AUTO.string(String.format("Invalid arguments provided. Unprocessed arguments: %s\nDouble check if the input is valid, for example, quoting the arg value if it contains space.\n", this.extraRunCmdArgs)));
        }
    }

    private boolean isSubPlanExist(String subPlanName) throws MobileHarnessException {
        Path xtsRootDir = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        return this.subPlanLister.listSubPlans(xtsRootDir.toString(), this.commandHelper.getXtsType()).contains(subPlanName);
    }

    private ImmutableList<String> getModules() {
        return this.moduleTestOptionsGroups != null ? this.moduleTestOptionsGroups.stream().map(group -> group.module).collect(ImmutableList.toImmutableList()) : ImmutableList.of();
    }

    private String getTest() {
        return this.moduleTestOptionsGroups != null && this.moduleTestOptionsGroups.get((int)0).test != null ? this.moduleTestOptionsGroups.get((int)0).test : "";
    }

    @VisibleForTesting
    int showHelpMessage(String xtsType, Path xtsRootDir) throws CommandException, InterruptedException {
        Path xtsToolsDir = XtsDirUtil.getXtsToolsDir(xtsRootDir, xtsType);
        String result = this.commandExecutor.run(Command.of(RunCommand.getXtsJavaCommand(xtsType, xtsRootDir, ImmutableList.of(), String.valueOf(xtsToolsDir.resolve("tradefed.jar")) + ":" + String.valueOf(xtsToolsDir.resolve(xtsType + "-tradefed.jar")), ImmutableList.of("run", "commandAndExit", this.config, this.showHelp ? "--help" : "--help-all"))).timeout(Timeout.fixed(Duration.ofSeconds(60L))));
        Iterable<String> lines = Splitters.LINE_SPLITTER.split(result);
        boolean printing = false;
        StringBuilder output = new StringBuilder();
        for (String line : lines) {
            if (LINE_DATETIME_START_PATTERN.matcher(line).find()) continue;
            if (printing) {
                if (line.endsWith("Received shutdown request.")) break;
                output.append(line).append("\n");
                continue;
            }
            if (line.startsWith("'" + this.config + "' configuration:")) {
                output.append(line).append("\n");
                printing = true;
                continue;
            }
            if (!line.startsWith("Failed to run command:")) continue;
            output.append(line).append("\n");
            break;
        }
        this.consoleUtil.printlnStdout(output.length() > 0 ? output.deleteCharAt(output.length() - 1).toString() : "");
        return 0;
    }

    private int runWithOlcServerPrepared(ImmutableList<String> command) throws InterruptedException, MobileHarnessException {
        this.serverPreparer.prepareOlcServer();
        return this.runWithCommand(command);
    }

    @VisibleForTesting
    int runWithCommand(ImmutableList<String> command) throws InterruptedException, MobileHarnessException {
        ImmutableList<String> deviceSerials = this.serialOpt != null ? ImmutableList.copyOf(this.serialOpt) : ImmutableList.of();
        ImmutableList<String> excludeSerials = this.excludeSerialOpt != null ? ImmutableList.copyOf(this.excludeSerialOpt) : ImmutableList.of();
        ImmutableList<String> productTypes = this.productTypes == null ? ImmutableList.of() : ImmutableList.copyOf(this.productTypes);
        ImmutableMap<String, String> devicePropertiesMap = this.devicePropertiesMap == null ? ImmutableMap.of() : ImmutableMap.copyOf(this.devicePropertiesMap);
        ImmutableList<String> modules = this.getModules();
        String test = this.getTest();
        ImmutableList<String> includeFilters = this.includeFilters == null ? ImmutableList.of() : ImmutableList.copyOf(this.includeFilters);
        ImmutableList<String> excludeFilters = this.excludeFilters == null ? ImmutableList.of() : ImmutableList.copyOf(this.excludeFilters);
        ImmutableMultimap<String, String> moduleMetadataIncludeFilters = this.moduleMetadataIncludeFilters == null ? ImmutableMultimap.of() : ImmutableMultimap.copyOf(this.moduleMetadataIncludeFilters);
        ImmutableMultimap<String, String> moduleMetadataExcludeFilters = this.moduleMetadataExcludeFilters == null ? ImmutableMultimap.of() : ImmutableMultimap.copyOf(this.moduleMetadataExcludeFilters);
        ImmutableList<String> moduleArgs = this.moduleCmdArgs != null ? ImmutableList.copyOf(this.moduleCmdArgs) : ImmutableList.of();
        ImmutableList<String> extraArgs = this.extraRunCmdArgs != null ? ImmutableList.copyOf(this.extraRunCmdArgs) : ImmutableList.of();
        ImmutableSet<String> excludeRunners = this.excludeRunnerOpt != null ? ImmutableSet.copyOf(this.excludeRunnerOpt) : ImmutableSet.of();
        Path xtsRootDirectory = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        String xtsType = this.commandHelper.getXtsType();
        SessionPluginProto.RunCommand.Builder runCommand = SessionPluginProto.RunCommand.newBuilder().setXtsRootDir(xtsRootDirectory.toString()).setXtsType(xtsType).addAllDeviceSerial(deviceSerials).addAllExcludeDeviceSerial(excludeSerials).addAllProductType(productTypes).putAllDeviceProperty(devicePropertiesMap).addAllIncludeFilter(includeFilters).addAllExcludeFilter(excludeFilters).setHtmlInZip(this.htmlInZip).setReportSystemCheckers(this.reportSystemCheckers).putAllXtsSuiteInfo(new CertificationSuiteInfoFactory().generateSuiteInfoMap(xtsRootDirectory.toString(), xtsType, this.config));
        moduleMetadataIncludeFilters.forEach((key, value) -> runCommand.addModuleMetadataIncludeFilter(SessionPluginProto.ModuleMetadataFilterEntry.newBuilder().setKey((String)key).setValue((String)value)));
        moduleMetadataExcludeFilters.forEach((key, value) -> runCommand.addModuleMetadataExcludeFilter(SessionPluginProto.ModuleMetadataFilterEntry.newBuilder().setKey((String)key).setValue((String)value)));
        this.isSkipDeviceInfo().ifPresent(runCommand::setSkipDeviceInfo);
        if (this.shardCount > 0) {
            runCommand.setShardCount(this.shardCount);
        }
        if (this.consoleInfo.getPythonPackageIndexUrl().isPresent()) {
            runCommand.setPythonPkgIndexUrl(this.consoleInfo.getPythonPackageIndexUrl().get());
        }
        runCommand.setTestPlan(this.config).addAllModuleName(modules).addAllModuleArg(moduleArgs).addAllExtraArg(extraArgs).addAllExcludeRunner(excludeRunners);
        if (!test.isEmpty()) {
            runCommand.setTestName(test);
        }
        if (!Strings.isNullOrEmpty(this.subPlanName)) {
            runCommand.setSubPlanName(this.subPlanName);
        }
        if (this.retrySessionIndex != null) {
            this.retrySessionResultDirName = this.getRetrySessionResultDirName(this.retrySessionIndex);
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Retry session index [%s] mapped to retry session result dir name [%s]", (Object)this.retrySessionIndex, (Object)this.retrySessionResultDirName);
        }
        if (!Strings.isNullOrEmpty(this.retrySessionResultDirName)) {
            runCommand.setRetrySessionResultDirName(this.retrySessionResultDirName.trim());
        }
        if (this.retryType != null) {
            runCommand.setRetryType(Ascii.toUpperCase(this.retryType.name()));
        }
        if (Flags.instance().enableXtsDynamicDownloader.getNonNull().booleanValue()) {
            runCommand.setEnableXtsDynamicDownload(true);
        }
        if (Flags.instance().enableMoblyResultstoreUpload.getNonNull().booleanValue()) {
            runCommand.setEnableMoblyResultstoreUpload(true);
        }
        if (this.deviceTypeOptionsGroup != null) {
            if (this.deviceTypeOptionsGroup.runTestOnEmulator) {
                runCommand.setDeviceType(SessionPluginProto.DeviceType.EMULATOR);
            }
            if (this.deviceTypeOptionsGroup.runTestOnRealDevice) {
                runCommand.setDeviceType(SessionPluginProto.DeviceType.REAL_DEVICE);
            }
        }
        if (this.requireBatteryCheck) {
            if (this.maxBattery != null) {
                runCommand.setMaxBatteryLevel(this.maxBattery);
            }
            if (this.minBattery != null) {
                runCommand.setMinBatteryLevel(this.minBattery);
            }
        }
        if (this.requireBatteryTemperatureCheck && this.maxBatteryTemperature != null) {
            runCommand.setMaxBatteryTemperature(this.maxBatteryTemperature);
        }
        if (this.minSdk != null) {
            runCommand.setMinSdkLevel(this.minSdk);
        }
        if (this.maxSdk != null) {
            runCommand.setMaxSdkLevel(this.maxSdk);
        }
        if (Flags.instance().enableCtsVerifierResultReporter.getNonNull().booleanValue()) {
            runCommand.setEnableCtsVerifierResultReporter(true);
        }
        if (this.consoleInfo.isFromCommandFile()) {
            runCommand.setJobStartTimeout(TimeUtils.toProtoDuration(CMDFILE_JOBS_START_TIMEOUT));
        }
        runCommand.setEnableDefaultLogs(Boolean.TRUE.equals(this.enableDefaultLogs));
        ImmutableList<String> commandLineArgs = command.stream().skip(1L).collect(ImmutableList.toImmutableList());
        runCommand.setInitialState(SessionPluginProto.RunCommandState.newBuilder().setCommandLineArgs(String.join((CharSequence)" ", commandLineArgs)).addAllSeparatedCommandLineArgs(commandLineArgs));
        if (!Flags.instance().enableAtsConsoleOlcServerLog.getNonNull().booleanValue()) {
            this.serverLogPrinter.enable(true);
        }
        ListenableFuture<SessionPluginProto.AtsSessionPluginOutput> atsRunSessionFuture = this.atsSessionStub.runSession(RUN_COMMAND_SESSION_NAME, SessionPluginProto.AtsSessionPluginConfig.newBuilder().setRunCommand(runCommand).build());
        RUNNING_COMMAND_COUNT.incrementAndGet();
        Futures.addCallback(atsRunSessionFuture, new RunCommandFutureCallback(this.consoleUtil, this.serverLogPrinter), this.executorService);
        this.consoleUtil.printlnStdout("Command submitted.");
        return 0;
    }

    private static ImmutableList<String> getXtsJavaCommand(String xtsType, Path xtsRootDir, ImmutableList<String> jvmFlags, String concatenatedJarPath, ImmutableList<String> xtsRunCommandArgs) {
        Path javaBinary = XtsCommandUtil.getJavaBinary(xtsType, xtsRootDir);
        return XtsCommandUtil.getTradefedJavaCommand(javaBinary.toString(), jvmFlags, concatenatedJarPath, ImmutableList.of(XtsCommandUtil.getXtsRootJavaProperty(xtsType, xtsRootDir)), XtsCommandUtil.getConsoleClassName(), xtsRunCommandArgs);
    }

    @VisibleForTesting
    List<String> getProductTypes() {
        return this.productTypes;
    }

    @VisibleForTesting
    Map<String, String> getDevicePropertiesMap() {
        return this.devicePropertiesMap;
    }

    @VisibleForTesting
    List<String> getSerials() {
        return this.serialOpt;
    }

    @VisibleForTesting
    List<String> getExtraRunCmdArgs() {
        return this.extraRunCmdArgs;
    }

    @VisibleForTesting
    Multimap<String, String> getModuleMetadataIncludeFilters() {
        return this.moduleMetadataIncludeFilters;
    }

    @VisibleForTesting
    Multimap<String, String> getModuleMetadataExcludeFilters() {
        return this.moduleMetadataExcludeFilters;
    }

    private Optional<Boolean> isSkipDeviceInfo() {
        if (this.skipDeviceInfo == null && Objects.equals(this.config, "cts-dev")) {
            return Optional.of(true);
        }
        if (this.skipDeviceInfo == null && Objects.equals(this.config, "csuite-app-crawl")) {
            return Optional.of(true);
        }
        return Optional.ofNullable(this.skipDeviceInfo);
    }

    @VisibleForTesting
    String getRetrySessionResultDirName(int retrySessionIndex) throws MobileHarnessException {
        Path xtsRootDir = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        String resultsDir = XtsDirUtil.getXtsResultsDir(xtsRootDir, this.commandHelper.getXtsType()).toString();
        ImmutableList<File> allResultDirs = this.resultListerHelper.listResultDirsInOrder(resultsDir);
        if (retrySessionIndex < 0 || retrySessionIndex >= allResultDirs.size()) {
            throw new IllegalArgumentException(String.format("The given retry session index %s is out of index. The session index range is [%d, %d)", retrySessionIndex, 0, allResultDirs.size()));
        }
        return ((File)allResultDirs.get(retrySessionIndex)).getName();
    }

    static class ModuleTestOptionsGroup {
        @CommandLine.Option(names={"-m", "--module"}, required=true, paramLabel="<test_module_name>", description={"Run the specified module."})
        String module;
        @CommandLine.Option(names={"-t", "--test"}, required=false, paramLabel="<test_case_name>", description={"Run the specified test case."})
        String test;

        ModuleTestOptionsGroup() {
        }
    }

    static class DeviceTypeOptionsGroup {
        @CommandLine.Option(names={"-e", "--emulator"}, required=false, paramLabel="<run_test_on_emulator>", description={"If true, force this test to run on emulator. Default is false."})
        boolean runTestOnEmulator;
        @CommandLine.Option(names={"-rd", "--device"}, required=false, paramLabel="<run_test_on_real_device>", description={"If true, force this test to run on a physical device, not an emulator. Default is false."})
        boolean runTestOnRealDevice;

        DeviceTypeOptionsGroup() {
        }
    }

    private static class RunCommandFutureCallback
    implements FutureCallback<SessionPluginProto.AtsSessionPluginOutput> {
        private final ConsoleUtil consoleUtil;
        private final ServerLogPrinter serverLogPrinter;

        public RunCommandFutureCallback(ConsoleUtil consoleUtil, ServerLogPrinter serverLogPrinter) {
            this.consoleUtil = consoleUtil;
            this.serverLogPrinter = serverLogPrinter;
        }

        @Override
        public void onSuccess(SessionPluginProto.AtsSessionPluginOutput output) {
            try {
                PluginOutputPrinter.printOutput(output, this.consoleUtil);
            }
            finally {
                this.disableServerLogPrinterIfNecessary();
            }
        }

        @Override
        public void onFailure(Throwable error) {
            try {
                ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(error)).log("Failed to execute command");
            }
            finally {
                this.disableServerLogPrinterIfNecessary();
            }
        }

        private void disableServerLogPrinterIfNecessary() {
            block3: {
                int runningCommandCount = RUNNING_COMMAND_COUNT.decrementAndGet();
                if (!Flags.instance().enableAtsConsoleOlcServerLog.getNonNull().booleanValue() && runningCommandCount == 0) {
                    try {
                        this.serverLogPrinter.enable(false);
                    }
                    catch (MobileHarnessException | InterruptedException e) {
                        ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Failed to disable server log printer");
                        if (!(e instanceof InterruptedException)) break block3;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

