/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerPreparer;
import com.google.devtools.mobileharness.infra.ats.common.plan.PlanConfigUtil;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.controller.olcserver.AtsSessionStub;
import com.google.devtools.mobileharness.infra.ats.console.controller.proto.SessionPluginProto;
import com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.AtsSessionPluginConfigOutput;
import com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.PluginOutputPrinter;
import com.google.devtools.mobileharness.infra.ats.console.util.command.CommandHelper;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.plan.PlanHelper;
import com.google.devtools.mobileharness.infra.ats.console.util.result.ResultLister;
import com.google.devtools.mobileharness.infra.ats.console.util.subplan.SubPlanLister;
import com.google.devtools.mobileharness.platform.android.xts.suite.params.ModuleParameters;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"l"}, sortOptions=false, description={"List invocations, devices, modules, etc."}, synopsisSubcommandLabel="", subcommands={CommandLine.HelpCommand.class})
class ListCommand
implements Callable<Integer> {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private final ConsoleInfo consoleInfo;
    private final ConsoleUtil consoleUtil;
    private final ServerPreparer serverPreparer;
    private final AtsSessionStub atsSessionStub;
    private final ResultLister resultLister;
    private final PlanHelper planHelper;
    private final SubPlanLister subPlanLister;
    private final CommandHelper commandHelper;

    @Inject
    ListCommand(ConsoleInfo consoleInfo, ConsoleUtil consoleUtil, ServerPreparer serverPreparer, AtsSessionStub atsSessionStub, ResultLister resultLister, PlanHelper planHelper, SubPlanLister subPlanLister, CommandHelper commandHelper) {
        this.consoleInfo = consoleInfo;
        this.consoleUtil = consoleUtil;
        this.serverPreparer = serverPreparer;
        this.atsSessionStub = atsSessionStub;
        this.resultLister = resultLister;
        this.planHelper = planHelper;
        this.subPlanLister = subPlanLister;
        this.commandHelper = commandHelper;
    }

    @Override
    public Integer call() {
        throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required subcommand");
    }

    @CommandLine.Command(name="commands", aliases={"c"}, description={"List all commands currently waiting to be executed"})
    public int commands(@CommandLine.Option(names={"all"}) boolean listAllCommands) throws MobileHarnessException, InterruptedException {
        this.serverPreparer.prepareOlcServer();
        ImmutableList<AtsSessionPluginConfigOutput> sessionPluginConfigOutputs = this.atsSessionStub.getAllUnfinishedSessions("run_command", !listAllCommands);
        String result = PluginOutputPrinter.listCommands(sessionPluginConfigOutputs);
        this.consoleUtil.printlnStdout(result);
        return 0;
    }

    @CommandLine.Command(name="devices", aliases={"d"}, description={"List all detected or known devices. Use \"list devices all\" to list all devices including placeholders."})
    public int devices(@CommandLine.Option(names={"all"}) boolean listAllDevices) throws MobileHarnessException, InterruptedException {
        this.serverPreparer.prepareOlcServer();
        SessionPluginProto.AtsSessionPluginOutput output = this.atsSessionStub.runShortSession("list_devices_command", SessionPluginProto.AtsSessionPluginConfig.newBuilder().setListCommand(SessionPluginProto.ListCommand.newBuilder().setListDevicesCommand(SessionPluginProto.ListDevicesCommand.newBuilder().setListAllDevices(listAllDevices))).build());
        return PluginOutputPrinter.printOutput(output, this.consoleUtil);
    }

    @CommandLine.Command(name="invocations", aliases={"i"}, description={"List all invocation threads"})
    public int invocations(@CommandLine.Option(names={"all"}) boolean listAllInvocations) throws MobileHarnessException, InterruptedException {
        this.serverPreparer.prepareOlcServer();
        ImmutableList<AtsSessionPluginConfigOutput> sessionPluginConfigOutputs = this.atsSessionStub.getAllUnfinishedSessions("run_command", !listAllInvocations);
        String result = PluginOutputPrinter.listInvocations(sessionPluginConfigOutputs);
        this.consoleUtil.printlnStdout(result);
        return 0;
    }

    @CommandLine.Command(name="modules", aliases={"m"}, description={"List all modules available, or all modules matching the given module parameter."})
    public int modules(@CommandLine.Parameters(index="0", arity="0..1", paramLabel="<module_parameter>", description={"Supported params: ${COMPLETION-CANDIDATES}"}) ModuleParameters moduleParameter) throws MobileHarnessException, InterruptedException {
        this.serverPreparer.prepareOlcServer();
        Path xtsRootDir = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        SessionPluginProto.ListModulesCommand.Builder listModulesCommandBuilder = SessionPluginProto.ListModulesCommand.newBuilder().setXtsRootDir(xtsRootDir.toString()).setXtsType(this.commandHelper.getXtsType());
        if (moduleParameter != null) {
            listModulesCommandBuilder.setModuleParameter(moduleParameter.name());
        }
        SessionPluginProto.AtsSessionPluginOutput output = this.atsSessionStub.runShortSession("list_modules_command", SessionPluginProto.AtsSessionPluginConfig.newBuilder().setListCommand(SessionPluginProto.ListCommand.newBuilder().setListModulesCommand(listModulesCommandBuilder)).build());
        return PluginOutputPrinter.printOutput(output, this.consoleUtil);
    }

    @CommandLine.Command(name="plans", aliases={"p", "configs"}, description={"List all plans/configs available"})
    public int plans() throws MobileHarnessException {
        this.consoleUtil.printlnStdout(this.formatPlans(this.planHelper.listPlans()));
        return 0;
    }

    @CommandLine.Command(name="results", aliases={"r"}, description={"List all results"})
    public int results() throws MobileHarnessException {
        this.consoleUtil.printlnStdout(this.resultLister.listResults(this.commandHelper.getXtsType()));
        return 0;
    }

    @CommandLine.Command(name="subplans", aliases={"s"}, description={"List all available subplans"})
    public int subplans() throws MobileHarnessException {
        Path xtsRootDir = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        ImmutableList<String> subPlanFileNames = this.subPlanLister.listSubPlans(xtsRootDir.toString(), this.commandHelper.getXtsType());
        if (subPlanFileNames.isEmpty()) {
            this.consoleUtil.printlnStdout("No subplans found");
            return 0;
        }
        subPlanFileNames.forEach(this.consoleUtil::printlnStdout);
        return 0;
    }

    private String formatPlans(ImmutableMap<String, PlanConfigUtil.PlanConfigInfo> planConfigInfosByConfigName) {
        return planConfigInfosByConfigName.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(planConfigInfo -> String.format("\n  %s: %s", planConfigInfo.configName(), planConfigInfo.description())).collect(Collectors.joining("", "Available plans include:", ""));
    }
}

