/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.devtools.mobileharness.infra.ats.console.util.command.ExitUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="exit", aliases={"quit", "q"}, description={"Exit the console."})
final class ExitCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--wait-for-command", "-c"}, required=false, paramLabel="<wait_for_command>", description={"Whether to exit only after all commands have executed. If false, will stop running commands, wait until they finish and then exit. If true, will directly wait until running commands finish and then exit. Default is false."})
    private boolean waitForCommand = false;
    @CommandLine.Option(names={"--stop-reading-input", "-s"}, required=false, paramLabel="<stop_reading_input>", description={"Whether to stop reading input when waiting until running commands finish. If true, the console will become not responsive immediately. Default is false."})
    private boolean stopReadingInput = false;
    private final ExitUtil exitUtil;
    private final ConsoleUtil consoleUtil;

    @Inject
    ExitCommand(ExitUtil exitUtil, ConsoleUtil consoleUtil) {
        this.exitUtil = exitUtil;
        this.consoleUtil = consoleUtil;
    }

    @Override
    public Integer call() {
        if (!this.waitForCommand) {
            this.exitUtil.cancelUnfinishedSessions("User triggered Exit Command.", false);
        }
        ListenableFuture<?> noRunningSessionsFuture = this.exitUtil.waitUntilNoRunningSessionsAndInterruptLineReader();
        if (this.stopReadingInput) {
            this.consoleUtil.printlnStdout("Stop reading input");
            Futures.getUnchecked(noRunningSessionsFuture);
        }
        return 0;
    }
}

