/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common.olcserver;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.devtools.mobileharness.api.model.error.InfraErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessExceptionFactory;
import com.google.devtools.mobileharness.infra.ats.common.FlagsString;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.Annotations;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerEnvironmentPreparer;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerHeapDumpFileDetector;
import com.google.devtools.mobileharness.infra.client.longrunningservice.constant.OlcServerDirs;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.ControlServiceProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.VersionServiceProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.ControlStub;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.VersionStub;
import com.google.devtools.mobileharness.infra.client.longrunningservice.util.VersionProtoUtil;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.constant.closeable.NonThrowingAutoCloseable;
import com.google.devtools.mobileharness.shared.util.base.ProtoTextFormat;
import com.google.devtools.mobileharness.shared.util.base.TableFormatter;
import com.google.devtools.mobileharness.shared.util.command.Command;
import com.google.devtools.mobileharness.shared.util.command.CommandExecutor;
import com.google.devtools.mobileharness.shared.util.command.CommandProcess;
import com.google.devtools.mobileharness.shared.util.command.CommandStartException;
import com.google.devtools.mobileharness.shared.util.command.LineCallback;
import com.google.devtools.mobileharness.shared.util.command.java.JavaCommandCreator;
import com.google.devtools.mobileharness.shared.util.concurrent.MoreFutures;
import com.google.devtools.mobileharness.shared.util.error.MoreThrowables;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import com.google.devtools.mobileharness.shared.util.system.SystemUtil;
import com.google.devtools.mobileharness.shared.util.time.Sleeper;
import com.google.devtools.mobileharness.shared.util.time.TimeUtils;
import com.google.devtools.mobileharness.shared.version.Version;
import io.grpc.Status;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ServerPreparer {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String LOCK_FILE_PATH = "/tmp/olc_server_startup.lck";
    private static final String SH_COMMAND = "sh";
    private static final String NOHUP_COMMAND = "nohup";
    private static final Duration HEARTBEAT_INTERVAL = Duration.ofSeconds(10L);
    private static final Duration CONNECT_SERVER_INTERVAL = Duration.ofSeconds(1L);
    private static final ImmutableList<String> UNFINISHED_SESSIONS_TABLE_HEADER = ImmutableList.of("Session ID", "Name", "Status", "Submitted Time");
    private static final String FORCIBLY_RESTART_SUGGESTION = "if necessary, run \"server restart -f\" command in the console or \"kill -9 %s\" in the terminal to forcibly restart OLC server.\nIMPORTANT: This action will also forcibly kill all running jobs submitted from ANY console on the same machine. Ensure all critical jobs are finished before proceeding.";
    private final String clientComponentName;
    private final String clientId;
    private final CommandExecutor commandExecutor;
    private final Sleeper sleeper;
    private final SystemUtil systemUtil;
    private final LocalFileUtil localFileUtil;
    private final Provider<ControlStub> controlStub;
    private final Provider<VersionStub> versionStub;
    private final ServerEnvironmentPreparer serverEnvironmentPreparer;
    private final FlagsString deviceInfraServiceFlags;
    private final ListeningScheduledExecutorService scheduledThreadPool;
    private final ServerHeapDumpFileDetector serverHeapDumpFileDetector;
    private final Object prepareServerLock = new Object();
    @GuardedBy(value="prepareServerLock")
    private boolean hasPrepared;

    @Inject
    ServerPreparer(@Annotations.ClientComponentName String clientComponentName, @Annotations.ClientId String clientId, CommandExecutor commandExecutor, Sleeper sleeper, SystemUtil systemUtil, LocalFileUtil localFileUtil, @Annotations.ServerStub(value=Annotations.ServerStub.Type.CONTROL_SERVICE) Provider<ControlStub> controlStub, @Annotations.ServerStub(value=Annotations.ServerStub.Type.VERSION_SERVICE) Provider<VersionStub> versionStub, ServerEnvironmentPreparer serverEnvironmentPreparer, @Annotations.DeviceInfraServiceFlags FlagsString deviceInfraServiceFlags, ListeningScheduledExecutorService scheduledThreadPool, ServerHeapDumpFileDetector serverHeapDumpFileDetector) {
        this.clientComponentName = clientComponentName;
        this.clientId = clientId;
        this.commandExecutor = commandExecutor;
        this.sleeper = sleeper;
        this.systemUtil = systemUtil;
        this.localFileUtil = localFileUtil;
        this.controlStub = controlStub;
        this.versionStub = versionStub;
        this.serverEnvironmentPreparer = serverEnvironmentPreparer;
        this.deviceInfraServiceFlags = deviceInfraServiceFlags;
        this.scheduledThreadPool = scheduledThreadPool;
        this.serverHeapDumpFileDetector = serverHeapDumpFileDetector;
    }

    public void startSendingHeartbeats() {
        if (Flags.instance().atsConsoleOlcServerEmbeddedMode.getNonNull().booleanValue()) {
            return;
        }
        ControlServiceProto.HeartbeatRequest request = ControlServiceProto.HeartbeatRequest.newBuilder().setClientId(this.clientId).build();
        MoreFutures.logFailure(this.scheduledThreadPool.scheduleWithFixedDelay(() -> {
            try {
                Objects.requireNonNull(this.controlStub.get()).heartbeat(request);
            }
            catch (GrpcExceptionWithErrorId e) {
                ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).atMostEvery(5, TimeUnit.MINUTES)).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Error when sending heartbeat to OLC server");
                this.serverHeapDumpFileDetector.detectHeapDumpExistenceWithGrpcError(e);
            }
        }, Duration.ZERO, HEARTBEAT_INTERVAL), Level.SEVERE, "Fatal error when sending heartbeat to OLC server", new Object[0]);
    }

    public Optional<VersionServiceProto.GetVersionResponse> tryConnectToOlcServer() throws MobileHarnessException {
        try {
            return Optional.of(Objects.requireNonNull(this.versionStub.get()).getVersion());
        }
        catch (GrpcExceptionWithErrorId e) {
            if (!e.getUnderlyingRpcException().getStatus().getCode().equals((Object)Status.Code.UNAVAILABLE)) {
                throw new MobileHarnessException(InfraErrorId.ATSC_SERVER_PREPARER_CONNECT_EXISTING_OLC_SERVER_ERROR, "Failed to connect to existing OLC server", e);
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareOlcServer() throws MobileHarnessException, InterruptedException {
        if (Flags.instance().atsConsoleOlcServerEmbeddedMode.getNonNull().booleanValue()) {
            return;
        }
        Object object = this.prepareServerLock;
        synchronized (object) {
            boolean firstPreparation = !this.hasPrepared;
            this.hasPrepared = true;
            Optional<NonThrowingAutoCloseable> fileUnlocker = this.lockFile();
            try {
                CommandProcess serverProcess;
                VersionServiceProto.GetVersionResponse existingServerVersion = this.tryConnectToOlcServer().orElse(null);
                if (existingServerVersion != null) {
                    if (firstPreparation) {
                        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Connected to existing OLC server, version=[%s]", ProtoTextFormat.shortDebugString(existingServerVersion));
                    }
                    if (ServerPreparer.needKillExistingServer(firstPreparation, existingServerVersion)) {
                        this.killExistingServer(false);
                    } else {
                        if (firstPreparation) {
                            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Using existing OLC server");
                            this.checkAndPrintServerVersionWarning(existingServerVersion);
                            Optional<String> processWorkingDir = this.systemUtil.getProcessWorkingDirectory(existingServerVersion.getProcessId());
                            processWorkingDir.ifPresent(dir -> this.serverHeapDumpFileDetector.setOlcServerInfo(existingServerVersion.getProcessId(), (String)dir));
                        }
                        return;
                    }
                }
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Starting new OLC server...");
                ServerEnvironmentPreparer.ServerEnvironment serverEnvironment = this.serverEnvironmentPreparer.prepareServerEnvironment();
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("OLC server environment: %s", serverEnvironment);
                ImmutableList<String> serverNativeArguments = ImmutableList.of("-Xmx" + Flags.instance().atsConsoleOlcServerXmx.getNonNull(), "-XX:+HeapDumpOnOutOfMemoryError", "-XX:+ExitOnOutOfMemoryError");
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("OLC server flags: %s, native arguments: %s", this.deviceInfraServiceFlags.flags(), serverNativeArguments);
                String serverOutputPath = Flags.instance().atsConsoleOlcServerOutputPath.getNonNull();
                ImmutableList.Builder startOlcServerCommandBuilder = ImmutableList.builder();
                startOlcServerCommandBuilder.add(NOHUP_COMMAND);
                startOlcServerCommandBuilder.addAll(JavaCommandCreator.of(true, ServerPreparer.wrapPath(serverEnvironment.javaBinary().toString())).createJavaCommand(ServerPreparer.wrapPath(serverEnvironment.serverBinary().toString()), ImmutableList.of(this.deviceInfraServiceFlags.flagsString()), serverNativeArguments));
                ((ImmutableList.Builder)((ImmutableList.Builder)startOlcServerCommandBuilder.add(">" + serverOutputPath)).add("2>&1")).add("&");
                StringBuilderLineCallback serverOutputLineCallback = new StringBuilderLineCallback();
                Command serverCommand = Command.of(ImmutableList.of(SH_COMMAND, "-c", Joiner.on(" ").join(startOlcServerCommandBuilder.build()))).workDir(serverEnvironment.serverWorkingDir()).timeout(ChronoUnit.YEARS.getDuration()).redirectStderr(false).onStdout(serverOutputLineCallback).onStderr(serverOutputLineCallback).needStdoutInResult(false).needStderrInResult(false);
                try {
                    serverProcess = this.commandExecutor.start(serverCommand);
                }
                catch (CommandStartException e) {
                    throw new MobileHarnessException(InfraErrorId.ATSC_SERVER_PREPARER_START_OLC_SERVER_ERROR, "Failed to start OLC server", e);
                }
                try {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Wait until OLC server starts, command=[%s]", serverProcess.command());
                    VersionServiceProto.GetVersionResponse serverVersion = this.connectWithRetry();
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("OLC server started, port=%s, pid=%s", (Object)Flags.instance().olcServerPort.getNonNull(), serverVersion.getProcessId());
                    this.serverHeapDumpFileDetector.setOlcServerInfo(serverVersion.getProcessId(), serverEnvironment.serverWorkingDir().toString());
                }
                catch (MobileHarnessException | Error | InterruptedException | RuntimeException e) {
                    if (serverProcess.isAlive()) {
                        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Killing OLC server");
                        serverProcess.kill();
                    }
                    try {
                        this.printServerStartingFailureInfo(serverCommand, serverOutputPath, serverOutputLineCallback);
                    }
                    catch (MobileHarnessException | Error | RuntimeException e2) {
                        ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to print server starting log from the log file, cause=%s", MoreThrowables.shortDebugString(e2));
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                    }
                    throw e;
                }
                finally {
                    serverProcess.stopReadingOutput();
                }
            }
            finally {
                fileUnlocker.ifPresent(NonThrowingAutoCloseable::close);
            }
        }
    }

    private void printServerStartingFailureInfo(Command serverCommand, String serverOutputPath, StringBuilderLineCallback serverOutputLineCallback) throws MobileHarnessException, InterruptedException {
        String serverStartingLog;
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("olc_server_command=%s", serverCommand.getCommand());
        String serverOutput = serverOutputLineCallback.toString();
        if (!serverOutput.isEmpty()) {
            serverStartingLog = serverOutput;
        } else if (!serverOutputPath.equals("/dev/null") && this.localFileUtil.isFileExist(serverOutputPath)) {
            serverStartingLog = this.localFileUtil.readFile(serverOutputPath);
        } else {
            Instant now;
            Path logFile = Path.of(OlcServerDirs.getLogDir(), new String[0]).resolve("log0.txt");
            if (!this.localFileUtil.isFileOrDirExist(logFile)) {
                return;
            }
            Instant lastModifiedTime = this.localFileUtil.getFileLastModifiedTime(logFile);
            Duration duration = Duration.between(lastModifiedTime, now = Instant.now());
            if (duration.compareTo(Flags.instance().atsConsoleOlcServerStartingTimeout.getNonNull().plusSeconds(5L)) > 0) {
                return;
            }
            serverStartingLog = this.localFileUtil.readFile(logFile);
        }
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("OLC server log:\n%s", serverStartingLog);
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("sh version:\n%s", this.commandExecutor.run(Command.of(SH_COMMAND, "--version")));
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("nohup version:\n%s", this.commandExecutor.run(Command.of(NOHUP_COMMAND, "--version")));
    }

    public void killExistingServer(boolean forcibly) throws MobileHarnessException, InterruptedException {
        ControlServiceProto.KillServerResponse killServerResponse;
        if (Flags.instance().atsConsoleOlcServerEmbeddedMode.getNonNull().booleanValue()) {
            return;
        }
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Killing existing OLC server...%s", forcibly ? " (forcibly)" : "");
        try {
            killServerResponse = Objects.requireNonNull(this.controlStub.get()).killServer(ControlServiceProto.KillServerRequest.newBuilder().setClientId(this.clientId).build());
        }
        catch (GrpcExceptionWithErrorId e) {
            throw new MobileHarnessException(InfraErrorId.ATSC_SERVER_PREPARER_KILL_EXISTING_OLC_SERVER_RPC_ERROR, "Failed to call KillServer of OLC server", e);
        }
        long serverPid = killServerResponse.getServerPid();
        if (killServerResponse.getResultCase() == ControlServiceProto.KillServerResponse.ResultCase.SUCCESS) {
            for (int i = 0; i < 10; ++i) {
                this.sleeper.sleep(Duration.ofSeconds(1L));
                try {
                    Objects.requireNonNull(this.versionStub.get()).getVersion();
                    continue;
                }
                catch (GrpcExceptionWithErrorId e) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Existing OLC server (pid=%s) killed", serverPid);
                    return;
                }
            }
        }
        if (!forcibly) {
            if (killServerResponse.getResultCase() == ControlServiceProto.KillServerResponse.ResultCase.FAILURE) {
                throw MobileHarnessExceptionFactory.createUserFacingException(InfraErrorId.ATSC_SERVER_PREPARER_CANNOT_KILL_EXISTING_OLC_SERVER_ERROR, String.format("Existing OLC server (pid=%s) cannot be killed, reason=[%s], %s", serverPid, ServerPreparer.createKillServerFailureReasons(killServerResponse.getFailure()), String.format(FORCIBLY_RESTART_SUGGESTION, serverPid)), null);
            }
            throw MobileHarnessExceptionFactory.createUserFacingException(InfraErrorId.ATSC_SERVER_PREPARER_EXISTING_OLC_SERVER_STILL_RUNNING_ERROR, String.format("Existing OLC server (pid=%s) is still running for 10s after it was killed, %s", serverPid, String.format(FORCIBLY_RESTART_SUGGESTION, serverPid)), null);
        }
        this.killServerProcess(serverPid);
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Existing OLC server (pid=%s) forcibly killed", serverPid);
    }

    private void killServerProcess(long serverPid) throws MobileHarnessException, InterruptedException {
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Killing OLC server process (pid=%s)", serverPid);
        this.systemUtil.killProcess((int)serverPid);
    }

    private VersionServiceProto.GetVersionResponse connectWithRetry() throws MobileHarnessException, InterruptedException {
        int count = 0;
        long maxAttempts = Flags.instance().atsConsoleOlcServerStartingTimeout.getNonNull().dividedBy(CONNECT_SERVER_INTERVAL) + 1L;
        while (true) {
            try {
                return Objects.requireNonNull(this.versionStub.get()).getVersion();
            }
            catch (GrpcExceptionWithErrorId e) {
                if ((long)(++count) > maxAttempts) {
                    throw new MobileHarnessException(InfraErrorId.ATSC_SERVER_PREPARER_CONNECT_NEW_OLC_SERVER_ERROR, "Failed to connect new OLC server", e);
                }
                this.sleeper.sleep(CONNECT_SERVER_INTERVAL);
                continue;
            }
            break;
        }
    }

    private static boolean needKillExistingServer(boolean firstPreparation, VersionServiceProto.GetVersionResponse getVersionResponse) throws MobileHarnessException {
        if (firstPreparation) {
            String minOlcLabVersionString;
            Version minOlcLabVersion;
            if (Flags.instance().atsConsoleAlwaysRestartOlcServer.getNonNull().booleanValue()) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Need to kill existing OLC server because --ats_console_always_restart_olc_server=true");
                return true;
            }
            String olcLabVersionString = getVersionResponse.getLabVersion();
            Version olcLabVersion = olcLabVersionString.isEmpty() ? new Version(0, 0, 0) : new Version(olcLabVersionString);
            if (olcLabVersion.compareTo(minOlcLabVersion = new Version(minOlcLabVersionString = Flags.instance().atsConsoleOlcServerMinLabVersion.getNonNull())) < 0) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Need to kill existing OLC server because the current OLC lab version [%s] is older than the minimum version [%s]", (Object)olcLabVersionString, (Object)minOlcLabVersionString);
                return true;
            }
        }
        return false;
    }

    private static String createKillServerFailureReasons(ControlServiceProto.KillServerResponse.Failure killServerFailure) {
        StringBuilder result = new StringBuilder();
        if (killServerFailure.getUnfinishedSessionsCount() > 0) {
            result.append("it has running sessions:\n");
            result.append(TableFormatter.displayTable(Stream.concat(Stream.of(UNFINISHED_SESSIONS_TABLE_HEADER), killServerFailure.getUnfinishedSessionsList().stream().map(sessionDetail -> ImmutableList.of(sessionDetail.getSessionId().getId(), sessionDetail.getSessionConfig().getSessionName(), sessionDetail.getSessionStatus().name(), TimeUtils.toJavaInstant(sessionDetail.getSessionOutput().getSessionTimingInfo().getSessionSubmittedTime()).toString()))).collect(ImmutableList.toImmutableList())));
        }
        if (killServerFailure.getAliveClientsCount() > 0) {
            result.append("it has alive clients:\n");
            result.append(String.join((CharSequence)"\n", killServerFailure.getAliveClientsList()));
        }
        return result.toString();
    }

    private void checkAndPrintServerVersionWarning(VersionServiceProto.GetVersionResponse serverVersion) {
        serverVersion = serverVersion.toBuilder().clearProcessId().build();
        VersionServiceProto.GetVersionResponse clientVersion = VersionProtoUtil.createGetVersionResponse().toBuilder().clearProcessId().build();
        if (!clientVersion.equals(serverVersion)) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Using existing OLC server in a different version, version of OLC server: [%s], version of %s: [%s]\nIf necessary, run \"server restart\" command to restart a new OLC server instance using the same version of the current console", ProtoTextFormat.shortDebugString(serverVersion), this.clientComponentName, ProtoTextFormat.shortDebugString(clientVersion));
        }
    }

    private static String wrapPath(String path) {
        return "'" + path + "'";
    }

    private Optional<NonThrowingAutoCloseable> lockFile() {
        RandomAccessFile file = null;
        try {
            RandomAccessFile finalFile = file = new RandomAccessFile(LOCK_FILE_PATH, "rw");
            this.localFileUtil.grantFileOrDirFullAccess(LOCK_FILE_PATH);
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Locking file [%s]", LOCK_FILE_PATH);
            FileChannel channel = file.getChannel();
            FileLock lock = channel.tryLock();
            if (lock == null) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Acquiring file lock [%s]...", LOCK_FILE_PATH);
                channel.lock();
            }
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Locked file [%s]", LOCK_FILE_PATH);
            return Optional.of(() -> {
                ServerPreparer.closeFile(finalFile);
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Released file lock [%s]", LOCK_FILE_PATH);
            });
        }
        catch (MobileHarnessException | IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Failed to lock file [%s]", LOCK_FILE_PATH);
            if (file != null) {
                ServerPreparer.closeFile(file);
            }
            return Optional.empty();
        }
    }

    private static void closeFile(RandomAccessFile file) {
        try {
            file.close();
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Failed to close file [%s]", LOCK_FILE_PATH);
        }
    }

    private static class StringBuilderLineCallback
    implements LineCallback {
        @GuardedBy(value="itself")
        private final StringBuilder stringBuilder = new StringBuilder();

        private StringBuilderLineCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LineCallback.Response onLine(String line) {
            StringBuilder stringBuilder = this.stringBuilder;
            synchronized (stringBuilder) {
                this.stringBuilder.append(line).append('\n');
            }
            return LineCallback.Response.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder stringBuilder = this.stringBuilder;
            synchronized (stringBuilder) {
                return this.stringBuilder.toString();
            }
        }
    }
}

