/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.util.DynamicConfigHandler;
import com.android.compatibility.common.util.UrlReplacement;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.dependencies.ExternalDependency;
import com.android.tradefed.dependencies.IExternalDependency;
import com.android.tradefed.dependencies.connectivity.NetworkDependency;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NativeDevice;
import com.android.tradefed.device.contentprovider.ContentProviderHandler;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.UserHelper;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.xmlpull.v1.XmlPullParserException;

@OptionClass(alias="dynamic-config-pusher")
public class DynamicConfigPusher
extends BaseTargetPreparer
implements IInvocationContextReceiver,
IExternalDependency {
    private static final String API_KEY = "AIzaSyAbwX5JRlmsLeygY2WWihpIJPXFLueOQ3U";
    @Option(name="api-key", description="API key for for dynamic configuration.")
    private String mApiKey = "AIzaSyAbwX5JRlmsLeygY2WWihpIJPXFLueOQ3U";
    @Option(name="cleanup", description="Whether to remove config files from the test target after test completion.")
    private boolean mCleanup = true;
    @Option(name="config-url", description="The url path of the dynamic config. If set, will override the default config location defined in CompatibilityBuildProvider.")
    private String mConfigUrl = "https://androidpartner.googleapis.com/v1/dynamicconfig/suites/{suite-name}/modules/{module}/version/{version}?key={api-key}";
    @Option(name="has-server-side-config", description="Whether there exists a service side dynamic config.")
    private boolean mHasServerSideConfig = true;
    @Option(name="config-filename", description="The module name for module-level configurations, or the suite name for suite-level configurations")
    private String mModuleName = null;
    @Option(name="target", description="The test target, \"device\" or \"host\"", mandatory=true)
    private TestTarget mTarget;
    @Option(name="version", description="The version of the configuration to retrieve from the server, e.g. \"1.0\". Defaults to suite version string.")
    private String mVersion;
    @Option(name="extract-from-resource", description="Whether to look for the local dynamic config inside the jar resources or on the local disk.")
    private boolean mExtractFromResource = false;
    @Option(name="dynamic-resource-name", description="When using --extract-from-resource, this option allow to specify the resource name, instead of the module name for the lookup. File will still be logged under the module name.")
    private String mResourceFileName = null;
    @Option(name="dynamic-config-name", description="The dynamic config name for module-level configurations, or the suite name for suite-level configurations.")
    private String mDynamicConfigName = null;
    private String mDeviceFilePushed;
    private IInvocationContext mModuleContext = null;

    public void setModuleName(String moduleName) {
        this.mModuleName = moduleName;
    }

    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mModuleContext = invocationContext;
    }

    @Override
    public Set<ExternalDependency> getDependencies() {
        HashSet<ExternalDependency> dependencies = new HashSet<ExternalDependency>();
        dependencies.add(new NetworkDependency());
        return dependencies;
    }

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        String suiteName;
        UrlReplacement.init();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        ITestDevice device = testInfo.getDevice();
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(buildInfo);
        File localConfigFile = this.getLocalConfigFile(buildHelper, device);
        String string = suiteName = this.mModuleContext != null ? this.getSuiteName() : TestSuiteInfo.getInstance().getName();
        if (this.mModuleName == null) {
            this.mModuleName = suiteName.toLowerCase();
            LogUtil.CLog.w((String)"Option config-filename isn't set. Using suite-name '%s'", (Object[])new Object[]{this.mModuleName});
            if (buildHelper.getDynamicConfigFiles().get(this.mModuleName) != null) {
                LogUtil.CLog.i((String)"Dynamic config file already collected, skipping DynamicConfigPusher.");
                return;
            }
        }
        if (this.mVersion == null) {
            this.mVersion = buildHelper.getSuiteVersion();
        }
        String apfeConfigInJson = this.resolveUrl(suiteName);
        File hostFile = this.mergeConfigFiles(localConfigFile, apfeConfigInJson, this.mModuleName, device);
        if (TestTarget.DEVICE.equals((Object)this.mTarget)) {
            int userId;
            String deviceDest = String.format("%s%s.dynamic", "/sdcard/dynamic-config-files/", this.createModuleName());
            if (!device.pushFile(hostFile, deviceDest, userId = UserHelper.getRunTestsAsUser((TestInformation)testInfo))) {
                throw new TargetSetupError(String.format("Failed to push local '%s' to remote '%s for user %d'", hostFile.getAbsolutePath(), deviceDest, userId), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_PUSH_FILE);
            }
            this.mDeviceFilePushed = deviceDest;
            if (!device.isPackageInstalled("android.tradefed.contentprovider") && device instanceof NativeDevice) {
                ContentProviderHandler contentProviderHandler = ((NativeDevice)device).getContentProvider(device.getCurrentUser());
            }
        }
        buildHelper.addDynamicConfigFile(this.mModuleName, hostFile);
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mDeviceFilePushed != null && !(e instanceof DeviceNotAvailableException) && this.mCleanup) {
            testInfo.getDevice().deleteFile(this.mDeviceFilePushed);
        }
    }

    String getSuiteName() {
        List testSuiteTags = this.mModuleContext.getConfigurationDescriptor().getSuiteTags();
        String suiteName = null;
        if (!testSuiteTags.isEmpty()) {
            if (testSuiteTags.size() >= 2) {
                LogUtil.CLog.i((String)("More than 2 test-suite-tag are defined. test-suite-tag: " + testSuiteTags));
            }
            suiteName = ((String)testSuiteTags.get(0)).toUpperCase();
            LogUtil.CLog.i((String)"Replacing {suite-name} placeholder with %s from test suite tags in dynamic config url.", (Object[])new Object[]{suiteName});
        } else {
            suiteName = TestSuiteInfo.getInstance().getName();
            LogUtil.CLog.i((String)"Replacing {suite-name} placeholder with %s from TestSuiteInfo in dynamic config url.", (Object[])new Object[]{suiteName});
        }
        return suiteName;
    }

    final File getLocalConfigFile(CompatibilityBuildHelper buildHelper, ITestDevice device) throws TargetSetupError {
        File localConfigFile = null;
        if (this.mExtractFromResource) {
            String lookupName = this.mResourceFileName != null ? this.mResourceFileName : this.mModuleName;
            InputStream dynamicFileRes = this.getClass().getResourceAsStream(String.format("/%s.dynamic", lookupName));
            try {
                localConfigFile = FileUtil.createTempFile((String)lookupName, (String)".dynamic");
                FileUtil.writeToFile((InputStream)dynamicFileRes, (File)localConfigFile);
            }
            catch (IOException e) {
                FileUtil.deleteFile((File)localConfigFile);
                throw new TargetSetupError(String.format("Fail to unpack '%s.dynamic' from resources", lookupName), (Throwable)e, device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
            }
            return localConfigFile;
        }
        try {
            String lookupName = this.mDynamicConfigName != null ? this.mDynamicConfigName : this.mModuleName;
            localConfigFile = buildHelper.getTestFile(String.format("%s.dynamic", lookupName));
        }
        catch (FileNotFoundException e) {
            throw new TargetSetupError("Cannot get local dynamic config file from test directory", (Throwable)e, device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        return localConfigFile;
    }

    File mergeConfigFiles(File localConfigFile, String apfeConfigInJson, String moduleName, ITestDevice device) throws TargetSetupError {
        File hostFile = null;
        try {
            File file = hostFile = DynamicConfigHandler.getMergedDynamicConfigFile((File)localConfigFile, (String)apfeConfigInJson, (String)moduleName, (Map)UrlReplacement.getUrlReplacementMap());
            return file;
        }
        catch (IOException | JSONException | XmlPullParserException e) {
            throw new TargetSetupError("Cannot get merged dynamic config file", e, device.getDeviceDescriptor());
        }
        finally {
            if (this.mExtractFromResource) {
                FileUtil.deleteFile((File)localConfigFile);
            }
        }
    }

    String resolveUrl(String suiteName) throws TargetSetupError {
        if (!this.mHasServerSideConfig) {
            return null;
        }
        try {
            String configUrl = UrlReplacement.getDynamicConfigServerUrl() == null ? this.mConfigUrl : UrlReplacement.getDynamicConfigServerUrl();
            String requestUrl = configUrl.replace("{suite-name}", suiteName).replace("{module}", this.mModuleName).replace("{version}", this.mVersion).replace("{api-key}", this.mApiKey);
            URL request = new URL(requestUrl);
            return StreamUtil.getStringFromStream((InputStream)request.openStream());
        }
        catch (IOException e) {
            throw new TargetSetupError(String.format("Trying to access android partner remote server over internet but failed: %s", e.getMessage()), (Throwable)e, null, false, (ErrorIdentifier)InfraErrorIdentifier.ANDROID_PARTNER_SERVER_ERROR);
        }
    }

    public String createModuleName() {
        return String.format("%s", this.mModuleName);
    }

    public static enum TestTarget {
        DEVICE,
        HOST;

    }
}

