/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ThrowingSupplier;
import com.android.tradefed.util.RunUtil;
import org.junit.Assert;

public final class HostSideTestUtils {
    private static final boolean DEBUG = false;

    public static <E extends Throwable> void waitUntil(String message, long timeoutSeconds, BooleanSupplierWithThrow<E> predicate) throws E {
        HostSideTestUtils.waitUntil(() -> message, timeoutSeconds, predicate);
    }

    public static <E extends Throwable> void waitUntil(ThrowingSupplier<String> message, long timeoutSeconds, BooleanSupplierWithThrow<E> predicate) throws E {
        int sleep = 125;
        long timeout = System.currentTimeMillis() + timeoutSeconds * 1000L;
        while (System.currentTimeMillis() < timeout) {
            if (predicate.getAsBoolean()) {
                return;
            }
            RunUtil.getDefault().sleep((long)sleep);
        }
        Assert.fail((String)HostSideTestUtils.getMessage(message));
    }

    private static String getMessage(ThrowingSupplier<String> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return "(Failed to get supplied message: " + e + ")";
        }
    }

    @FunctionalInterface
    public static interface BooleanSupplierWithThrow<E extends Throwable> {
        public boolean getAsBoolean() throws E;
    }
}

