/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.util;

import com.android.loganalysis.util.ArrayUtil;
import java.util.LinkedList;
import java.util.ListIterator;

public class LogTailUtil {
    private LinkedList<LogLine> mRingBuffer = new LinkedList();
    private int mMaxBufferSize;
    private int mLastTailSize;
    private int mIdTailSize;

    public LogTailUtil() {
        this(500, 15, 15);
    }

    public LogTailUtil(int maxBufferSize, int lastTailSize, int idTailSize) {
        this.mMaxBufferSize = maxBufferSize;
        this.mLastTailSize = lastTailSize;
        this.mIdTailSize = idTailSize;
    }

    public void addLine(Integer id, String line) {
        this.mRingBuffer.add(new LogLine(id, line));
        if (this.mRingBuffer.size() > this.mMaxBufferSize) {
            this.mRingBuffer.removeFirst();
        }
    }

    public String getLastTail() {
        return this.getLastTail(this.mLastTailSize);
    }

    public String getLastTail(int size) {
        int toIndex = this.mRingBuffer.size();
        int fromIndex = Math.max(toIndex - size, 0);
        LinkedList<String> tail = new LinkedList<String>();
        for (LogLine line : this.mRingBuffer.subList(fromIndex, toIndex)) {
            tail.add(line.mLine);
        }
        return ArrayUtil.join("\n", tail).trim();
    }

    public String getIdTail(int id) {
        return this.getIdTail(id, this.mIdTailSize);
    }

    public String getIdTail(int id, int size) {
        LinkedList<String> tail = new LinkedList<String>();
        ListIterator<LogLine> li = this.mRingBuffer.listIterator(this.mRingBuffer.size());
        while (li.hasPrevious() && tail.size() < size) {
            LogLine line = li.previous();
            if (line.mId == null || !line.mId.equals(id)) continue;
            tail.addFirst(line.mLine);
        }
        return ArrayUtil.join("\n", tail).trim();
    }

    private class LogLine {
        public Integer mId = null;
        public String mLine = null;

        public LogLine(Integer id, String line) {
            this.mId = id;
            this.mLine = line;
        }
    }
}

