/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.qa.mobileharness.shared.model.job;

import com.google.common.base.Preconditions;
import com.google.wireless.qa.mobileharness.shared.model.job.JobLocator;
import java.util.Objects;
import javax.annotation.Nullable;

public class TestLocator {
    private final String id;
    private final String name;
    private final JobLocator jobLocator;

    public TestLocator(String id, String name, JobLocator jobLocator) {
        this.id = Preconditions.checkNotNull(id);
        this.name = Preconditions.checkNotNull(name);
        this.jobLocator = Preconditions.checkNotNull(jobLocator, "Job locator is not specified");
    }

    public TestLocator(com.google.devtools.mobileharness.api.model.job.TestLocator newTestLocator) {
        this(newTestLocator.id(), newTestLocator.name(), new JobLocator(newTestLocator.jobLocator()));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public JobLocator getJobLocator() {
        return this.jobLocator;
    }

    public String toString() {
        return String.format("%s@%s", this.id, this.jobLocator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestLocator)) {
            return false;
        }
        TestLocator that = (TestLocator)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.jobLocator, that.jobLocator);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.jobLocator);
    }

    public com.google.devtools.mobileharness.api.model.job.TestLocator toNewTestLocator() {
        return com.google.devtools.mobileharness.api.model.job.TestLocator.of(this.id, this.name, this.jobLocator.toNewJobLocator());
    }

    @Nullable
    public static TestLocator tryParseString(String str) {
        int idx = str.indexOf(64);
        if (idx <= 0 || idx == str.length() - 1) {
            return null;
        }
        return new TestLocator(str.substring(0, idx), "", JobLocator.parseString(str.substring(idx + 1)));
    }
}

