/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.qa.mobileharness.shared;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.mobileharness.api.model.error.BasicErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.constant.closeable.NonThrowingAutoCloseable;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import com.google.devtools.mobileharness.shared.util.logging.MobileHarnessLogFormatter;
import com.google.devtools.mobileharness.shared.util.path.PathUtil;
import java.io.IOException;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class MobileHarnessLogger {
    private static final ImmutableMap<String, Level> DEBUG_LOG_LEVELS = ImmutableMap.of();
    private static final int LOG_FILE_SIZE_LIMIT = 0xA00000;
    private static final Filter COMMON_FILTER = logRecord -> !logRecord.getLoggerName().equals("io.grpc.netty.NettyServerHandler");
    private static final Filter FILTER = MobileHarnessLogger.combineFilter(COMMON_FILTER, logRecord -> true);
    private static final AtomicBoolean isInitialized = new AtomicBoolean();
    @Nullable
    private static volatile String logFileDirName;
    private static final Map<String, Logger> configuredLoggers;

    private MobileHarnessLogger() {
    }

    public static void init() {
        MobileHarnessLogger.init(null);
    }

    public static void init(@Nullable String logFileDirName) {
        Preconditions.checkState(!isInitialized.getAndSet(true), "Mobile Harness logger has already been initialized");
        MobileHarnessLogger.logFileDirName = logFileDirName;
        if (Flags.instance().enableDebugMode.getNonNull().booleanValue()) {
            DEBUG_LOG_LEVELS.forEach((className, level) -> MobileHarnessLogger.getLoggerByName(className).setLevel((Level)level));
        }
        Logger rootLogger = MobileHarnessLogger.getLoggerByName("");
        rootLogger.setLevel(Level.ALL);
        try {
            MobileHarnessLogger.createFileHandler("", "log%g.txt", Flags.instance().logFileNumber.getNonNull()).ifPresent(rootLogger::addHandler);
        }
        catch (MobileHarnessException e) {
            throw new IllegalArgumentException(e);
        }
        for (Handler handler : rootLogger.getHandlers()) {
            MobileHarnessLogger.configureHandler(handler);
            if (!(handler instanceof ConsoleHandler)) continue;
            int loggerConsoleHandlerMinLogRecordImportance = Flags.instance().loggerConsoleHandlerMinLogRecordImportance.getNonNull();
            MobileHarnessLogger.addFilter(handler, record -> LogRecordImportance.getLogRecordImportance(record, LogRecordImportance.LogImportanceScope.getCurrentScope()).value() >= loggerConsoleHandlerMinLogRecordImportance);
        }
    }

    public static void addHandlers(List<Handler> handlers) {
        Logger rootLogger = MobileHarnessLogger.getLoggerByName("");
        for (Handler handler : handlers) {
            MobileHarnessLogger.configureHandler(handler);
            rootLogger.addHandler(handler);
        }
    }

    public static void removeConsoleHandler() {
        Logger rootLogger = MobileHarnessLogger.getLoggerByName("");
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            rootLogger.removeHandler(handler);
        }
    }

    public static DateTimeFormatter getDateTimeFormatter() {
        return MobileHarnessLogFormatter.getDateTimeFormatter();
    }

    public static void removeHandler(@Nullable Class<?> loggerClass, @Nullable Handler handler) {
        if (handler != null) {
            MobileHarnessLogger.getLoggerByClass(loggerClass).removeHandler(handler);
        }
    }

    public static void useParentHandlers(Class<?> loggerClass, boolean useParentHandlers) {
        if (loggerClass != null) {
            MobileHarnessLogger.getLoggerByClass(loggerClass).setUseParentHandlers(useParentHandlers);
        }
    }

    public static NonThrowingAutoCloseable addSingleFileHandler(String logFileDir, String logFileNamePattern, @Nullable Filter extraFilter) throws MobileHarnessException {
        FileHandler logFileHandler;
        MobileHarnessLogger.prepareDir(logFileDir);
        String logFilePattern = PathUtil.join(logFileDir, logFileNamePattern);
        try {
            logFileHandler = new FileHandler(logFilePattern);
        }
        catch (IOException e) {
            throw new MobileHarnessException(BasicErrorId.MOBILE_HARNESS_LOGGER_CREATE_FILE_HANDLER_ERROR, "Failed to create file handler", e);
        }
        logFileHandler.setFilter(extraFilter);
        MobileHarnessLogger.configureHandler(logFileHandler);
        Logger rootLogger = MobileHarnessLogger.getLoggerByName("");
        rootLogger.addHandler(logFileHandler);
        return new HandlerRemover(rootLogger, logFileHandler);
    }

    private static Optional<Handler> createFileHandler(String subDir, String logFileNamePattern, int fileNum) throws MobileHarnessException {
        String logFileDirName = MobileHarnessLogger.logFileDirName;
        if (Strings.isNullOrEmpty(logFileDirName)) {
            return Optional.empty();
        }
        String logDir = PathUtil.join(logFileDirName, subDir);
        MobileHarnessLogger.prepareDir(logDir);
        String logFilePattern = PathUtil.join(logDir, logFileNamePattern);
        try {
            if (Flags.instance().logFileSizeNoLimit.getNonNull().booleanValue()) {
                return Optional.of(new FileHandler(logFilePattern));
            }
            return Optional.of(new FileHandler(logFilePattern, 0xA00000, fileNum));
        }
        catch (IOException e) {
            throw new MobileHarnessException(BasicErrorId.MOBILE_HARNESS_LOGGER_CREATE_FILE_HANDLER_ERROR, "Failed to create file handler", e);
        }
    }

    private static void configureHandler(Handler handler) {
        handler.setFormatter(MobileHarnessLogFormatter.getDefaultFormatter());
        MobileHarnessLogger.addFilter(handler, FILTER);
        handler.setLevel(Level.INFO);
    }

    private static void prepareDir(String dir) throws MobileHarnessException {
        LocalFileUtil localFileUtil = new LocalFileUtil();
        localFileUtil.prepareDir(dir, new FileAttribute[0]);
        localFileUtil.grantFileOrDirFullAccess(dir);
    }

    private static Logger getLoggerByClass(@Nullable Class<?> loggerClass) {
        return MobileHarnessLogger.getLoggerByName(loggerClass == null ? "" : loggerClass.getName().replace('$', '.'));
    }

    private static Logger getLoggerByName(String loggerName) {
        Logger logger = Logger.getLogger(loggerName);
        configuredLoggers.put(loggerName, logger);
        return logger;
    }

    private static void addFilter(Handler handler, Filter extraFilter) {
        handler.setFilter(MobileHarnessLogger.combineFilter(handler.getFilter(), extraFilter));
    }

    private static Filter combineFilter(@Nullable Filter filter1, @Nullable Filter filter2) {
        return logRecord -> {
            if (filter1 != null && !filter1.isLoggable(logRecord)) {
                return false;
            }
            return filter2 == null || filter2.isLoggable(logRecord);
        };
    }

    static {
        configuredLoggers = new ConcurrentHashMap<String, Logger>();
    }

    private static class HandlerRemover
    implements NonThrowingAutoCloseable {
        private final Logger logger;
        private final Handler handler;

        private HandlerRemover(Logger logger, Handler handler) {
            this.logger = logger;
            this.handler = handler;
        }

        @Override
        public void close() {
            this.logger.removeHandler(this.handler);
            this.handler.close();
        }
    }
}

