/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.system;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

public class ShutdownHookManager {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    @GuardedBy(value="hooks")
    private final Set<Hook> hooks = new LinkedHashSet<Hook>();
    @GuardedBy(value="hooks")
    private boolean hasShutdown;

    public static ShutdownHookManager getInstance() {
        return Holder.INSTANCE;
    }

    @VisibleForTesting
    ShutdownHookManager(boolean enable) {
        if (enable) {
            Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown, "shutdown-hook-manager"));
        }
    }

    @CanIgnoreReturnValue
    public Handle addShutdownHook(Task task, String name) {
        return this.addShutdownHook(task, name, Priority.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CanIgnoreReturnValue
    public Handle addShutdownHook(Task task, String name, Priority priority) {
        Hook hook = new Hook(Preconditions.checkNotNull(task), Preconditions.checkNotNull(name), Preconditions.checkNotNull(priority));
        Set<Hook> set = this.hooks;
        synchronized (set) {
            if (this.hasShutdown) {
                ((FluentLogger.Api)logger.atWarning()).log("Shutdown task [%s] cannot be added because shutdown() has been called", name);
            } else {
                this.hooks.add(hook);
            }
        }
        return hook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        List<Hook> sortedHooks;
        Set<Hook> set = this.hooks;
        synchronized (set) {
            if (this.hasShutdown) {
                return;
            }
            this.hasShutdown = true;
            sortedHooks = this.copyAndSortHooks();
        }
        for (Hook hook : sortedHooks) {
            ((FluentLogger.Api)logger.atInfo()).log("Starting shutdown task [%s]", hook.name);
            try {
                hook.task.run();
                ((FluentLogger.Api)logger.atInfo()).log("Finished shutdown task [%s]", hook.name);
            }
            catch (Error | Exception e) {
                if (ShutdownHookManager.isInterruption(e)) {
                    ((FluentLogger.Api)logger.atInfo()).log("Shutdown task [%s] is interrupted", hook.name);
                    Thread.currentThread().interrupt();
                    continue;
                }
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Shutdown task [%s] throws an exception", hook.name);
            }
        }
    }

    @GuardedBy(value="hooks")
    private List<Hook> copyAndSortHooks() {
        ArrayList<Hook> result = new ArrayList<Hook>(this.hooks);
        result.sort(Comparator.comparing(hook -> hook.priority));
        return result;
    }

    private static boolean isInterruption(Throwable e) {
        return e instanceof InterruptedException || e instanceof ClosedByInterruptException || e instanceof InterruptedIOException;
    }

    private static class Holder {
        private static final ShutdownHookManager INSTANCE = new ShutdownHookManager(true);

        private Holder() {
        }
    }

    public record Priority(int value) implements Comparable<Priority>
    {
        public static final Priority HIGHEST = new Priority(Integer.MIN_VALUE);
        public static final Priority TRAFFIC = new Priority(100);
        public static final Priority WORKERS = new Priority(200);
        public static final Priority RESOURCES = new Priority(300);
        public static final Priority LOWEST = new Priority(Integer.MAX_VALUE);
        public static final Priority DEFAULT = RESOURCES;

        @Override
        public int compareTo(Priority other) {
            return Integer.compare(this.value, other.value);
        }

        public Priority earlier(int delta) {
            return new Priority(this.value - delta);
        }

        public Priority later(int delta) {
            return new Priority(this.value + delta);
        }
    }

    public static interface Task {
        public void run() throws Exception;
    }

    public static interface Handle {
        public void remove();
    }

    private class Hook
    implements Handle {
        private final Task task;
        private final String name;
        private final Priority priority;

        private Hook(Task task, String name, Priority priority) {
            this.task = task;
            this.name = name;
            this.priority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Set<Hook> set = ShutdownHookManager.this.hooks;
            synchronized (set) {
                ShutdownHookManager.this.hooks.remove(this);
            }
        }
    }
}

