/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.concurrent;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.devtools.mobileharness.api.model.error.ErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessExceptions;
import com.google.devtools.mobileharness.shared.util.error.MoreThrowables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;

public class MoreFutures {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    private MoreFutures() {
    }

    @FormatMethod
    @CanIgnoreReturnValue
    public static <V> ListenableFuture<V> logFailure(ListenableFuture<V> future, final Level level, final String message, final Object ... params) {
        Futures.addCallback(future, new FutureCallback<V>(){

            @Override
            public void onSuccess(V result) {
            }

            @Override
            public void onFailure(Throwable t2) {
                boolean interrupted = t2 instanceof InterruptedException;
                ((FluentLogger.Api)logger.at(level).withCause(interrupted ? null : t2)).logVarargs(message, params);
                if (interrupted) {
                    logger.at(level).log("%s, stack_trace=%s", (Object)t2, (Object)MoreThrowables.shortDebugStackTrace(t2, 0L));
                }
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    public static <V> V get(ListenableFuture<V> future, ErrorId defaultErrorId) throws MobileHarnessException, InterruptedException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            return (V)MobileHarnessExceptions.rethrow(e.getCause(), defaultErrorId);
        }
    }

    @CanIgnoreReturnValue
    public static <V> V getUnchecked(ListenableFuture<V> future) throws InterruptedException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.throwIfInstanceOf(cause, InterruptedException.class);
            Throwables.throwIfUnchecked(cause);
            throw new AssertionError((Object)cause);
        }
    }

    public static <K, V> ListenableFuture<ImmutableMap<K, V>> allAsMap(ImmutableMap<? extends K, ? extends ListenableFuture<? extends V>> futures) {
        ListenableFuture<ImmutableMap<K, V>> result = Futures.whenAllSucceed(futures.values()).call(() -> futures.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> Futures.getUnchecked((Future)e.getValue()))), MoreExecutors.directExecutor());
        Futures.addCallback(result, new AllAsMapCallback(futures.values()), MoreExecutors.directExecutor());
        return result;
    }

    private static class AllAsMapCallback<K, V>
    implements FutureCallback<ImmutableMap<K, V>> {
        private final ImmutableCollection<? extends ListenableFuture<? extends V>> futures;

        private AllAsMapCallback(ImmutableCollection<? extends ListenableFuture<? extends V>> futures) {
            this.futures = futures;
        }

        @Override
        public void onSuccess(ImmutableMap<K, V> result) {
        }

        @Override
        public void onFailure(Throwable t2) {
            this.futures.forEach(future -> future.cancel(true));
        }
    }
}

