/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.FutureCallback;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.shared.constant.closeable.NonThrowingAutoCloseable;
import com.google.devtools.mobileharness.shared.util.concurrent.MobileHarnessCallable;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public final class Callables {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    public static void callAll(MobileHarnessCallable<?> ... callables) throws MobileHarnessException, InterruptedException {
        Throwable error;
        boolean interrupted = false;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (MobileHarnessCallable<?> callable : callables) {
            interrupted |= Thread.interrupted();
            try {
                Object result = callable.call();
                if (result == null) continue;
                ((FluentLogger.Api)logger.atInfo()).log("Callable [%s] returned [%s]", callable, result);
            }
            catch (MobileHarnessException | Error | InterruptedException | RuntimeException e) {
                errors.add(e);
                if (!Callables.isInterruptedException(e)) continue;
                interrupted = true;
            }
        }
        if (errors.isEmpty()) {
            error = null;
        } else {
            error = (Throwable)errors.get(0);
            errors.stream().skip(1L).forEach(error::addSuppressed);
        }
        if (interrupted && !Callables.isInterruptedException(error)) {
            Thread.currentThread().interrupt();
        }
        if (error == null) {
            return;
        }
        Throwables.throwIfInstanceOf(error, MobileHarnessException.class);
        Throwables.throwIfInstanceOf(error, InterruptedException.class);
        Throwables.throwIfUnchecked(error);
    }

    public static void runAll(Runnable ... runnables) {
        Throwable error;
        boolean interrupted = false;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Runnable runnable : runnables) {
            interrupted |= Thread.interrupted();
            try {
                runnable.run();
            }
            catch (Error | RuntimeException e) {
                errors.add(e);
            }
        }
        if (errors.isEmpty()) {
            error = null;
        } else {
            error = (Throwable)errors.get(0);
            errors.stream().skip(1L).forEach(error::addSuppressed);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (error == null) {
            return;
        }
        Throwables.throwIfUnchecked(error);
    }

    private static boolean isInterruptedException(Throwable e) {
        return e instanceof InterruptedException;
    }

    public static <T> Callable<T> threadRenaming(Callable<T> callable, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(callable);
        return () -> {
            try (NonThrowingAutoCloseable ignored = Callables.threadRenaming((String)nameSupplier.get());){
                Object v = callable.call();
                return v;
            }
        };
    }

    public static Runnable threadRenaming(Runnable runnable, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(runnable);
        return () -> {
            try (NonThrowingAutoCloseable ignored = Callables.threadRenaming((String)nameSupplier.get());){
                runnable.run();
            }
        };
    }

    public static <T> FutureCallback<T> threadRenaming(FutureCallback<T> futureCallback, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(futureCallback);
        return new ThreadRenamingFutureCallback<T>(futureCallback, nameSupplier);
    }

    public static NonThrowingAutoCloseable threadRenaming(String threadName) {
        return new ThreadRenamer(threadName);
    }

    @CanIgnoreReturnValue
    private static boolean trySetName(String threadName, Thread currentThread) {
        try {
            currentThread.setName(threadName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private Callables() {
    }

    private static class ThreadRenamingFutureCallback<V>
    implements FutureCallback<V> {
        private final FutureCallback<V> futureCallback;
        private final Supplier<String> nameSupplier;

        private ThreadRenamingFutureCallback(FutureCallback<V> futureCallback, Supplier<String> nameSupplier) {
            this.futureCallback = futureCallback;
            this.nameSupplier = nameSupplier;
        }

        @Override
        public void onSuccess(V result) {
            try (NonThrowingAutoCloseable ignored = Callables.threadRenaming(this.nameSupplier.get());){
                this.futureCallback.onSuccess(result);
            }
        }

        @Override
        public void onFailure(Throwable t2) {
            try (NonThrowingAutoCloseable ignored = Callables.threadRenaming(this.nameSupplier.get());){
                this.futureCallback.onFailure(t2);
            }
        }
    }

    private static class ThreadRenamer
    implements NonThrowingAutoCloseable {
        private final Thread thread = Thread.currentThread();
        private final String oldThreadName = this.thread.getName();
        private final boolean restoreThreadName;

        private ThreadRenamer(String threadName) {
            this.restoreThreadName = Callables.trySetName(threadName, this.thread);
        }

        @Override
        public void close() {
            if (this.restoreThreadName) {
                Callables.trySetName(this.oldThreadName, this.thread);
            }
        }
    }
}

