/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.backend;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.shared.util.command.backend.AsyncCopier;
import com.google.devtools.mobileharness.shared.util.command.backend.Command;
import com.google.devtools.mobileharness.shared.util.command.backend.CommandExecutor;
import com.google.devtools.mobileharness.shared.util.command.backend.CommandProcess;
import com.google.devtools.mobileharness.shared.util.command.backend.CommandStartException;
import com.google.devtools.mobileharness.shared.util.command.backend.InputSource;
import com.google.devtools.mobileharness.shared.util.command.backend.Opener;
import com.google.devtools.mobileharness.shared.util.command.backend.OutputSink;
import com.google.devtools.mobileharness.shared.util.concurrent.ThreadPools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

final class NativeProcess
extends CommandProcess {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    static final ExecutorService EXECUTOR_SERVICE = ThreadPools.createStandardThreadPool("native-process");
    static final CommandExecutor EXECUTOR = new CommandExecutor(){

        @Override
        public CommandProcess start(Command command) throws CommandStartException {
            try {
                return new NativeProcess(command);
            }
            catch (IOException e) {
                throw new CommandStartException(command, e);
            }
        }
    };
    private final Process process;
    private volatile boolean killed = false;
    private final Optional<AsyncCopier> stdinPump;
    private final Optional<AsyncCopier> stdoutPump;
    private final Optional<AsyncCopier> stderrPump;
    private final Supplier<Long> pid = Suppliers.memoize(this::fetchPid);

    private static ProcessBuilder.Redirect sourceToRedirect(InputSource source) {
        InputSource.Kind kind = source.kind();
        if (kind.equals((Object)InputSource.Kind.JVM)) {
            return ProcessBuilder.Redirect.INHERIT;
        }
        if (kind.equals((Object)InputSource.Kind.FILE)) {
            File file;
            try {
                file = source.file().toFile();
            }
            catch (UnsupportedOperationException e) {
                return ProcessBuilder.Redirect.PIPE;
            }
            return ProcessBuilder.Redirect.from(file);
        }
        return ProcessBuilder.Redirect.PIPE;
    }

    private static ProcessBuilder.Redirect sinkToRedirect(OutputSink sink, OutputSink.Kind inheritKind) {
        OutputSink.Kind kind = sink.kind();
        if (kind.equals((Object)inheritKind)) {
            return ProcessBuilder.Redirect.INHERIT;
        }
        if (kind.equals((Object)OutputSink.Kind.FILE) || kind.equals((Object)OutputSink.Kind.FILE_APPEND)) {
            File file;
            try {
                file = sink.file().toFile();
            }
            catch (UnsupportedOperationException e) {
                return ProcessBuilder.Redirect.PIPE;
            }
            return kind.equals((Object)OutputSink.Kind.FILE) ? ProcessBuilder.Redirect.to(file) : ProcessBuilder.Redirect.appendTo(file);
        }
        return ProcessBuilder.Redirect.PIPE;
    }

    private NativeProcess(Command command) throws IOException {
        super(command);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command().add(command.executable());
        processBuilder.command().addAll(command.arguments());
        processBuilder.environment().clear();
        processBuilder.environment().putAll(command.environment());
        if (command.workingDirectory().isPresent()) {
            processBuilder.directory(command.workingDirectory().get().toFile());
        }
        processBuilder.redirectInput(NativeProcess.sourceToRedirect(command.stdinSource()));
        processBuilder.redirectOutput(NativeProcess.sinkToRedirect(command.stdoutSink(), OutputSink.Kind.JVM_OUT));
        if (command.stderrSink().equals(command.stdoutSink())) {
            processBuilder.redirectErrorStream(true);
        } else {
            processBuilder.redirectError(NativeProcess.sinkToRedirect(command.stderrSink(), OutputSink.Kind.JVM_ERR));
        }
        this.process = processBuilder.start();
        this.stdinPump = this.maybeStartAsyncCopy(processBuilder.redirectInput().type().equals((Object)ProcessBuilder.Redirect.Type.PIPE) && !command.stdinSource().kind().equals((Object)InputSource.Kind.PROCESS), this::openStdinSourceStream, this.process::getOutputStream, "to stdin");
        this.stdoutPump = this.maybeStartAsyncCopy(processBuilder.redirectOutput().type().equals((Object)ProcessBuilder.Redirect.Type.PIPE), this.process::getInputStream, this::openStdoutSinkStream, "from stdout");
        this.stderrPump = this.maybeStartAsyncCopy(processBuilder.redirectError().type().equals((Object)ProcessBuilder.Redirect.Type.PIPE) && !processBuilder.redirectErrorStream(), this.process::getErrorStream, this::openStderrSinkStream, "from stderr");
        EXECUTOR_SERVICE.execute(this::awaitAndNotify);
    }

    @Override
    protected void killHook() {
        this.killed = true;
        this.process.destroy();
    }

    @Override
    protected void killForciblyHook() {
        this.killed = true;
        this.process.destroyForcibly();
    }

    @Override
    protected OutputStream stdinStreamHook() {
        return this.process.getOutputStream();
    }

    @Override
    protected long processIdHook() {
        long pid = this.pid.get();
        if (pid == -1L) {
            throw new UnsupportedOperationException("Process ID not available on this platform");
        }
        return pid;
    }

    private long fetchPid() {
        return this.process.toHandle().pid();
    }

    private Optional<AsyncCopier> maybeStartAsyncCopy(boolean condition, Opener.StreamSupplier<InputStream> in, Opener.StreamSupplier<OutputStream> out, String desc) throws IOException {
        return condition ? Optional.of(AsyncCopier.start(in.get(), out.get(), new IOExceptionLogger(desc))) : Optional.empty();
    }

    private void awaitAndNotify() {
        try {
            int exitCode = this.process.waitFor();
            if (this.stdinPump.isPresent()) {
                this.stdinPump.get().stop();
            }
            if (this.stdoutPump.isPresent()) {
                this.stdoutPump.get().await();
            }
            if (this.stderrPump.isPresent()) {
                this.stderrPump.get().await();
            }
            this.notifyComplete(exitCode);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause(e)).log("Process waiting thread interrupted");
            return;
        }
    }

    private final class IOExceptionLogger
    implements Consumer<IOException> {
        private final String desc;

        private IOExceptionLogger(String desc) {
            this.desc = desc;
        }

        @Override
        public void accept(IOException e) {
            if (NativeProcess.this.process.isAlive() && !NativeProcess.this.killed) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Unexpected IO error copying %s of a running process", this.desc);
            } else {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).withCause(e)).log("Benign IO error copying %s of a terminated process", this.desc);
            }
        }
    }
}

