/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.auto.value.AutoValue;
import com.google.devtools.mobileharness.shared.util.command.AutoValue_LineCallback_Response;
import com.google.devtools.mobileharness.shared.util.command.LineCallbackException;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

@FunctionalInterface
public interface LineCallback {
    public Response onLine(String var1) throws LineCallbackException;

    public static LineCallback does(Consumer<String> lineConsumer) {
        return line -> {
            lineConsumer.accept(line);
            return Response.empty();
        };
    }

    public static LineCallback writeTo(Writer writer) {
        return line -> {
            try {
                writer.write(line + "\n");
                return Response.empty();
            }
            catch (IOException e) {
                throw new LineCallbackException("Failed to write", e, false, true);
            }
        };
    }

    public static LineCallback answer(Function<String, Optional<String>> answerFunction) {
        return line -> ((Optional)answerFunction.apply(line)).map(Response::answer).orElseGet(Response::empty);
    }

    public static LineCallback answerLn(Function<String, Optional<String>> answerFunction) {
        return line -> ((Optional)answerFunction.apply(line)).map(Response::answerLn).orElseGet(Response::empty);
    }

    public static LineCallback stopWhen(Predicate<String> stopPredicate) {
        return line -> Response.stop(stopPredicate.test(line));
    }

    @AutoValue
    public static abstract class Response {
        public static Response empty() {
            return Response.notStop();
        }

        public static Response notStop() {
            return Response.stop(false);
        }

        public static Response stop() {
            return Response.stop(true);
        }

        public static Response stop(boolean stop) {
            return Response.builder().stop(stop).build();
        }

        public static Response answer(String answer) {
            return Response.builder().answer(answer).build();
        }

        public static Response answerLn(String answer) {
            return Response.answer(answer + "\n");
        }

        public static Response stopReadingOutput() {
            return Response.builder().stopReadingOutput(true).build();
        }

        public static Response of(boolean stop, @Nullable String answer, boolean stopReadingOutput) {
            return Response.builder().stop(stop).answer(answer).stopReadingOutput(stopReadingOutput).build();
        }

        public static Response ofLn(boolean stop, @Nullable String answer, boolean stopReadingOutput) {
            return Response.of(stop, answer == null ? null : answer + "\n", stopReadingOutput);
        }

        public Response withStop() {
            return this.withStop(true);
        }

        public Response withStop(boolean stop) {
            return this.toBuilder().stop(stop).build();
        }

        public Response withNotStop() {
            return this.withStop(false);
        }

        public Response withAnswer(String answer) {
            return this.toBuilder().answer(answer).build();
        }

        public Response withAnswerLn(String answer) {
            return this.withAnswer(answer + "\n");
        }

        public Response withStopReadingOutput() {
            return this.toBuilder().stopReadingOutput(true).build();
        }

        public abstract boolean getStop();

        public abstract Optional<String> getAnswer();

        public abstract boolean getStopReadingOutput();

        abstract Builder toBuilder();

        private static Builder builder() {
            return new AutoValue_LineCallback_Response.Builder().stop(false).stopReadingOutput(false);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder stop(boolean var1);

            abstract Builder answer(@Nullable String var1);

            abstract Builder stopReadingOutput(boolean var1);

            abstract Response build();
        }
    }
}

