/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.common.io.ByteSink;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class CommandOutputSink
extends ByteSink {
    private final CompositeOutputStream compositeOutputStream;
    private final BufferedReader bufferedReader;

    CommandOutputSink(boolean needResult, boolean needReader, int openStreamCount) {
        try {
            this.compositeOutputStream = new CompositeOutputStream(needResult, needReader, openStreamCount);
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new PipedInputStream(this.compositeOutputStream.pipedOutputStream), StandardCharsets.UTF_8));
            if (!needReader) {
                this.compositeOutputStream.pipedOutputStream.close();
            }
            if (openStreamCount == 0) {
                this.compositeOutputStream.close();
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public OutputStream openStream() {
        return this.compositeOutputStream;
    }

    BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    void closePipe() throws IOException {
        this.compositeOutputStream.closePipeLatch.countDown();
        if (this.compositeOutputStream.writeToPipe.getAndSet(false)) {
            while (this.bufferedReader.ready() && this.bufferedReader.read() != -1) {
            }
        }
    }

    boolean isClosed() {
        return this.compositeOutputStream.closePipeLatch.getCount() == 0L && this.compositeOutputStream.stringOutputStream.isClosed();
    }

    String awaitResult() throws InterruptedException {
        this.compositeOutputStream.closePipeLatch.await();
        return this.compositeOutputStream.stringOutputStream.await();
    }

    String awaitResult(Duration timeout) throws InterruptedException, TimeoutException {
        Instant deadline = Clock.systemUTC().instant().plus(timeout);
        if (!this.compositeOutputStream.closePipeLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Command process is still handling stdout/stderr");
        }
        return this.compositeOutputStream.stringOutputStream.await(Duration.between(Clock.systemUTC().instant(), deadline));
    }

    private static class CompositeOutputStream
    extends OutputStream {
        private final boolean writeToString;
        private final AtomicBoolean writeToPipe;
        private final CountDownLatch closePipeLatch;
        private final AtomicInteger restCloseCount;
        private final StringOutputStream stringOutputStream = new StringOutputStream();
        private final PipedOutputStream pipedOutputStream = new PipedOutputStream();

        private CompositeOutputStream(boolean writeToString, boolean writeToPipe, int restCloseCount) {
            this.writeToString = writeToString;
            this.writeToPipe = new AtomicBoolean(writeToPipe);
            this.closePipeLatch = new CountDownLatch(writeToPipe ? 1 : 0);
            this.restCloseCount = new AtomicInteger(restCloseCount);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.writeToString) {
                this.stringOutputStream.write(b);
            }
            if (this.writeToPipe.get()) {
                this.pipedOutputStream.write(b);
                this.pipedOutputStream.flush();
            }
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            if (this.writeToString) {
                this.stringOutputStream.flush();
            }
            if (this.writeToPipe.get()) {
                this.pipedOutputStream.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.restCloseCount.decrementAndGet() <= 0) {
                super.close();
                this.stringOutputStream.close();
                this.pipedOutputStream.close();
            }
        }
    }

    private static class StringOutputStream
    extends ByteArrayOutputStream {
        private final CountDownLatch closeLatch = new CountDownLatch(1);
        private final Object lock = new Object();
        private volatile String string;

        private StringOutputStream() {
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closeLatch.countDown();
        }

        private boolean isClosed() {
            return this.closeLatch.getCount() == 0L;
        }

        private String await() throws InterruptedException {
            this.closeLatch.await();
            return this.getString();
        }

        private String await(Duration timeout) throws InterruptedException, TimeoutException {
            if (!this.closeLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Command process stdout/stderr stream is still open");
            }
            return this.getString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getString() {
            if (this.string == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.string == null) {
                        this.string = new String(this.buf, 0, this.count, StandardCharsets.UTF_8);
                    }
                }
            }
            return this.string;
        }
    }
}

