/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.base;

import com.google.devtools.mobileharness.shared.util.base.BinaryPrefix;
import com.google.devtools.mobileharness.shared.util.base.SizeUnit;
import com.google.errorprone.annotations.Immutable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import javax.annotation.Nullable;

@Immutable
public final class DataSize
implements Comparable<DataSize> {
    public static final DataSize ZERO = new DataSize(BigInteger.ZERO);
    private final BigInteger bits;

    private DataSize(BigInteger bits) {
        this.bits = bits;
    }

    public static DataSize ofBits(long bits) {
        return new DataSize(BigInteger.valueOf(bits));
    }

    public static DataSize ofBytes(long bytes) {
        return DataSize.of(bytes, BinaryPrefix.UNIT, SizeUnit.BYTES);
    }

    public static DataSize of(long amount, BinaryPrefix prefix, SizeUnit unit) {
        return new DataSize(unit.toBits(BigInteger.valueOf(BinaryPrefix.UNIT.convert(amount, prefix))));
    }

    public long toBits() {
        return this.bits.longValueExact();
    }

    public long toBytes() {
        return this.to(BinaryPrefix.UNIT, SizeUnit.BYTES);
    }

    public long to(BinaryPrefix prefix, SizeUnit unit) {
        return prefix.convert(unit.fromBits(this.bits).longValueExact(), BinaryPrefix.UNIT);
    }

    public DataSize plus(DataSize other) {
        if (other.isZero()) {
            return this;
        }
        return new DataSize(this.bits.add(other.bits));
    }

    public DataSize minus(DataSize other) {
        if (other.isZero()) {
            return this;
        }
        return new DataSize(this.bits.subtract(other.bits));
    }

    public DataSize multipliedBy(double multiplicand) {
        if (multiplicand == 0.0) {
            return ZERO;
        }
        if (multiplicand == 1.0) {
            return this;
        }
        BigDecimal newBits = new BigDecimal(this.bits).multiply(BigDecimal.valueOf(multiplicand)).setScale(0, RoundingMode.DOWN);
        return new DataSize(newBits.toBigIntegerExact());
    }

    public boolean isZero() {
        return this.bits.signum() == 0;
    }

    @Override
    public int compareTo(DataSize other) {
        return this.bits.compareTo(other.bits);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataSize) {
            DataSize other = (DataSize)obj;
            return Objects.equals(this.bits, other.bits);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.bits);
    }

    public String toString() {
        if (this.bits.equals(BigInteger.ZERO)) {
            return "0B";
        }
        BinaryPrefix largestPrefix = BinaryPrefix.getLargestPrefix(this.bytes());
        if (largestPrefix == BinaryPrefix.UNIT) {
            return String.format("%dB", this.bytes());
        }
        double value = (double)this.bytes() / (double)BinaryPrefix.UNIT.convert(1L, largestPrefix);
        return String.format("%.1f%ciB", value, Character.valueOf(largestPrefix.name().charAt(0)));
    }

    private long bytes() {
        return this.toBytes();
    }
}

