/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.context;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.devtools.mobileharness.shared.context.AutoValue_InvocationContextExecutors_SubmitMethod;
import com.google.devtools.mobileharness.shared.context.InvocationContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class InvocationContextExecutors {
    private static final ImmutableMap<Method, SubmitMethod> SUBMIT_METHODS;

    public static <T extends Executor> T propagatingContext(T executor, Class<T> interfaceType) {
        return (T)InvocationContextExecutors.proxying(executor, interfaceType, InvocationContextPropagator::new, InvocationContextPropagator.class);
    }

    private static <T, I extends T, H extends InvocationHandler> T proxying(T object, Class<I> interfaceType, Function<T, H> handlerCreator, Class<H> handlerType) {
        if (Proxy.isProxyClass(object.getClass()) && handlerType.isAssignableFrom(Proxy.getInvocationHandler(object).getClass())) {
            return object;
        }
        return (T)interfaceType.cast(Proxy.newProxyInstance(InvocationContextExecutors.class.getClassLoader(), new Class[]{interfaceType}, (InvocationHandler)handlerCreator.apply(object)));
    }

    private InvocationContextExecutors() {
    }

    static {
        try {
            SUBMIT_METHODS = ImmutableList.of(SubmitMethod.of(Executor.class.getDeclaredMethod("execute", Runnable.class), 0, Runnable.class), SubmitMethod.of(ExecutorService.class.getDeclaredMethod("submit", Runnable.class), 0, Runnable.class), SubmitMethod.of(ExecutorService.class.getDeclaredMethod("submit", Runnable.class, Object.class), 0, Runnable.class), SubmitMethod.of(ExecutorService.class.getDeclaredMethod("submit", Callable.class), 0, Callable.class), SubmitMethod.of(ExecutorService.class.getDeclaredMethod("invokeAll", Collection.class), 0, Collection.class), SubmitMethod.of(ExecutorService.class.getDeclaredMethod("invokeAll", Collection.class, Long.TYPE, TimeUnit.class), 0, Collection.class), SubmitMethod.of(ExecutorService.class.getDeclaredMethod("invokeAny", Collection.class), 0, Collection.class), SubmitMethod.of(ExecutorService.class.getDeclaredMethod("invokeAny", Collection.class, Long.TYPE, TimeUnit.class), 0, Collection.class), SubmitMethod.of(ListeningExecutorService.class.getDeclaredMethod("submit", Runnable.class), 0, Runnable.class), SubmitMethod.of(ListeningExecutorService.class.getDeclaredMethod("submit", Runnable.class, Object.class), 0, Runnable.class), SubmitMethod.of(ListeningExecutorService.class.getDeclaredMethod("submit", Callable.class), 0, Callable.class), SubmitMethod.of(ListeningExecutorService.class.getDeclaredMethod("invokeAll", Collection.class), 0, Collection.class), new SubmitMethod[]{SubmitMethod.of(ListeningExecutorService.class.getDeclaredMethod("invokeAll", Collection.class, Long.TYPE, TimeUnit.class), 0, Collection.class), SubmitMethod.of(ListeningExecutorService.class.getDeclaredMethod("invokeAll", Collection.class, Duration.class), 0, Collection.class), SubmitMethod.of(ListeningExecutorService.class.getDeclaredMethod("invokeAny", Collection.class, Duration.class), 0, Collection.class), SubmitMethod.of(ScheduledExecutorService.class.getDeclaredMethod("schedule", Runnable.class, Long.TYPE, TimeUnit.class), 0, Runnable.class), SubmitMethod.of(ScheduledExecutorService.class.getDeclaredMethod("schedule", Callable.class, Long.TYPE, TimeUnit.class), 0, Callable.class), SubmitMethod.of(ScheduledExecutorService.class.getDeclaredMethod("scheduleAtFixedRate", Runnable.class, Long.TYPE, Long.TYPE, TimeUnit.class), 0, Runnable.class), SubmitMethod.of(ScheduledExecutorService.class.getDeclaredMethod("scheduleWithFixedDelay", Runnable.class, Long.TYPE, Long.TYPE, TimeUnit.class), 0, Runnable.class), SubmitMethod.of(ListeningScheduledExecutorService.class.getDeclaredMethod("schedule", Runnable.class, Long.TYPE, TimeUnit.class), 0, Runnable.class), SubmitMethod.of(ListeningScheduledExecutorService.class.getDeclaredMethod("schedule", Runnable.class, Duration.class), 0, Runnable.class), SubmitMethod.of(ListeningScheduledExecutorService.class.getDeclaredMethod("schedule", Callable.class, Long.TYPE, TimeUnit.class), 0, Callable.class), SubmitMethod.of(ListeningScheduledExecutorService.class.getDeclaredMethod("schedule", Callable.class, Duration.class), 0, Callable.class), SubmitMethod.of(ListeningScheduledExecutorService.class.getDeclaredMethod("scheduleAtFixedRate", Runnable.class, Long.TYPE, Long.TYPE, TimeUnit.class), 0, Runnable.class), SubmitMethod.of(ListeningScheduledExecutorService.class.getDeclaredMethod("scheduleAtFixedRate", Runnable.class, Duration.class, Duration.class), 0, Runnable.class), SubmitMethod.of(ListeningScheduledExecutorService.class.getDeclaredMethod("scheduleWithFixedDelay", Runnable.class, Long.TYPE, Long.TYPE, TimeUnit.class), 0, Runnable.class), SubmitMethod.of(ListeningScheduledExecutorService.class.getDeclaredMethod("scheduleWithFixedDelay", Runnable.class, Duration.class, Duration.class), 0, Runnable.class)}).stream().collect(ImmutableMap.toImmutableMap(SubmitMethod::method, Function.identity()));
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError("Failed to load methods of executors", e);
        }
    }

    private static class InvocationContextPropagator
    implements InvocationHandler {
        private final Executor executor;

        private InvocationContextPropagator(Executor executor) {
            this.executor = executor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object returnValue;
            SubmitMethod submitMethod = SUBMIT_METHODS.get(method);
            if (submitMethod != null) {
                InvocationContextPropagator.propagateContext(args, submitMethod);
            }
            try {
                returnValue = method.invoke((Object)this.executor, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            return InvocationContextPropagator.decorateListenableFuture(returnValue);
        }

        private static void propagateContext(Object[] args, SubmitMethod submitMethod) {
            int index = submitMethod.runnableArgumentIndex();
            if (submitMethod.runnableArgumentType().equals(Runnable.class)) {
                args[index] = InvocationContext.propagateContext((Runnable)args[index]);
            } else if (submitMethod.runnableArgumentType().equals(Callable.class)) {
                args[index] = InvocationContext.propagateContext((Callable)args[index]);
            } else if (submitMethod.runnableArgumentType().equals(Collection.class)) {
                args[index] = ((Collection)args[index]).stream().map(InvocationContext::propagateContext).collect(ImmutableList.toImmutableList());
            }
        }

        private static Object decorateListenableFuture(Object object) {
            if (object instanceof ListenableFuture) {
                ListenableFuture future = (ListenableFuture)object;
                Class interfaceType = future instanceof ListenableScheduledFuture ? ListenableScheduledFuture.class : ListenableFuture.class;
                return InvocationContextExecutors.proxying(future, interfaceType, ListenableFutureWithContext::new, ListenableFutureWithContext.class);
            }
            return object;
        }
    }

    @AutoValue
    static abstract class SubmitMethod {
        SubmitMethod() {
        }

        abstract Method method();

        abstract int runnableArgumentIndex();

        abstract Class<?> runnableArgumentType();

        private static SubmitMethod of(Method method, int runnableArgumentIndex, Class<?> runnableArgumentType) {
            return new AutoValue_InvocationContextExecutors_SubmitMethod(method, runnableArgumentIndex, runnableArgumentType);
        }
    }

    private static class ListenableFutureWithContext
    implements InvocationHandler {
        private static final Method ADD_LISTENER_METHOD;
        private final ListenableFuture<?> future;

        private ListenableFutureWithContext(ListenableFuture<?> future) {
            this.future = future;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(ADD_LISTENER_METHOD)) {
                args[0] = InvocationContext.propagateContext((Runnable)args[0]);
            }
            try {
                return method.invoke(this.future, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        static {
            try {
                ADD_LISTENER_METHOD = ListenableFuture.class.getDeclaredMethod("addListener", Runnable.class, Executor.class);
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError("Failed to load methods of ListenableFuture", e);
            }
        }
    }
}

